package RISCOS::DrawFile::OpaqueObject;
use Carp;

use strict;
use vars qw ($VERSION @ISA);

require RISCOS::DrawFile::Object;

$VERSION = 0.01;
@ISA = 'RISCOS::DrawFile::Object';

sub new ($$) {
    my $proto = shift;
    my $class = ref($proto) || $proto;

    carp "Cannot make a $proto from a " . ref ($_[0]) if ref ($_[0]);

    my ($self, $type) = $class->SUPER::new (@_);
    return $self if ref ($self) eq 'ARRAY';

    my ($bbox, $length) = [];
    ($length, @$bbox) = unpack 'x4Ii4', $_[0];
    return undef unless length ($_[0]) == $length or $length & 3;

    $self->{'__TYPE'} = $type;
    $self->{'__BBOX'} = $bbox;
    $self->{'__DATA'} = substr $_[0], 24;
    
    wantarray ? ($self, $type) : $self;
}

sub BBox {
    my $self = shift;
    $self->{'__BBOX'};
}

*BBox_Calc = \&BBox;

sub Size {
    my $self = shift;
    24 + length $self->{'__DATA'};
}

sub Pack {
    my $self = shift;
    $self->PackTypeSizeBBox() . $self->{'__DATA'};
}

# Just in case we have a huge thing
sub Write {
    my $self = shift;
    print {$_[0]} $self->PackTypeSizeBBox(), $self->{'__DATA'};
}

1;
__END__

=head1 NAME

RISCOS::DrawFile::OpaqueObject

=head1 SYNOPSIS

Class to handle unrecognised objects in DrawFiles

=head1 DESCRIPTION

C<RISCOS::DrawFile::OpaqueObject> provides a class that stores any object from
a DrawFile without needing to know its contents. TextAreas, Options, Paths,
Sprites and JPEGs were stored as opaque objects during DrawFile development,
before specific classes were written to manipulate them.

=head1 BUGS

None known.

=head1 AUTHOR

Nicholas Clark <F<nick@unfortu.net>>
