/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Library
extends ElectricObject {
    public static final Variable.Key FONT_ASSOCIATIONS = ElectricObject.newKey("LIB_font_associations");
    private static final int LIBCHANGEDMAJOR = 1;
    private static final int READFROMDISK = 4;
    private static final int LIBUNITS = 56;
    private static final int LIBUNITSSH = 3;
    private static final int LIBCHANGEDMINOR = 64;
    private static final int HIDDENLIBRARY = 128;
    private String libName;
    private URL libFile;
    private ArrayList cells;
    private Cell curCell;
    private int userBits;
    private int flagBits;
    private static List libraries = new ArrayList();
    private static Library curLib = null;
    private static FlagSet.Generator flagGenerator = new FlagSet.Generator("Library");

    private Library() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Library newInstance(String libName, URL libFile) {
        Library existingLibrary;
        String legalName = libName.replace(' ', '-');
        if (!legalName.equalsIgnoreCase(libName)) {
            System.out.println("Warning: library renamed to '" + legalName + "'");
        }
        if ((existingLibrary = Library.findLibrary(legalName)) != null) {
            System.out.println("Error: library '" + legalName + "' already exists");
            return null;
        }
        Library lib = new Library();
        lib.cells = new ArrayList();
        lib.curCell = null;
        lib.libName = legalName;
        lib.libFile = libFile;
        List list = libraries;
        synchronized (list) {
            libraries.add(lib);
        }
        return lib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean kill() {
        Library newCurLib = null;
        if (curLib == this) {
            Iterator it = Library.getLibraries();
            while (it.hasNext()) {
                Library lib = (Library)it.next();
                if (lib == curLib || lib.isHidden()) continue;
                newCurLib = lib;
                break;
            }
            if (newCurLib == null) {
                System.out.println("Cannot delete the last library");
                return false;
            }
        }
        if (!libraries.contains(this)) {
            System.out.println("Cannot delete library " + this);
            return false;
        }
        this.erase();
        List list = libraries;
        synchronized (list) {
            libraries.remove(this);
        }
        if (newCurLib != null) {
            newCurLib.setCurrent();
        }
        return true;
    }

    public void erase() {
        this.cells.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCell(Cell c) {
        ArrayList arrayList = this.cells;
        synchronized (arrayList) {
            if (this.cells.contains(c)) {
                System.out.println("Tried to re-add a cell to a library: " + c);
                return;
            }
            this.cells.add(c);
        }
        WindowFrame.wantToRedoLibraryTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCell(Cell c) {
        ArrayList arrayList = this.cells;
        synchronized (arrayList) {
            if (!this.cells.contains(c)) {
                System.out.println("Tried to remove a non-existant Cell from a library: " + c);
                return;
            }
            this.cells.remove(c);
        }
        WindowFrame.wantToRedoLibraryTree();
    }

    public int checkAndRepair() {
        int errorCount = 0;
        Iterator it = this.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            errorCount += cell.checkAndRepair();
        }
        return errorCount;
    }

    public void setChangedMajor() {
        this.userBits |= 1;
    }

    public void clearChangedMajor() {
        this.userBits &= 0xFFFFFFFE;
    }

    public boolean isChangedMajor() {
        return (this.userBits & 1) != 0;
    }

    public void setChangedMinor() {
        this.userBits |= 0x40;
    }

    public void clearChangedMinor() {
        this.userBits &= 0xFFFFFFBF;
    }

    public boolean isChangedMinor() {
        return (this.userBits & 0x40) != 0;
    }

    public void setFromDisk() {
        this.userBits |= 4;
    }

    public void clearFromDisk() {
        this.userBits &= 0xFFFFFFFB;
    }

    public boolean isFromDisk() {
        return (this.userBits & 4) != 0;
    }

    public void setHidden() {
        this.userBits |= 0x80;
    }

    public void clearHidden() {
        this.userBits &= 0xFFFFFF7F;
    }

    public boolean isHidden() {
        return (this.userBits & 0x80) != 0;
    }

    public void setUnits(int value) {
        this.userBits = this.userBits & 0xFFFFFFC7 | value << 3;
    }

    public int getUnits() {
        return (this.userBits & 0x38) >> 3;
    }

    public static Library getCurrent() {
        return curLib;
    }

    public void setCurrent() {
        curLib = this;
    }

    public int lowLevelGetUserBits() {
        return this.userBits;
    }

    public void lowLevelSetUserBits(int userBits) {
        this.userBits = userBits;
    }

    public static Library findLibrary(String libName) {
        for (int i = 0; i < libraries.size(); ++i) {
            Library l = (Library)libraries.get(i);
            if (!l.getName().equalsIgnoreCase(libName)) continue;
            return l;
        }
        return null;
    }

    public static void clearChangeLocks() {
        for (int i = 0; i < libraries.size(); ++i) {
            Library l = (Library)libraries.get(i);
            for (int j = 0; j < l.cells.size(); ++j) {
                Cell c = (Cell)l.cells.get(j);
                c.clearChangeLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getLibraries() {
        ArrayList librariesCopy = new ArrayList();
        List list = libraries;
        synchronized (list) {
            librariesCopy.addAll(libraries);
        }
        return librariesCopy.iterator();
    }

    public static int getNumLibraries() {
        return libraries.size();
    }

    public static Iterator getVisibleLibraries() {
        return new VisibleLibraryIterator();
    }

    public static int getNumVisibleLibraries() {
        int numVis = 0;
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (lib.isHidden()) continue;
            ++numVis;
        }
        return numVis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getVisibleLibrariesSortedByName() {
        ArrayList sortedList = new ArrayList();
        List list = libraries;
        synchronized (list) {
            VisibleLibraryIterator it = new VisibleLibraryIterator();
            while (it.hasNext()) {
                sortedList.add(it.next());
            }
        }
        Collections.sort(sortedList, new LibCaseInsensitive());
        return sortedList;
    }

    public String getName() {
        return this.libName;
    }

    public boolean setName(String libName) {
        if (this.libName.equals(libName)) {
            return true;
        }
        Library already = Library.findLibrary(libName);
        if (already != null) {
            System.out.println("Already a library called " + already.getName());
            return true;
        }
        Name oldName = Name.findName(this.libName);
        this.lowLevelRename(libName);
        Undo.renameObject(this, oldName);
        return false;
    }

    public void lowLevelRename(String libName) {
        this.libName = libName;
        String newLibFile = TextUtils.getFilePath(this.libFile) + libName;
        String extension = TextUtils.getExtension(this.libFile);
        if (extension.length() > 0) {
            newLibFile = newLibFile + "." + extension;
        }
        this.libFile = TextUtils.makeURLToFile(newLibFile);
        WindowFrame.wantToRedoLibraryTree();
    }

    public URL getLibFile() {
        return this.libFile;
    }

    public void setLibFile(URL libFile) {
        this.libFile = libFile;
    }

    public static FlagSet getFlagSet(int numBits) {
        return FlagSet.getFlagSet(flagGenerator, numBits);
    }

    public void setBit(FlagSet set) {
        this.flagBits |= set.getMask();
    }

    public void clearBit(FlagSet set) {
        this.flagBits &= set.getUnmask();
    }

    public boolean isBit(FlagSet set) {
        return (this.flagBits & set.getMask()) != 0;
    }

    public String toString() {
        return "Library " + this.libName;
    }

    public Cell getCurCell() {
        return this.curCell;
    }

    public void setCurCell(Cell curCell) {
        this.curCell = curCell;
    }

    public Cell findNodeProto(String name) {
        CellName n = CellName.parseName(name);
        if (n == null) {
            return null;
        }
        Cell onlyWithName = null;
        Iterator it = this.cells.iterator();
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            if (!n.getName().equalsIgnoreCase(c.getName())) continue;
            onlyWithName = c;
            if (n.getView() != c.getView() || n.getVersion() > 0 && n.getVersion() != c.getVersion()) continue;
            return c;
        }
        if (n.getView() == View.UNKNOWN && onlyWithName != null) {
            return onlyWithName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getCells() {
        ArrayList cellsCopy = new ArrayList();
        ArrayList arrayList = this.cells;
        synchronized (arrayList) {
            cellsCopy.addAll(this.cells);
        }
        return cellsCopy.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCellsSortedByName() {
        ArrayList sortedList = new ArrayList();
        ArrayList arrayList = this.cells;
        synchronized (arrayList) {
            Iterator it = this.getCells();
            while (it.hasNext()) {
                sortedList.add(it.next());
            }
        }
        Collections.sort(sortedList, new CellCaseInsensitive());
        return sortedList;
    }

    public static List getCellsSortedByName(List cellList) {
        ArrayList sortedList = new ArrayList();
        sortedList.addAll(cellList);
        Collections.sort(sortedList, new CellComparatorNoLibDescribe());
        return sortedList;
    }

    private static class CellComparatorNoLibDescribe
    implements Comparator {
        private CellComparatorNoLibDescribe() {
        }

        public int compare(Object o1, Object o2) {
            Cell c1 = (Cell)o1;
            Cell c2 = (Cell)o2;
            String s1 = c1.noLibDescribe();
            String s2 = c2.noLibDescribe();
            return s1.compareTo(s2);
        }
    }

    private static class CellCaseInsensitive
    implements Comparator {
        private CellCaseInsensitive() {
        }

        public int compare(Object o1, Object o2) {
            Cell c1 = (Cell)o1;
            Cell c2 = (Cell)o2;
            String s1 = c1.describe();
            String s2 = c2.describe();
            return s1.compareToIgnoreCase(s2);
        }
    }

    private static class LibCaseInsensitive
    implements Comparator {
        private LibCaseInsensitive() {
        }

        public int compare(Object o1, Object o2) {
            Library l1 = (Library)o1;
            Library l2 = (Library)o2;
            String s1 = l1.getName();
            String s2 = l2.getName();
            return s1.compareToIgnoreCase(s2);
        }
    }

    private static class VisibleLibraryIterator
    implements Iterator {
        private Iterator uit = Library.getLibraries();
        private Library nextLib = this.nextLibrary();

        VisibleLibraryIterator() {
        }

        private Library nextLibrary() {
            while (this.uit.hasNext()) {
                Library lib = (Library)this.uit.next();
                if (lib.isHidden()) continue;
                return lib;
            }
            return null;
        }

        public boolean hasNext() {
            return this.nextLib != null;
        }

        public Object next() {
            if (this.nextLib == null) {
                return this.uit.next();
            }
            Library lib = this.nextLib;
            this.nextLib = this.nextLibrary();
            return lib;
        }

        public void remove() {
            throw new UnsupportedOperationException("VisibleLibraryIterator.remove()");
        }
    }
}

