/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.output.CIF;
import com.sun.electric.tool.io.output.ELIB;
import com.sun.electric.tool.io.output.GDS;
import com.sun.electric.tool.io.output.IRSIM;
import com.sun.electric.tool.io.output.Maxwell;
import com.sun.electric.tool.io.output.PostScript;
import com.sun.electric.tool.io.output.ReadableDump;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class Output {
    protected String filePath;
    protected PrintWriter printWriter;
    protected DataOutputStream dataOutputStream;

    Output() {
    }

    protected boolean writeLib(Library lib) {
        return true;
    }

    protected boolean writeCell(Cell cell, VarContext context) {
        return true;
    }

    public static boolean writeLibrary(Library lib, OpenFile.Type type, boolean compatibleWith6) {
        block23: {
            URL libFile;
            block20: {
                String properOutputName;
                ELIB out;
                block22: {
                    File newFile;
                    int backupScheme;
                    block21: {
                        File newFile2;
                        Technology tech;
                        ArrayList<String> dummyCells = new ArrayList<String>();
                        dummyCells.add("WARNING: Library " + lib.getName() + " contains the following Dummy cells:");
                        Iterator it = lib.getCells();
                        while (it.hasNext()) {
                            Cell c = (Cell)it.next();
                            if (c.getVar(Input.IO_DUMMY_OBJECT) == null) continue;
                            dummyCells.add("   " + c.noLibDescribe());
                        }
                        if (dummyCells.size() > 1) {
                            dummyCells.add("Do you really want to write this library?");
                            Object[] options = new Object[]{"Continue Writing", "Cancel"};
                            int val = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), dummyCells.toArray(), "Dummy Cells Found in " + lib.getName(), -1, 2, null, options, options[1]);
                            if (val == 1) {
                                return true;
                            }
                        }
                        Pref.installMeaningVariables();
                        it = Tool.getListeners();
                        while (it.hasNext()) {
                            Listener listener = (Listener)it.next();
                            listener.writeLibrary(lib);
                        }
                        double largestScale = 0.0;
                        Iterator it2 = Technology.getTechnologies();
                        while (it2.hasNext()) {
                            tech = (Technology)it2.next();
                            if (tech.isScaleRelevant() || tech == Generic.tech || !(tech.getScale() > largestScale)) continue;
                            largestScale = tech.getScale();
                        }
                        it2 = Technology.getTechnologies();
                        while (it2.hasNext()) {
                            tech = (Technology)it2.next();
                            if (tech.isScaleRelevant() || tech == Generic.tech) continue;
                            tech.setScale(largestScale);
                        }
                        libFile = lib.getLibFile();
                        if (libFile == null) {
                            libFile = TextUtils.makeURLToFile(lib.getName());
                        }
                        if (type != OpenFile.Type.ELIB) break block20;
                        backupScheme = IOTool.getBackupRedundancy();
                        if (backupScheme != 1) break block21;
                        String backupFileName = libFile.getPath() + "~";
                        File oldFile = new File(backupFileName);
                        if (oldFile.exists()) {
                            oldFile.delete();
                        }
                        if (!(newFile2 = new File(libFile.getPath())).exists()) break block22;
                        newFile2.renameTo(oldFile);
                        break block22;
                    }
                    if (backupScheme == 2 && (newFile = new File(libFile.getPath())).exists()) {
                        long modified = newFile.lastModified();
                        Date modifiedDate = new Date(modified);
                        SimpleDateFormat sdf = new SimpleDateFormat("-yyyy-MM-dd");
                        for (int i = 0; i < 1000; ++i) {
                            File oldFile;
                            String backupFileName = TextUtils.getFileNameWithoutExtension(libFile) + sdf.format(modifiedDate);
                            if (i != 0) {
                                backupFileName = backupFileName + "--" + i;
                            }
                            if ((oldFile = new File(backupFileName = backupFileName + "." + TextUtils.getExtension(libFile))).exists()) continue;
                            newFile.renameTo(oldFile);
                            break;
                        }
                    }
                }
                ELIB elib = new ELIB();
                if (compatibleWith6) {
                    elib.write6Compatible();
                }
                if ((out = elib).openBinaryOutputStream(properOutputName = TextUtils.getFilePath(libFile) + TextUtils.getFileNameWithoutExtension(libFile) + ".elib")) {
                    return true;
                }
                if (((Output)out).writeLib(lib)) {
                    return true;
                }
                if (out.closeBinaryOutputStream()) {
                    return true;
                }
                break block23;
            }
            if (type == OpenFile.Type.READABLEDUMP) {
                ReadableDump out = new ReadableDump();
                String properOutputName = TextUtils.getFilePath(libFile) + TextUtils.getFileNameWithoutExtension(libFile) + ".txt";
                if (out.openTextOutputStream(properOutputName)) {
                    return true;
                }
                if (((Output)out).writeLib(lib)) {
                    return true;
                }
                if (out.closeTextOutputStream()) {
                    return true;
                }
            } else {
                System.out.println("Unknown export type: " + type);
                return true;
            }
        }
        return false;
    }

    public static void writeCell(Cell cell, VarContext context, String filePath, OpenFile.Type type) {
        if (type == OpenFile.Type.CDL) {
            Spice.writeSpiceFile(cell, context, filePath, true);
        } else if (type == OpenFile.Type.CIF) {
            CIF.writeCIFFile(cell, context, filePath);
        } else if (type == OpenFile.Type.GDS) {
            GDS.writeGDSFile(cell, context, filePath);
        } else if (type == OpenFile.Type.MAXWELL) {
            Maxwell.writeMaxwellFile(cell, context, filePath);
        } else if (type == OpenFile.Type.POSTSCRIPT) {
            PostScript.writePostScriptFile(cell, context, filePath);
        } else if (type == OpenFile.Type.SPICE) {
            Spice.writeSpiceFile(cell, context, filePath, false);
        } else if (type == OpenFile.Type.VERILOG) {
            Verilog.writeVerilogFile(cell, context, filePath);
        } else if (type == OpenFile.Type.IRSIM) {
            IRSIM.writeIRSIMFile(cell, context, filePath);
        }
    }

    public static void createFontAssociationVariable(Library lib) {
        Iterator aIt;
        Iterator pIt;
        Iterator nIt;
        int maxIndices = TextDescriptor.ActiveFont.getMaxIndex();
        if (maxIndices == 0) {
            return;
        }
        boolean[] fontFound = new boolean[maxIndices];
        for (int i = 0; i < maxIndices; ++i) {
            fontFound[i] = false;
        }
        Output.checkFontUsage(lib, fontFound);
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            Output.checkFontUsage(cell, fontFound);
            nIt = cell.getNodes();
            while (nIt.hasNext()) {
                NodeInst ni = (NodeInst)nIt.next();
                Output.checkFontUsage(ni, fontFound);
                Output.updateFontUsage(ni.getNameTextDescriptor(), fontFound);
                if (ni.getProto() instanceof Cell) {
                    Output.updateFontUsage(ni.getProtoTextDescriptor(), fontFound);
                }
                pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = (PortInst)pIt.next();
                    Output.checkFontUsage(pi, fontFound);
                }
            }
            aIt = cell.getArcs();
            while (aIt.hasNext()) {
                ArcInst ai = (ArcInst)aIt.next();
                Output.checkFontUsage(ai, fontFound);
                Output.updateFontUsage(ai.getNameTextDescriptor(), fontFound);
            }
            Iterator eIt = cell.getPorts();
            while (eIt.hasNext()) {
                Export pp = (Export)eIt.next();
                Output.checkFontUsage(pp, fontFound);
                Output.updateFontUsage(pp.getTextDescriptor(), fontFound);
            }
        }
        it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = (Technology)it.next();
            Output.checkFontUsage(tech, fontFound);
            nIt = tech.getNodes();
            while (nIt.hasNext()) {
                PrimitiveNode np = (PrimitiveNode)nIt.next();
                Output.checkFontUsage(np, fontFound);
                pIt = np.getPorts();
                while (pIt.hasNext()) {
                    PrimitivePort pp = (PrimitivePort)pIt.next();
                    Output.checkFontUsage(pp, fontFound);
                }
            }
            aIt = tech.getArcs();
            while (aIt.hasNext()) {
                PrimitiveArc ap = (PrimitiveArc)aIt.next();
                Output.checkFontUsage(ap, fontFound);
            }
        }
        it = Tool.getTools();
        while (it.hasNext()) {
            Tool tool = (Tool)it.next();
            Output.checkFontUsage(tool, fontFound);
        }
        it = View.getViews();
        while (it.hasNext()) {
            View view = (View)it.next();
            Output.checkFontUsage(view, fontFound);
        }
        ArrayList<String> associations = new ArrayList<String>();
        for (int i = 0; i < maxIndices; ++i) {
            TextDescriptor.ActiveFont af;
            if (!fontFound[i] || (af = TextDescriptor.ActiveFont.findActiveFont(i + 1)) == null) continue;
            String association = Integer.toString(i + 1) + "/" + af.getName();
            associations.add(association);
        }
        int numAssociations = associations.size();
        if (numAssociations == 0) {
            return;
        }
        String[] assocArray = new String[numAssociations];
        int i = 0;
        Iterator it2 = associations.iterator();
        while (it2.hasNext()) {
            assocArray[i++] = (String)it2.next();
        }
        lib.newVar(Library.FONT_ASSOCIATIONS, (Object)assocArray);
    }

    private static void checkFontUsage(ElectricObject eobj, boolean[] fontFound) {
        Iterator it = eobj.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            Output.updateFontUsage(var.getTextDescriptor(), fontFound);
        }
    }

    private static void updateFontUsage(TextDescriptor td, boolean[] fontFound) {
        int fontIndex = td.getFace();
        if (fontIndex == 0) {
            return;
        }
        fontFound[fontIndex - 1] = true;
    }

    protected boolean openBinaryOutputStream(String filePath) {
        FileOutputStream fileOutputStream;
        this.filePath = filePath;
        try {
            fileOutputStream = new FileOutputStream(filePath);
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not write file " + filePath);
            System.out.println("Reason: " + e.getMessage());
            return true;
        }
        BufferedOutputStream bufStrm = new BufferedOutputStream(fileOutputStream);
        this.dataOutputStream = new DataOutputStream(bufStrm);
        return false;
    }

    protected boolean closeBinaryOutputStream() {
        try {
            this.dataOutputStream.close();
        }
        catch (IOException e) {
            System.out.println("Error closing " + this.filePath);
            return true;
        }
        return false;
    }

    protected boolean openTextOutputStream(String filePath) {
        this.filePath = filePath;
        try {
            this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
        }
        catch (IOException e) {
            System.out.println("Error opening " + filePath);
            return true;
        }
        return false;
    }

    protected void emitCopyright(String prefix, String postfix) {
        if (!IOTool.isUseCopyrightMessage()) {
            return;
        }
        String str = IOTool.getCopyrightMessage();
        int start = 0;
        while (start < str.length()) {
            int endPos = str.indexOf(10, start);
            if (endPos < 0) {
                endPos = str.length();
            }
            String oneLine = str.substring(start, endPos);
            this.printWriter.println(prefix + oneLine + postfix);
            start = endPos + 1;
        }
    }

    public Rectangle2D getAreaToPrint(Cell cell, boolean reduce) {
        Rectangle2D bounds = cell.getBounds();
        if (reduce) {
            double wid = bounds.getWidth() * 0.75;
            double hei = bounds.getHeight() * 0.75;
            bounds.setRect(bounds.getCenterX(), bounds.getCenterY(), wid, hei);
        }
        if (IOTool.getPlotArea() != 0) {
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd == null) {
                System.out.println("No current window: printing entire cell");
            } else if (IOTool.getPlotArea() == 2) {
                bounds = wnd.getDisplayedBounds();
            } else {
                Rectangle2D hBounds = Highlight.getHighlightedArea(wnd);
                if (hBounds == null || hBounds.getWidth() == 0.0 || hBounds.getHeight() == 0.0) {
                    System.out.println("Warning: no highlighted area; printing entire cell");
                } else {
                    bounds = hBounds;
                }
            }
        }
        return bounds;
    }

    protected boolean closeTextOutputStream() {
        this.printWriter.close();
        return false;
    }
}

