/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.logicaleffort.Instance;
import com.sun.electric.tool.logicaleffort.LESizer;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.logicaleffort.Net;
import com.sun.electric.tool.logicaleffort.Pin;
import com.sun.electric.tool.user.ui.MessagesWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LENetlister
extends HierarchyEnumerator.Visitor {
    private float su;
    private float wireRatio;
    private float epsilon;
    private int maxIterations;
    private float gateCap;
    private float alpha;
    private float keeperRatio;
    private HashMap allNets;
    private HashMap allInstances;
    private LESizer.Alg algorithm;
    private LESizer sizer;
    private Job job;
    private PrintStream out;
    private HashMap instancesMap;
    private boolean aborted;
    private static final boolean DEBUG = false;

    public LENetlister(LESizer.Alg algorithm, Job job) {
        Tool leTool = Tool.findTool("logical effort");
        this.su = (float)LETool.getGlobalFanout();
        this.epsilon = (float)LETool.getConvergenceEpsilon();
        this.maxIterations = LETool.getMaxIterations();
        this.gateCap = (float)LETool.getGateCapacitance();
        this.wireRatio = (float)LETool.getWireRatio();
        this.alpha = (float)LETool.getDiffAlpha();
        this.keeperRatio = (float)LETool.getKeeperRatio();
        this.allNets = new HashMap();
        this.allInstances = new HashMap();
        this.algorithm = algorithm;
        this.job = job;
        this.instancesMap = new HashMap();
        this.out = new PrintStream(System.out);
        this.aborted = false;
    }

    protected void netlist(Cell cell, VarContext context) {
        Netlist netlist = cell.getNetlist(true);
        Iterator instIt = cell.getNodes();
        while (instIt.hasNext()) {
            NodeInst ni = (NodeInst)instIt.next();
            if (ni.getVar("ATTR_LESETTINGS") == null) continue;
            this.useLESettings(ni, context);
            break;
        }
        HierarchyEnumerator.enumerateCell(cell, context, netlist, this);
    }

    public boolean size() {
        boolean verbose = false;
        this.sizer = new LESizer(this.algorithm, this, this.job);
        boolean success = this.sizer.optimizeLoops(this.epsilon, this.maxIterations, verbose, this.alpha, this.keeperRatio);
        this.sizer = null;
        return success;
    }

    public void updateSizes() {
        Set allEntries = this.allInstances.entrySet();
        Iterator it = allEntries.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Instance inst = (Instance)entry.getValue();
            Nodable no = inst.getNodable();
            String varName = "LEDRIVE_" + inst.getName();
            no.newVar(varName, (Object)new Float(inst.getLeX()));
        }
    }

    private void useLESettings(NodeInst ni, VarContext context) {
        Variable var = ni.getVar("ATTR_su");
        if (var != null) {
            this.su = VarContext.objectToFloat(context.evalVar(var), this.su);
        }
        if ((var = ni.getVar("ATTR_wire_ratio")) != null) {
            this.wireRatio = VarContext.objectToFloat(context.evalVar(var), this.wireRatio);
        }
        if ((var = ni.getVar("ATTR_epsilon")) != null) {
            this.epsilon = VarContext.objectToFloat(context.evalVar(var), this.epsilon);
        }
        if ((var = ni.getVar("ATTR_max_iter")) != null) {
            this.maxIterations = VarContext.objectToInt(context.evalVar(var), this.maxIterations);
        }
        if ((var = ni.getVar("ATTR_gate_cap")) != null) {
            this.gateCap = VarContext.objectToFloat(context.evalVar(var), this.gateCap);
        }
        if ((var = ni.getVar("ATTR_alpha")) != null) {
            this.alpha = VarContext.objectToFloat(context.evalVar(var), this.alpha);
        }
        if ((var = ni.getVar("ATTR_keeper_ratio")) != null) {
            this.keeperRatio = VarContext.objectToFloat(context.evalVar(var), this.keeperRatio);
        }
    }

    protected Instance addInstance(String name, Instance.Type type, float leSU, float leX, ArrayList pins, Nodable no) {
        if (this.allInstances.containsKey(name)) {
            this.out.println("Error: Instance " + name + " already exists.");
            return null;
        }
        Instance instance = new Instance(name, type, leSU, leX, no);
        Iterator iter = pins.iterator();
        while (iter.hasNext()) {
            Pin pin = (Pin)iter.next();
            String netname = pin.getNetName();
            Net net = (Net)this.allNets.get(netname);
            if (net != null) {
                pin.setNet(net);
                pin.setInstance(instance);
                net.addPin(pin);
                continue;
            }
            net = new Net(netname);
            this.allNets.put(netname, net);
            pin.setNet(net);
            pin.setInstance(instance);
            net.addPin(pin);
        }
        instance.setPins(pins);
        this.allInstances.put(name, instance);
        return instance;
    }

    protected HashMap getAllInstances() {
        return this.allInstances;
    }

    protected HashMap getAllNets() {
        return this.allNets;
    }

    protected int getNumGates() {
        return this.allInstances.size();
    }

    protected LESizer getSizer() {
        return this.sizer;
    }

    protected float getKeeperRatio() {
        return this.keeperRatio;
    }

    public HierarchyEnumerator.CellInfo newCellInfo() {
        return new LECellInfo();
    }

    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        if (this.aborted) {
            return false;
        }
        if (((LETool.AnalyzeCell)this.job).checkAbort(null)) {
            this.aborted = true;
            return false;
        }
        ((LECellInfo)info).leInit();
        return true;
    }

    public boolean visitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
        float nisu;
        float leX = 0.0f;
        boolean wire = false;
        boolean primitiveTransistor = false;
        Instance.Type type = null;
        Variable var = null;
        var = ni.getVar("ATTR_LEGATE");
        if (var != null) {
            int gate = VarContext.objectToInt(info.getContext().evalVar(var), 1);
            type = gate == 1 ? Instance.Type.LEGATE : Instance.Type.STATICGATE;
        } else {
            var = ni.getVar("ATTR_LEKEEPER");
            if (var != null) {
                int gate = VarContext.objectToInt(info.getContext().evalVar(var), 1);
                type = gate == 1 ? Instance.Type.LEKEEPER : Instance.Type.STATICGATE;
            } else if (ni.getVar("ATTR_LEWIRE") != null) {
                type = Instance.Type.WIRE;
                var = ni.getVar("ATTR_L");
                float len = VarContext.objectToFloat(info.getContext().evalVar(var), 0.0f);
                var = ni.getVar("ATTR_width");
                float width = VarContext.objectToFloat(info.getContext().evalVar(var), 3.0f);
                leX = (0.95f * len + 0.05f * len * (width / 3.0f)) * this.wireRatio;
                leX /= 9.0f;
                wire = true;
            } else if (ni.getProto() != null && ni.getProto().getFunction().isTransistor()) {
                type = Instance.Type.STATICGATE;
                var = ni.getVar("ATTR_width");
                if (var == null) {
                    System.out.println("Error: transistor " + ni + " has no width in Cell " + info.getCell());
                    return false;
                }
                float width = VarContext.objectToFloat(info.getContext().evalVar(var), 3.0f);
                var = ni.getVar("ATTR_length");
                if (var == null) {
                    System.out.println("Error: transistor " + ni + " has no length in Cell " + info.getCell());
                    return false;
                }
                float length = VarContext.objectToFloat(info.getContext().evalVar(var), 2.0f);
                leX = width * length / 2.0f;
                leX /= 9.0f;
                primitiveTransistor = true;
            } else if (ni.getVar("ATTR_LESETTINGS") != null) {
                return false;
            }
        }
        if (type == null) {
            return true;
        }
        ArrayList<Pin> pins = new ArrayList<Pin>();
        Netlist netlist = info.getNetlist();
        Iterator ppIt = ni.getProto().getPorts();
        while (ppIt.hasNext()) {
            PortProto pp = (PortProto)ppIt.next();
            var = pp.getVar("ATTR_le");
            float le = VarContext.objectToFloat(info.getContext().evalVar(var), 1.0f);
            String netName = info.getUniqueNetName(info.getNetID(netlist.getNetwork(ni, pp, 0)), ".");
            Pin.Dir dir = Pin.Dir.INPUT;
            if (pp.getCharacteristic() == PortProto.Characteristic.OUT) {
                dir = Pin.Dir.OUTPUT;
            }
            if (primitiveTransistor && pp.getCharacteristic() == PortProto.Characteristic.BIDIR) {
                dir = Pin.Dir.OUTPUT;
            }
            pins.add(new Pin(pp.getName(), dir, le, netName));
            if (type != Instance.Type.WIRE) continue;
            break;
        }
        float localsu = this.su;
        if (((LECellInfo)info).getSU() != -1.0f) {
            localsu = ((LECellInfo)info).getSU();
        }
        if ((var = ni.getVar("ATTR_su")) != null && (nisu = VarContext.objectToFloat(info.getContext().evalVar(var), -1.0f)) != -1.0f) {
            localsu = nisu;
        }
        VarContext vc = info.getContext().push(ni);
        Instance inst = this.addInstance(vc.getInstPath("."), type, localsu, leX, pins, ni);
        if (type == Instance.Type.LEGATE && (var = ni.getVar("ATTR_LEPARALLGRP")) != null) {
            int g = VarContext.objectToInt(info.getContext().evalVar(var), 0);
            inst.setParallelGroup(g);
        }
        if ((var = ni.getVar("ATTR_M")) != null) {
            int m = VarContext.objectToInt(info.getContext().evalVar(var), 1);
            inst.setMfactor((float)m * ((LECellInfo)info).getMFactor());
        }
        this.instancesMap.put(ni, inst);
        return false;
    }

    public void exitCell(HierarchyEnumerator.CellInfo info) {
    }

    public void printStatistics() {
        System.out.println("Total size of all instances (sized and loads): " + this.getTotalSize());
    }

    protected float getTotalSize() {
        Collection instances = this.getAllInstances().values();
        float totalsize = 0.0f;
        Iterator it = instances.iterator();
        while (it.hasNext()) {
            Instance inst = (Instance)it.next();
            totalsize += inst.getLeX();
        }
        return totalsize;
    }

    public boolean printResults(Nodable no) {
        Pin pin;
        Instance inst;
        if (no instanceof NodeInst) {
            no = Netlist.getNodableFor((NodeInst)no, 0);
        }
        if ((inst = (Instance)this.instancesMap.get(no)) == null) {
            return false;
        }
        MessagesWindow msgs = TopLevel.getMessagesWindow();
        System.out.println("Netlister: Gate Cap=" + this.gateCap + ", Alpha=" + this.alpha);
        inst.print();
        Pin out = (Pin)inst.getOutputPins().get(0);
        Net net = out.getNet();
        ArrayList<Pin> gatesDrivenPins = new ArrayList<Pin>();
        ArrayList<Pin> loadsDrivenPins = new ArrayList<Pin>();
        ArrayList<Pin> wiresDrivenPins = new ArrayList<Pin>();
        ArrayList<Pin> gatesFightingPins = new ArrayList<Pin>();
        Iterator it = net.getAllPins().iterator();
        while (it.hasNext()) {
            Pin pin2 = (Pin)it.next();
            Instance in = pin2.getInstance();
            if (pin2.getDir() == Pin.Dir.INPUT) {
                if (in.isGate()) {
                    gatesDrivenPins.add(pin2);
                }
                if (in.getType() == Instance.Type.LOAD) {
                    loadsDrivenPins.add(pin2);
                }
                if (in.getType() == Instance.Type.WIRE) {
                    wiresDrivenPins.add(pin2);
                }
            }
            if (pin2.getDir() != Pin.Dir.OUTPUT || !in.isGate()) continue;
            gatesFightingPins.add(pin2);
        }
        System.out.println("Note: Load = Size * LE * M");
        System.out.println("Note: Load = Size * LE * M * Alpha, for Gates Fighting");
        float totalLoad = 0.0f;
        System.out.println("  -------------------- Gates Driven (" + gatesDrivenPins.size() + ") --------------------");
        Iterator it2 = gatesDrivenPins.iterator();
        while (it2.hasNext()) {
            pin = (Pin)it2.next();
            totalLoad += pin.getInstance().printLoadInfo(pin, this.alpha);
        }
        System.out.println("  -------------------- Loads Driven (" + loadsDrivenPins.size() + ") --------------------");
        it2 = loadsDrivenPins.iterator();
        while (it2.hasNext()) {
            pin = (Pin)it2.next();
            totalLoad += pin.getInstance().printLoadInfo(pin, this.alpha);
        }
        System.out.println("  -------------------- Wires Driven (" + wiresDrivenPins.size() + ") --------------------");
        it2 = wiresDrivenPins.iterator();
        while (it2.hasNext()) {
            pin = (Pin)it2.next();
            totalLoad += pin.getInstance().printLoadInfo(pin, this.alpha);
        }
        System.out.println("  -------------------- Gates Fighting (" + gatesFightingPins.size() + ") --------------------");
        it2 = gatesFightingPins.iterator();
        while (it2.hasNext()) {
            pin = (Pin)it2.next();
            totalLoad += pin.getInstance().printLoadInfo(pin, this.alpha);
        }
        System.out.println("*** Total Load: " + TextUtils.formatDouble(totalLoad, 2));
        return true;
    }

    public static void test1() {
        LESizer.test1();
    }

    public class LECellInfo
    extends HierarchyEnumerator.CellInfo {
        private float mFactor;
        private float cellsu;

        protected void leInit() {
            float su;
            Variable suvar;
            Object mval;
            HierarchyEnumerator.CellInfo parent = this.getParentInfo();
            this.mFactor = parent == null ? 1.0f : ((LECellInfo)parent).getMFactor();
            this.cellsu = parent == null ? -1.0f : ((LECellInfo)parent).getSU();
            Nodable ni = this.getContext().getNodable();
            if (ni == null) {
                return;
            }
            Variable mvar = ni.getVar("ATTR_M");
            if (mvar != null && (mval = this.getContext().evalVar(mvar, null)) != null) {
                this.mFactor *= VarContext.objectToFloat(mval, 1.0f);
            }
            if ((suvar = ni.getVar("ATTR_su")) != null && (su = VarContext.objectToFloat(this.getContext().evalVar(suvar, null), -1.0f)) != -1.0f) {
                this.cellsu = su;
            }
        }

        protected float getMFactor() {
            return this.mFactor;
        }

        protected float getSU() {
            return this.cellsu;
        }
    }
}

