/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyQTree;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.NodeUsage;
import com.sun.electric.database.network.JNetwork;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.erc.ERCAntenna;
import com.sun.electric.tool.erc.ERCWellCheck;
import com.sun.electric.tool.generator.PadGenerator;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.ncc.ListNccAnnotations;
import com.sun.electric.tool.ncc.NccJob;
import com.sun.electric.tool.routing.AutoStitch;
import com.sun.electric.tool.routing.MimicStitch;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;

public class ToolMenu {
    protected static void addToolMenu(MenuBar menuBar) {
        int buckyBit = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        MenuBar.Menu toolMenu = new MenuBar.Menu("Tool", 'T');
        menuBar.add(toolMenu);
        MenuBar.Menu drcSubMenu = new MenuBar.Menu("DRC", 'D');
        toolMenu.add(drcSubMenu);
        drcSubMenu.addMenuItem("Check Hierarchically", KeyStroke.getKeyStroke(116, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DRC.checkHierarchically();
            }
        });
        drcSubMenu.addMenuItem("Check Selection Area Hierarchically", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DRC.checkAreaHierarchically();
            }
        });
        MenuBar.Menu spiceSimulationSubMenu = new MenuBar.Menu("Simulation (Spice)", 'S');
        toolMenu.add(spiceSimulationSubMenu);
        spiceSimulationSubMenu.addMenuItem("Write Spice Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCellCommand(OpenFile.Type.SPICE, true);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Write CDL Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCellCommand(OpenFile.Type.CDL, true);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Plot Spice Listing...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulate.plotSpiceResults();
            }
        });
        spiceSimulationSubMenu.addMenuItem("Plot Spice for This Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulate.plotSpiceResultsThisCell();
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set Spice Model...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setSpiceModel();
            }
        });
        spiceSimulationSubMenu.addMenuItem("Add Multiplier", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.addMultiplierCommand();
            }
        });
        spiceSimulationSubMenu.addSeparator();
        spiceSimulationSubMenu.addMenuItem("Set Generic Spice Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set Spice 2 Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_2_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set Spice 3 Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_3_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set HSpice Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_H_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set PSpice Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_P_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set GnuCap Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_GC_TEMPLATE_KEY);
            }
        });
        spiceSimulationSubMenu.addMenuItem("Set SmartSpice Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Spice.SPICE_SM_TEMPLATE_KEY);
            }
        });
        MenuBar.Menu verilogSimulationSubMenu = new MenuBar.Menu("Simulation (Verilog)", 'V');
        toolMenu.add(verilogSimulationSubMenu);
        verilogSimulationSubMenu.addMenuItem("Write Verilog Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCellCommand(OpenFile.Type.VERILOG, true);
            }
        });
        verilogSimulationSubMenu.addMenuItem("Plot Verilog VCD Dump...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulate.plotVerilogResults();
            }
        });
        verilogSimulationSubMenu.addMenuItem("Plot Verilog for This Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulate.plotVerilogResultsThisCell();
            }
        });
        verilogSimulationSubMenu.addSeparator();
        verilogSimulationSubMenu.addMenuItem("Set Verilog Template", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.makeTemplate(Verilog.VERILOG_TEMPLATE_KEY);
            }
        });
        verilogSimulationSubMenu.addSeparator();
        MenuBar.Menu verilogWireTypeSubMenu = new MenuBar.Menu("Set Verilog Wire", 'W');
        verilogWireTypeSubMenu.addMenuItem("Wire", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setVerilogWireCommand(0);
            }
        });
        verilogWireTypeSubMenu.addMenuItem("Trireg", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setVerilogWireCommand(1);
            }
        });
        verilogWireTypeSubMenu.addMenuItem("Default", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setVerilogWireCommand(2);
            }
        });
        verilogSimulationSubMenu.add(verilogWireTypeSubMenu);
        MenuBar.Menu transistorStrengthSubMenu = new MenuBar.Menu("Transistor Strength", 'T');
        transistorStrengthSubMenu.addMenuItem("Weak", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setTransistorStrengthCommand(true);
            }
        });
        transistorStrengthSubMenu.addMenuItem("Normal", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Simulation.setTransistorStrengthCommand(false);
            }
        });
        verilogSimulationSubMenu.add(transistorStrengthSubMenu);
        MenuBar.Menu netlisters = new MenuBar.Menu("Simulation (Others)");
        toolMenu.add(netlisters);
        netlisters.addMenuItem("Write IRSIM Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCellCommand(OpenFile.Type.IRSIM, true);
            }
        });
        netlisters.addMenuItem("Write Maxwell Deck...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCellCommand(OpenFile.Type.MAXWELL, true);
            }
        });
        MenuBar.Menu ercSubMenu = new MenuBar.Menu("ERC", 'E');
        toolMenu.add(ercSubMenu);
        ercSubMenu.addMenuItem("Check Wells", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ERCWellCheck.analyzeCurCell(true);
            }
        });
        ercSubMenu.addMenuItem("Antenna Check", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new ERCAntenna();
            }
        });
        MenuBar.Menu nccSubMenu = new MenuBar.Menu("NCC", 'N');
        toolMenu.add(nccSubMenu);
        nccSubMenu.addMenuItem("Flat NCC schematic and layout of current cell", null, 33, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new NccJob(1, false, false);
            }
        });
        nccSubMenu.addMenuItem("Flat NCC two cells from open windows", null, 9, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new NccJob(2, false, false);
            }
        });
        nccSubMenu.addMenuItem("Flat NCC each cell in the design, current cell is root", null, 9, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new NccJob(1, true, false);
            }
        });
        nccSubMenu.addMenuItem("List annotations of each cell in the design, current cell is root", null, 0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new ListNccAnnotations();
            }
        });
        MenuBar.Menu networkSubMenu = new MenuBar.Menu("Network", 'e');
        toolMenu.add(networkSubMenu);
        networkSubMenu.addMenuItem("Show Network", KeyStroke.getKeyStroke(75, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.showNetworkCommand();
            }
        });
        networkSubMenu.addMenuItem("List Networks", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listNetworksCommand();
            }
        });
        networkSubMenu.addMenuItem("List Connections on Network", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listConnectionsOnNetworkCommand();
            }
        });
        networkSubMenu.addMenuItem("List Exports on Network", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listExportsOnNetworkCommand();
            }
        });
        networkSubMenu.addMenuItem("List Exports below Network", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listExportsBelowNetworkCommand();
            }
        });
        networkSubMenu.addMenuItem("List Geometry on Network", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listGeometryOnNetworkCommand();
            }
        });
        networkSubMenu.addSeparator();
        networkSubMenu.addMenuItem("Show Power and Ground", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.showPowerAndGround();
            }
        });
        networkSubMenu.addMenuItem("Validate Power and Ground", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.validatePowerAndGround();
            }
        });
        networkSubMenu.addMenuItem("Redo Network Numbering", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.redoNetworkNumberingCommand();
            }
        });
        MenuBar.Menu logEffortSubMenu = new MenuBar.Menu("Logical Effort", 'L');
        logEffortSubMenu.addMenuItem("Optimize for Equal Gate Delays", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.optimizeEqualGateDelaysCommand();
            }
        });
        logEffortSubMenu.addMenuItem("Print Info for Selected Node", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.printLEInfoCommand();
            }
        });
        toolMenu.add(logEffortSubMenu);
        MenuBar.Menu routingSubMenu = new MenuBar.Menu("Routing", 'R');
        toolMenu.add(routingSubMenu);
        routingSubMenu.addCheckBox("Enable Auto-Stitching", Routing.isAutoStitchOn(), null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Routing.toggleEnableAutoStitching(e);
            }
        });
        routingSubMenu.addMenuItem("Auto-Stitch Now", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AutoStitch.autoStitch(false, true);
            }
        });
        routingSubMenu.addMenuItem("Auto-Stitch Highlighted Now", KeyStroke.getKeyStroke(113, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AutoStitch.autoStitch(true, true);
            }
        });
        routingSubMenu.addSeparator();
        routingSubMenu.addCheckBox("Enable Mimic-Stitching", Routing.isMimicStitchOn(), null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Routing.toggleEnableMimicStitching(e);
            }
        });
        routingSubMenu.addMenuItem("Mimic-Stitch Now", KeyStroke.getKeyStroke(112, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MimicStitch.mimicStitch(true);
            }
        });
        routingSubMenu.addMenuItem("Mimic Selected", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Routing.tool.mimicSelected();
            }
        });
        routingSubMenu.addSeparator();
        routingSubMenu.addMenuItem("Get Unrouted Wire", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.getUnroutedArcCommand();
            }
        });
        MenuBar.Menu generationSubMenu = new MenuBar.Menu("Generation", 'G');
        toolMenu.add(generationSubMenu);
        generationSubMenu.addMenuItem("Coverage Implants Generator", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.layerCoverageCommand(Job.Type.CHANGE, 2, false);
            }
        });
        generationSubMenu.addMenuItem("Pad Frame Generator", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.padFrameGeneratorCommand();
            }
        });
        toolMenu.addSeparator();
        toolMenu.addMenuItem("List Tools", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listToolsCommand();
            }
        });
        MenuBar.Menu languagesSubMenu = new MenuBar.Menu("Languages");
        languagesSubMenu.addMenuItem("Run Java Bean Shell Script", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.javaBshScriptCommand();
            }
        });
        toolMenu.add(languagesSubMenu);
    }

    public static void optimizeEqualGateDelaysCommand() {
        EditWindow curEdit = EditWindow.needCurrent();
        if (curEdit == null) {
            return;
        }
        LETool letool = LETool.getLETool();
        if (letool == null) {
            System.out.println("Logical Effort tool not found");
            return;
        }
        curEdit.setCell(curEdit.getCell(), VarContext.globalContext);
        letool.optimizeEqualGateDelays(curEdit.getCell(), curEdit.getVarContext(), curEdit);
    }

    public static void printLEInfoCommand() {
        if (Highlight.getNumHighlights() == 0) {
            System.out.println("Nothing highlighted");
            return;
        }
        Iterator it = Highlight.getHighlights();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.EOBJ) continue;
            ElectricObject eobj = h.getElectricObject();
            if (eobj instanceof PortInst) {
                PortInst pi = (PortInst)eobj;
                pi.getInfo();
                eobj = pi.getNodeInst();
            }
            if (!(eobj instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)eobj;
            LETool.printResults(ni);
        }
    }

    public static void showNetworkCommand() {
        Set nets = Highlight.getHighlightedNetworks();
        Highlight.clear();
        Iterator it = nets.iterator();
        while (it.hasNext()) {
            JNetwork net = (JNetwork)it.next();
            Cell cell = net.getParent();
            Highlight.addNetwork(net, cell);
        }
        Highlight.finished();
    }

    public static void listNetworksCommand() {
        Cell cell = WindowFrame.getCurrentCell();
        if (cell == null) {
            return;
        }
        Netlist netlist = cell.getUserNetlist();
        int total = 0;
        Iterator it = netlist.getNetworks();
        while (it.hasNext()) {
            JNetwork net = (JNetwork)it.next();
            String netName = net.describe();
            if (netName.length() == 0) continue;
            StringBuffer infstr = new StringBuffer();
            infstr.append("'" + netName + "'");
            boolean connected = false;
            Iterator aIt = net.getArcs();
            while (aIt.hasNext()) {
                ArcInst ai = (ArcInst)aIt.next();
                if (!connected) {
                    connected = true;
                    infstr.append(", on arcs:");
                }
                infstr.append(" " + ai.describe());
            }
            boolean exported = false;
            Iterator eIt = net.getExports();
            while (eIt.hasNext()) {
                Export pp = (Export)eIt.next();
                if (!exported) {
                    exported = true;
                    infstr.append(", with exports:");
                }
                infstr.append(" " + pp.getName());
            }
            System.out.println(infstr.toString());
            ++total;
        }
        if (total == 0) {
            System.out.println("There are no networks in this cell");
        }
    }

    public static void listConnectionsOnNetworkCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        Set nets = Highlight.getHighlightedNetworks();
        Netlist netlist = cell.getUserNetlist();
        Iterator it = nets.iterator();
        while (it.hasNext()) {
            JNetwork net = (JNetwork)it.next();
            System.out.println("Network '" + net.describe() + "':");
            int total = 0;
            Iterator nIt = netlist.getNodables();
            while (nIt.hasNext()) {
                PortProto pp;
                Nodable no = (Nodable)nIt.next();
                NodeProto np = no.getProto();
                HashMap<JNetwork, PortProto> portNets = new HashMap<JNetwork, PortProto>();
                Iterator pIt = np.getPorts();
                while (pIt.hasNext()) {
                    PortProto pp2 = (PortProto)pIt.next();
                    if (pp2.isIsolated()) {
                        NodeInst ni = (NodeInst)no;
                        Iterator cIt = ni.getConnections();
                        while (cIt.hasNext()) {
                            Connection con = (Connection)cIt.next();
                            ArcInst ai = con.getArc();
                            JNetwork oNet = netlist.getNetwork(ai, 0);
                            portNets.put(oNet, pp2);
                        }
                        continue;
                    }
                    int width = 1;
                    if (pp2 instanceof Export) {
                        Export e = (Export)pp2;
                        width = netlist.getBusWidth(e);
                    }
                    for (int i = 0; i < width; ++i) {
                        JNetwork oNet = netlist.getNetwork(no, pp2, i);
                        portNets.put(oNet, pp2);
                    }
                }
                if (portNets.size() <= 1 || (pp = (PortProto)portNets.get(net)) == null) continue;
                if (total == 0) {
                    System.out.println("  Connects to:");
                }
                String name = null;
                name = no instanceof NodeInst ? ((NodeInst)no).describe() : no.getName();
                System.out.println("    Node " + name + ", port " + pp.getName());
                ++total;
            }
            if (total != 0) continue;
            System.out.println("  Not connected");
        }
    }

    public static void listExportsOnNetworkCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        Set nets = Highlight.getHighlightedNetworks();
        Netlist netlist = cell.getUserNetlist();
        Iterator it = nets.iterator();
        while (it.hasNext()) {
            JNetwork net = (JNetwork)it.next();
            System.out.println("Network '" + net.describe() + "':");
            FlagSet fs = Geometric.getFlagSet(1);
            Iterator lIt = Library.getLibraries();
            while (lIt.hasNext()) {
                Library lib = (Library)lIt.next();
                Iterator cIt = lib.getCells();
                while (cIt.hasNext()) {
                    Cell oCell = (Cell)cIt.next();
                    Iterator pIt = oCell.getPorts();
                    while (pIt.hasNext()) {
                        Export pp = (Export)pIt.next();
                        pp.clearBit(fs);
                    }
                }
            }
            System.out.println("  Going up the hierarchy from cell " + cell.describe() + ":");
            ToolMenu.findPortsUp(netlist, net, cell, fs);
            System.out.println("  Going down the hierarchy from cell " + cell.describe() + ":");
            ToolMenu.findPortsDown(netlist, net, cell, fs);
            fs.freeFlagSet();
        }
    }

    public static void listExportsBelowNetworkCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        Set nets = Highlight.getHighlightedNetworks();
        Netlist netlist = cell.getUserNetlist();
        Iterator it = nets.iterator();
        while (it.hasNext()) {
            JNetwork net = (JNetwork)it.next();
            System.out.println("Network '" + net.describe() + "':");
            FlagSet fs = Geometric.getFlagSet(1);
            Iterator lIt = Library.getLibraries();
            while (lIt.hasNext()) {
                Library lib = (Library)lIt.next();
                Iterator cIt = lib.getCells();
                while (cIt.hasNext()) {
                    Cell oCell = (Cell)cIt.next();
                    Iterator pIt = oCell.getPorts();
                    while (pIt.hasNext()) {
                        Export pp = (Export)pIt.next();
                        pp.clearBit(fs);
                    }
                }
            }
            ToolMenu.findPortsDown(netlist, net, cell, fs);
            fs.freeFlagSet();
        }
    }

    private static void findPortsUp(Netlist netlist, JNetwork net, Cell cell, FlagSet fs) {
        Iterator it = cell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            int width = netlist.getBusWidth(pp);
            for (int i = 0; i < width; ++i) {
                JNetwork ppNet = netlist.getNetwork(pp, i);
                if (ppNet != net || pp.isBit(fs)) continue;
                pp.setBit(fs);
                System.out.println("    Export " + pp.getName() + " in cell " + cell.describe());
                Cell instanceCell = cell.iconView();
                if (instanceCell == null) {
                    instanceCell = cell;
                }
                Iterator uIt = instanceCell.getUsagesOf();
                while (uIt.hasNext()) {
                    NodeUsage nu = (NodeUsage)uIt.next();
                    Cell superCell = nu.getParent();
                    Netlist superNetlist = superCell.getUserNetlist();
                    Iterator nIt = superNetlist.getNodables();
                    while (nIt.hasNext()) {
                        Nodable no = (Nodable)nIt.next();
                        if (no.getProto() != cell) continue;
                        JNetwork superNet = superNetlist.getNetwork(no, pp, i);
                        ToolMenu.findPortsUp(superNetlist, superNet, superCell, fs);
                    }
                }
            }
        }
    }

    private static void findPortsDown(Netlist netlist, JNetwork net, Cell cell, FlagSet fs) {
        Iterator it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable no = (Nodable)it.next();
            NodeProto subnp = no.getProto();
            if (!(subnp instanceof Cell)) continue;
            Cell subCell = (Cell)subnp;
            Iterator pIt = subCell.getPorts();
            while (pIt.hasNext()) {
                Export pp = (Export)pIt.next();
                int width = netlist.getBusWidth(pp);
                for (int i = 0; i < width; ++i) {
                    JNetwork oNet = netlist.getNetwork(no, pp, i);
                    if (oNet != net || pp.isBit(fs)) continue;
                    pp.setBit(fs);
                    System.out.println("    Export " + pp.getName() + " in cell " + subCell.describe());
                    Netlist subNetlist = subCell.getUserNetlist();
                    JNetwork subNet = subNetlist.getNetwork(pp, i);
                    ToolMenu.findPortsDown(subNetlist, subNet, subCell, fs);
                }
            }
        }
    }

    public static void listGeometryOnNetworkCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        Set nets = Highlight.getHighlightedNetworks();
        Netlist netlist = cell.getUserNetlist();
        if (nets.isEmpty()) {
            System.out.println("No network in cell '" + cell.describe() + "' selected");
            return;
        }
        Iterator it = nets.iterator();
        while (it.hasNext()) {
            JNetwork net = (JNetwork)it.next();
            System.out.println("For network '" + net.describe() + "' in cell '" + cell.describe() + "':");
        }
        PolyQTree tree = new PolyQTree(cell.getBounds());
        LayerCoverageJob.LayerVisitor visitor = new LayerCoverageJob.LayerVisitor(true, tree, null, 3);
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, netlist, visitor);
        double totalWire = 0.0;
        double lambda = 1.0;
        Iterator it2 = tree.getKeyIterator();
        while (it2.hasNext()) {
            Layer layer = (Layer)it2.next();
            Set set = tree.getObjects(layer, false);
            double layerArea = 0.0;
            double perimeter = 0.0;
            Iterator i = set.iterator();
            while (i.hasNext()) {
                PolyQTree.PolyNode area = (PolyQTree.PolyNode)i.next();
                layerArea += area.getArea();
                perimeter += area.getPerimeter();
            }
            layerArea /= lambda;
            perimeter /= 2.0;
            Layer.Function func = layer.getFunction();
            if (func.isPoly() && !func.isGatePoly() || func.isMetal()) {
                totalWire += perimeter;
            }
            System.out.println("Layer " + layer.getName() + ":\t area " + TextUtils.formatDouble(layerArea) + "\t half-perimeter " + TextUtils.formatDouble(perimeter) + "\t ratio " + TextUtils.formatDouble(layerArea / perimeter));
        }
        if (totalWire > 0.0) {
            System.out.println("Total wire length = " + TextUtils.formatDouble(totalWire / lambda));
        }
    }

    public static void showPowerAndGround() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        Netlist netlist = cell.getUserNetlist();
        HashSet<JNetwork> pAndG = new HashSet<JNetwork>();
        Iterator it = cell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            if (!pp.isPower() && !pp.isGround()) continue;
            int width = netlist.getBusWidth(pp);
            for (int i = 0; i < width; ++i) {
                JNetwork net = netlist.getNetwork(pp, i);
                pAndG.add(net);
            }
        }
        it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            NodeProto.Function fun = ni.getFunction();
            if (fun != NodeProto.Function.CONPOWER && fun != NodeProto.Function.CONGROUND) continue;
            Iterator cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con = (Connection)cIt.next();
                ArcInst ai = con.getArc();
                int width = netlist.getBusWidth(ai);
                for (int i = 0; i < width; ++i) {
                    JNetwork net = netlist.getNetwork(ai, i);
                    pAndG.add(net);
                }
            }
        }
        Highlight.clear();
        it = pAndG.iterator();
        while (it.hasNext()) {
            JNetwork net = (JNetwork)it.next();
            Highlight.addNetwork(net, cell);
        }
        Highlight.finished();
        if (pAndG.size() == 0) {
            System.out.println("This cell has no Power or Ground networks");
        }
    }

    public static void validatePowerAndGround() {
        System.out.println("Validating power and ground networks");
        int total = 0;
        Iterator lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = (Library)lIt.next();
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                Iterator pIt = cell.getPorts();
                while (pIt.hasNext()) {
                    Export pp = (Export)pIt.next();
                    if (pp.isNamedGround() && pp.getCharacteristic() != PortProto.Characteristic.GND) {
                        System.out.println("Cell " + cell.describe() + ", export " + pp.getName() + ": does not have 'GROUND' characteristic");
                        ++total;
                    }
                    if (!pp.isNamedPower() || pp.getCharacteristic() == PortProto.Characteristic.PWR) continue;
                    System.out.println("Cell " + cell.describe() + ", export " + pp.getName() + ": does not have 'POWER' characteristic");
                    ++total;
                }
            }
        }
        if (total == 0) {
            System.out.println("No problems found");
        } else {
            System.out.println("Found " + total + " export problems");
        }
    }

    public static void redoNetworkNumberingCommand() {
        long startTime = System.currentTimeMillis();
        int ncell = 0;
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            Iterator cit = lib.getCells();
            while (cit.hasNext()) {
                Cell cell = (Cell)cit.next();
                ++ncell;
                cell.getNetlist(false);
            }
        }
        long endTime = System.currentTimeMillis();
        float finalTime = (float)(endTime - startTime) / 1000.0f;
        System.out.println("**** Renumber networks of " + ncell + " cells took " + finalTime + " seconds");
    }

    public static void addMultiplierCommand() {
        NodeInst ni = (NodeInst)Highlight.getOneElectricObject(NodeInst.class);
        if (ni == null) {
            return;
        }
        AddMultiplier job = new AddMultiplier(ni);
    }

    public static void makeTemplate(Variable.Key templateKey) {
        MakeTemplate job = new MakeTemplate(templateKey);
    }

    public static void getUnroutedArcCommand() {
        User.tool.setCurrentArcProto(Generic.tech.unrouted_arc);
    }

    public static void padFrameGeneratorCommand() {
        String fileName = OpenFile.chooseInputFile(OpenFile.Type.PADARR, null);
        if (fileName != null) {
            PadGenerator.generate(fileName);
        }
    }

    public static void layerCoverageCommand(Job.Type jobType, int func, boolean test) {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        LayerCoverageJob job = new LayerCoverageJob(jobType, curCell, func, test);
    }

    public static void listToolsCommand() {
        System.out.println("Tools in Electric:");
        Iterator it = Tool.getTools();
        while (it.hasNext()) {
            Tool tool = (Tool)it.next();
            StringBuffer infstr = new StringBuffer();
            if (tool.isOn()) {
                infstr.append("On");
            } else {
                infstr.append("Off");
            }
            if (tool.isBackground()) {
                infstr.append(", Background");
            }
            if (tool.isFixErrors()) {
                infstr.append(", Correcting");
            }
            if (tool.isIncremental()) {
                infstr.append(", Incremental");
            }
            if (tool.isAnalysis()) {
                infstr.append(", Analysis");
            }
            if (tool.isSynthesis()) {
                infstr.append(", Synthesis");
            }
            System.out.println(tool.getName() + ": " + infstr.toString());
        }
    }

    public static void javaBshScriptCommand() {
        String fileName = OpenFile.chooseInputFile(OpenFile.Type.JAVA, null);
        if (fileName != null) {
            EvalJavaBsh.runScript(fileName);
        }
    }

    protected static class LayerCoverageJob
    extends Job {
        private Cell curCell;
        private boolean testCase;
        private PolyQTree tree;
        public static final int AREA = 0;
        public static final int MERGE = 1;
        public static final int IMPLANT = 2;
        public static final int NETWORK = 3;
        private final int function;
        private List deleteList;

        protected LayerCoverageJob(Job.Type jobType, Cell cell, int func, boolean test) {
            super("Layer Coverage", User.tool, jobType, null, null, Job.Priority.USER);
            this.curCell = cell;
            this.testCase = test;
            this.tree = new PolyQTree(this.curCell.getBounds());
            this.function = func;
            this.deleteList = new ArrayList();
            this.setReportExecutionFlag(true);
            this.startJob();
        }

        public boolean doIt() {
            LayerVisitor visitor = new LayerVisitor(this.testCase, this.tree, this.deleteList, this.function);
            HierarchyEnumerator.enumerateCell(this.curCell, VarContext.globalContext, null, visitor);
            switch (this.function) {
                case 0: {
                    double lambdaSqr = 1.0;
                    Rectangle2D bbox = this.curCell.getBounds();
                    double totalArea = bbox.getHeight() * bbox.getWidth() / lambdaSqr;
                    Iterator it = this.tree.getKeyIterator();
                    while (it.hasNext()) {
                        Layer layer = (Layer)it.next();
                        Set set = this.tree.getObjects(layer, false);
                        double layerArea = 0.0;
                        Iterator i = set.iterator();
                        while (i.hasNext()) {
                            PolyQTree.PolyNode area = (PolyQTree.PolyNode)i.next();
                            layerArea += area.getArea();
                        }
                        System.out.println("Layer " + layer.getName() + " covers " + TextUtils.formatDouble(layerArea) + " square lambda (" + TextUtils.formatDouble(layerArea / totalArea * 100.0, 0) + "%)");
                    }
                    System.out.println("Cell is " + TextUtils.formatDouble(totalArea) + " square lambda");
                    break;
                }
                case 1: 
                case 2: {
                    Highlight.clear();
                    boolean noNewNodes = true;
                    boolean isMerge = this.function == 1;
                    Iterator it = this.tree.getKeyIterator();
                    while (it.hasNext()) {
                        Layer layer = (Layer)it.next();
                        Set set = this.tree.getObjects(layer, !isMerge);
                        Iterator i = set.iterator();
                        while (i.hasNext()) {
                            PolyQTree.PolyNode qNode = (PolyQTree.PolyNode)i.next();
                            Rectangle2D rect = qNode.getBounds2D();
                            Point2D.Double center = new Point2D.Double(rect.getCenterX(), rect.getCenterY());
                            PrimitiveNode priNode = layer.getPureLayerNode();
                            NodeInst node = NodeInst.makeInstance(priNode, center, rect.getWidth(), rect.getHeight(), 0, this.curCell, null);
                            Highlight.addElectricObject(node, this.curCell);
                            if (isMerge) {
                                Point2D[] points = qNode.getPoints();
                                node.newVar(NodeInst.TRACE, (Object)points);
                            } else {
                                node.setHardSelect();
                            }
                            noNewNodes = false;
                        }
                    }
                    Highlight.finished();
                    it = this.deleteList.iterator();
                    while (it.hasNext()) {
                        NodeInst node = (NodeInst)it.next();
                        node.kill();
                    }
                    if (!noNewNodes) break;
                    System.out.println("No implant areas added");
                    break;
                }
                default: {
                    System.out.println("Error in LayerCoverageJob: function not implemented");
                }
            }
            return true;
        }

        public static class LayerVisitor
        extends HierarchyEnumerator.Visitor {
            private boolean testCase;
            private PolyQTree tree;
            private List deleteList;
            private final int function;

            private static boolean IsValidFunction(Layer.Function func, int function, boolean testCase) {
                if (testCase) {
                    return true;
                }
                switch (function) {
                    case 2: {
                        return func.isSubstrate();
                    }
                    case 0: {
                        return func.isPoly() || func.isMetal();
                    }
                }
                return false;
            }

            public LayerVisitor(boolean test, PolyQTree t, List delList, int func) {
                this.testCase = test;
                this.tree = t;
                this.deleteList = delList;
                this.function = func;
            }

            public void exitCell(HierarchyEnumerator.CellInfo info) {
            }

            public boolean enterCell(HierarchyEnumerator.CellInfo info) {
                Poly[] polyList;
                Technology tech;
                Cell curCell = info.getCell();
                Iterator it = curCell.getArcs();
                while (it.hasNext()) {
                    ArcInst arc = (ArcInst)it.next();
                    ArcProto arcType = arc.getProto();
                    tech = arcType.getTechnology();
                    polyList = tech.getShapeOfArc(arc);
                    for (int i = 0; i < polyList.length; ++i) {
                        Poly poly = polyList[i];
                        Layer layer = poly.getLayer();
                        Layer.Function func = layer.getFunction();
                        boolean value = LayerVisitor.IsValidFunction(func, this.function, this.testCase);
                        if (!value) continue;
                        this.tree.insert(layer, new PolyQTree.PolyNode(poly));
                    }
                }
                it = curCell.getNodes();
                while (it.hasNext()) {
                    NodeInst node = (NodeInst)it.next();
                    if (!this.testCase && node.getFunction() == NodeProto.Function.NODE) {
                        this.deleteList.add(node);
                        continue;
                    }
                    NodeProto protoType = node.getProto();
                    if (protoType == Tech.facetCenter || protoType instanceof Cell) continue;
                    tech = protoType.getTechnology();
                    polyList = tech.getShapeOfNode(node);
                    AffineTransform transform = node.rotateOut();
                    for (int i = 0; i < polyList.length; ++i) {
                        Poly poly = polyList[i];
                        Layer layer = poly.getLayer();
                        Layer.Function func = layer.getFunction();
                        boolean value = LayerVisitor.IsValidFunction(func, this.function, this.testCase);
                        if (!value) continue;
                        poly.transform(transform);
                        poly.transform(info.getTransformToRoot());
                        this.tree.insert(layer, new PolyQTree.PolyNode(poly));
                    }
                }
                return true;
            }

            public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
                return true;
            }
        }
    }

    private static class MakeTemplate
    extends Job {
        private Variable.Key templateKey;

        protected MakeTemplate(Variable.Key templateKey) {
            super("Make template", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.templateKey = templateKey;
            this.startJob();
        }

        public boolean doIt() {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return false;
            }
            Variable templateVar = cell.getVar(this.templateKey);
            if (templateVar != null) {
                System.out.println("This cell already has a template");
                return false;
            }
            templateVar = cell.newVar(this.templateKey, (Object)"*Undefined");
            if (templateVar != null) {
                templateVar.setDisplay(true);
                TextDescriptor td = templateVar.getTextDescriptor();
                td.setInterior(true);
                td.setDispPart(TextDescriptor.DispPos.NAMEVALUE);
            }
            return true;
        }
    }

    private static class AddMultiplier
    extends Job {
        private NodeInst ni;

        protected AddMultiplier(NodeInst ni) {
            super("Add Spice Multiplier", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.startJob();
        }

        public boolean doIt() {
            Variable var = this.ni.newVar("ATTR_M", (Object)new Double(1.0));
            if (var != null) {
                var.setDisplay(true);
                TextDescriptor td = var.getTextDescriptor();
                td.setOff(-1.5, -1.0);
                td.setDispPart(TextDescriptor.DispPos.NAMEVALUE);
            }
            return true;
        }
    }
}

