/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.Technology;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

public class TextUtils {
    private static NumberFormat numberFormatPostFix = null;
    private static NumberFormat numberFormatSpecific = null;
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd, yyyy HH:mm:ss");
    public static final Comparator STRING_NUMBER_ORDER = new StringsWithNumbers();

    public static boolean isDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    public static boolean isLetterOrDigit(char ch) {
        return TextUtils.isDigit(ch) || Character.isLetter(ch);
    }

    public static boolean startsWithIgnoreCase(String main, String with) {
        int mainLen = main.length();
        int withLen = with.length();
        if (withLen > mainLen) {
            return false;
        }
        for (int i = 0; i < withLen; ++i) {
            char withChr;
            char mainChr = Character.toLowerCase(main.charAt(i));
            if (mainChr == (withChr = Character.toLowerCase(with.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public static double atof(String text) {
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            return TextUtils.atof(text, null);
        }
    }

    public static double atof(String text, Double defaultVal) {
        text = text.replaceAll(",", "");
        double v = 0.0;
        try {
            Number n = TextUtils.parsePostFixNumber(text);
            v = n.doubleValue();
        }
        catch (NumberFormatException ex) {
            int start;
            for (start = 0; start < text.length() && text.charAt(start) == ' '; ++start) {
            }
            int end = start;
            if (end < text.length() && (text.charAt(end) == '-' || text.charAt(end) == '+')) {
                ++end;
            }
            while (end < text.length() && TextUtils.isDigit(text.charAt(end))) {
                ++end;
            }
            if (end < text.length() && text.charAt(end) == '.') {
                ++end;
                while (end < text.length() && TextUtils.isDigit(text.charAt(end))) {
                    ++end;
                }
            }
            if (end < text.length() && (text.charAt(end) == 'e' || text.charAt(end) == 'E')) {
                if (++end < text.length() && (text.charAt(end) == '-' || text.charAt(end) == '+')) {
                    ++end;
                }
                while (end < text.length() && TextUtils.isDigit(text.charAt(end))) {
                    ++end;
                }
            }
            if (end <= start) {
                if (defaultVal != null) {
                    return defaultVal;
                }
                return 0.0;
            }
            try {
                v = Double.parseDouble(text.substring(start, end - start));
            }
            catch (NumberFormatException e) {
                v = 0.0;
            }
        }
        return v;
    }

    public static int atoi(String s) {
        return TextUtils.atoi(s, 0, 0);
    }

    public static int atoi(String s, int pos) {
        return TextUtils.atoi(s, pos, 0);
    }

    public static int atoi(String s, int pos, int base) {
        char cat;
        int digit;
        int num = 0;
        int sign = 1;
        int len = s.length();
        if (pos < len && s.charAt(pos) == '-') {
            ++pos;
            sign = -1;
        }
        if (base == 0) {
            base = 10;
            if (pos < len && s.charAt(pos) == '0') {
                base = 8;
                if (++pos < len && (s.charAt(pos) == 'x' || s.charAt(pos) == 'X')) {
                    ++pos;
                    base = 16;
                } else if (pos < len && (s.charAt(pos) == 'b' || s.charAt(pos) == 'B')) {
                    ++pos;
                    base = 2;
                }
            }
        }
        while (pos < len && (digit = Character.digit(cat = s.charAt(pos), base)) >= 0) {
            num = num * base + digit;
            ++pos;
        }
        return num * sign;
    }

    public static String formatDoublePostFix(double v) {
        int unitScaleIndex;
        if (numberFormatPostFix == null) {
            numberFormatPostFix = NumberFormat.getInstance(Locale.US);
            try {
                DecimalFormat d = (DecimalFormat)numberFormatPostFix;
                d.setDecimalSeparatorAlwaysShown(false);
                d.setGroupingSize(300);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        numberFormatPostFix.setMaximumFractionDigits(3);
        if (v != 0.0) {
            for (unitScaleIndex = 0; Math.abs(v) >= 1000000.0 && unitScaleIndex > -3; --unitScaleIndex) {
                v /= 1000.0;
            }
            while (Math.abs(v) < 0.1 && unitScaleIndex < 5) {
                v *= 1000.0;
                ++unitScaleIndex;
            }
            if (Math.abs(v) < 0.1) {
                int maxDecimals = 3;
                for (double v2 = Math.abs(v); v2 < 0.1; v2 *= 10.0) {
                    ++maxDecimals;
                }
                numberFormatPostFix.setMaximumFractionDigits(maxDecimals);
            }
        }
        UnitScale u = UnitScale.findFromIndex(unitScaleIndex);
        String result = numberFormatPostFix.format(v);
        return result + u.getPostFix();
    }

    public static String formatDouble(double v) {
        return TextUtils.formatDouble(v, 3);
    }

    public static synchronized String formatDouble(double v, int numFractions) {
        if (numberFormatSpecific == null) {
            numberFormatSpecific = NumberFormat.getInstance(Locale.US);
            if (numberFormatSpecific != null) {
                numberFormatSpecific.setGroupingUsed(false);
            }
            try {
                DecimalFormat d = (DecimalFormat)numberFormatPostFix;
                d.setDecimalSeparatorAlwaysShown(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (numFractions == 0) {
            numberFormatSpecific.setMaximumFractionDigits(340);
        } else {
            numberFormatSpecific.setMaximumFractionDigits(numFractions);
        }
        return numberFormatSpecific.format(v);
    }

    public static String formatDate(Date date) {
        return simpleDateFormat.format(date);
    }

    public static String convertToEngineeringNotation(double value) {
        return TextUtils.convertToEngineeringNotation(value, "", 9999);
    }

    public static String convertToEngineeringNotation(double value, String unit) {
        return TextUtils.convertToEngineeringNotation(value, unit, 9999);
    }

    public static String convertToEngineeringNotation(double time, String unit, int precpower) {
        String negative = "";
        if (time < 0.0) {
            negative = "-";
            time = -time;
        }
        if (GenMath.doublesEqual(time, 0.0)) {
            return "0" + unit;
        }
        if (time < 1.0E-15 || time >= 1000.0) {
            return negative + TextUtils.formatDouble(time) + unit;
        }
        double scaled = time * 1.0E17;
        long intTime = Math.round(scaled);
        String secType = null;
        int scalePower = 0;
        if (scaled < 200000.0 && intTime < 100000L) {
            secType = "f" + unit;
            scalePower = -15;
        } else {
            scaled = time * 1.0E14;
            intTime = Math.round(scaled);
            if (scaled < 200000.0 && intTime < 100000L) {
                secType = "p" + unit;
                scalePower = -12;
            } else {
                scaled = time * 1.0E11;
                intTime = Math.round(scaled);
                if (scaled < 200000.0 && intTime < 100000L) {
                    secType = "n" + unit;
                    scalePower = -9;
                } else {
                    scaled = time * 1.0E8;
                    intTime = Math.round(scaled);
                    if (scaled < 200000.0 && intTime < 100000L) {
                        secType = "u" + unit;
                        scalePower = -6;
                    } else {
                        scaled = time * 100000.0;
                        intTime = Math.round(scaled);
                        if (scaled < 200000.0 && intTime < 100000L) {
                            secType = "m" + unit;
                            scalePower = -3;
                        } else {
                            scaled = time * 100.0;
                            intTime = Math.round(scaled);
                            secType = unit;
                            scalePower = 0;
                        }
                    }
                }
            }
        }
        if (precpower >= scalePower) {
            long timeleft = intTime / 100L;
            long timeright = intTime % 100L;
            if (timeright == 0L) {
                return negative + timeleft + secType;
            }
            if (timeright % 10L == 0L) {
                return negative + timeleft + "." + timeright / 10L + secType;
            }
            String tensDigit = "";
            if (timeright < 10L) {
                tensDigit = "0";
            }
            return negative + timeleft + "." + tensDigit + timeright + secType;
        }
        String numPart = TextUtils.formatDouble(scaled /= 100.0, scalePower - precpower);
        while (numPart.endsWith("0")) {
            numPart = numPart.substring(0, numPart.length() - 1);
        }
        if (numPart.endsWith(".")) {
            numPart = numPart.substring(0, numPart.length() - 1);
        }
        return negative + numPart + secType;
    }

    public static String toBlankPaddedString(int value, int width) {
        String msg = Integer.toString(value);
        while (msg.length() < width) {
            msg = " " + msg;
        }
        return msg;
    }

    public static String toBlankPaddedString(double value, int width) {
        String msg = Double.toString(value);
        while (msg.length() < width) {
            msg = " " + msg;
        }
        return msg;
    }

    public static boolean isANumber(String pp) {
        int i = 0;
        int len = pp.length();
        if (i < len && (pp.charAt(i) == '+' || pp.charAt(i) == '-')) {
            ++i;
        }
        boolean xflag = false;
        if (i < len - 1 && pp.charAt(i) == '0' && (pp.charAt(i + 1) == 'x' || pp.charAt(i + 1) == 'X')) {
            i += 2;
            xflag = true;
        }
        boolean founddigits = false;
        if (xflag) {
            while (i < len && (TextUtils.isDigit(pp.charAt(i)) || pp.charAt(i) == 'a' || pp.charAt(i) == 'A' || pp.charAt(i) == 'b' || pp.charAt(i) == 'B' || pp.charAt(i) == 'c' || pp.charAt(i) == 'C' || pp.charAt(i) == 'd' || pp.charAt(i) == 'D' || pp.charAt(i) == 'e' || pp.charAt(i) == 'E' || pp.charAt(i) == 'f' || pp.charAt(i) == 'F')) {
                ++i;
                founddigits = true;
            }
        } else {
            while (i < len && (TextUtils.isDigit(pp.charAt(i)) || pp.charAt(i) == '.')) {
                if (pp.charAt(i) != '.') {
                    founddigits = true;
                }
                ++i;
            }
        }
        if (!founddigits) {
            return false;
        }
        if (i == len) {
            return true;
        }
        if (xflag) {
            return false;
        }
        if (pp.charAt(i) != 'e' && pp.charAt(i) != 'E') {
            return false;
        }
        if (++i == len) {
            return false;
        }
        if (pp.charAt(i) == '+' || pp.charAt(i) == '-') {
            ++i;
        }
        if (i == len) {
            return false;
        }
        while (i < len && TextUtils.isDigit(pp.charAt(i))) {
            ++i;
        }
        return i == len;
    }

    public static String getElapsedTime(long milliseconds) {
        int minutes;
        int hours;
        int days;
        if (milliseconds < 60000L) {
            return (double)milliseconds / 1000.0 + " secs";
        }
        StringBuffer buf = new StringBuffer();
        int seconds = (int)milliseconds / 1000;
        if (seconds < 0) {
            seconds = 0;
        }
        if ((days = seconds / 86400) > 0) {
            buf.append(days + " days, ");
        }
        if ((hours = (seconds -= days * 86400) / 3600) > 0) {
            buf.append(hours + " hrs, ");
        }
        if ((minutes = (seconds -= hours * 3600) / 60) > 0) {
            buf.append(minutes + " mins, ");
        }
        buf.append((seconds -= minutes * 60) + " secs");
        return buf.toString();
    }

    public static int findStringInString(String string, String search, int startingPos, boolean caseSensitive, boolean reverse) {
        if (caseSensitive) {
            int i = 0;
            i = reverse ? string.lastIndexOf(search, startingPos) : string.indexOf(search, startingPos);
            return i;
        }
        if (startingPos > 0) {
            string = string.substring(startingPos);
        }
        String stringLC = string.toLowerCase();
        String searchLC = search.toLowerCase();
        int i = 0;
        i = reverse ? stringLC.lastIndexOf(searchLC) : stringLC.indexOf(searchLC);
        if (i >= 0) {
            i += startingPos;
        }
        return i;
    }

    public static String[] parseLine(String line) {
        StringTokenizer st = new StringTokenizer(line, " \t");
        int total = st.countTokens();
        String[] strings = new String[total];
        for (int i = 0; i < total; ++i) {
            strings[i] = st.nextToken();
        }
        return strings;
    }

    public static double convertDistance(double value, Technology tech, UnitScale unitScale) {
        double scale = tech.getScale();
        double distanceScale = 1.0E-9 / unitScale.getMultiplier().doubleValue() * scale;
        return value * distanceScale;
    }

    public static double convertFromDistance(double value, Technology tech, UnitScale unitScale) {
        double scale = tech.getScale();
        double distanceScale = 1.0E-9 / unitScale.getMultiplier().doubleValue() * scale;
        return value / distanceScale;
    }

    public static String makeUnits(double value, TextDescriptor.Unit units) {
        if (units == TextDescriptor.Unit.NONE) {
            return TextUtils.formatDouble(value);
        }
        return TextUtils.formatDoublePostFix(value);
    }

    public static Number parsePostFixNumber(String s) throws NumberFormatException {
        s = s.replaceAll(",", "");
        Number n = null;
        Number m = null;
        for (int i = 0; i < UnitScale.allUnits.length; ++i) {
            String sSuffix;
            UnitScale u = UnitScale.allUnits[i];
            String postfix = u.getPostFix();
            if (postfix.equals("") || postfix.length() >= s.length() || !(sSuffix = s.substring(s.length() - postfix.length(), s.length())).equalsIgnoreCase(postfix)) continue;
            m = u.getMultiplier();
            String sub = s.substring(0, s.length() - postfix.length());
            try {
                n = TextUtils.parseNumber(sub);
                break;
            }
            catch (NumberFormatException e) {
                m = null;
            }
        }
        if (n == null) {
            n = TextUtils.parseNumber(s);
        }
        if (m != null) {
            if (m instanceof Integer && m.intValue() == 1) {
                return n;
            }
            if (n instanceof Integer && m instanceof Integer) {
                return new Integer(n.intValue() * m.intValue());
            }
            if (n instanceof Long && m instanceof Integer) {
                return new Long(n.longValue() * m.longValue());
            }
            return new Double(n.doubleValue() * m.doubleValue());
        }
        return n;
    }

    private static Number parseNumber(String s) throws NumberFormatException {
        if (s.equals("1")) {
            Integer nn = new Integer(1);
        }
        Number n = null;
        try {
            n = new Integer(s);
        }
        catch (NumberFormatException e) {
            try {
                n = new Double(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n == null) {
            e = new NumberFormatException(s + "cannot be parsed into a Number");
            throw e;
        }
        return n;
    }

    public static void printLongString(String str) {
        String prefix = "";
        while (str.length() > 80) {
            int i;
            for (i = 80; i > 0 && str.charAt(i) != ' ' && str.charAt(i) != ','; --i) {
            }
            if (i <= 0) {
                i = 80;
            }
            if (str.charAt(i) == ',') {
                ++i;
            }
            System.out.println(prefix + str.substring(0, i));
            if (str.charAt(i) == ' ') {
                ++i;
            }
            str = str.substring(i);
            prefix = "   ";
        }
        System.out.println(prefix + str);
    }

    public static int nameSameNumeric(String name1, String name2) {
        int len1 = name1.length();
        int len2 = name2.length();
        int extent = Math.min(len1, len2);
        for (int pos = 0; pos < extent; ++pos) {
            char ch2;
            char ch1 = name1.charAt(pos);
            if (ch1 == (ch2 = name2.charAt(pos))) continue;
            int digit1 = Character.digit(ch1, 10);
            int digit2 = Character.digit(ch2, 10);
            if (digit1 >= 0 || digit2 >= 0) {
                int digit;
                int pos1 = pos + 1;
                int pos2 = pos + 1;
                int n = digit = pos > 0 ? Character.digit(name1.charAt(--pos), 10) : -1;
                if (digit < 0 && (digit1 < 0 || digit2 < 0)) {
                    return digit2 - digit1;
                }
                while (digit == 0) {
                    digit = pos > 0 ? Character.digit(name1.charAt(--pos), 10) : -1;
                }
                if (digit < 0) {
                    while (digit1 == 0) {
                        digit1 = pos1 < len1 ? Character.digit(name1.charAt(pos1++), 10) : -1;
                    }
                    while (digit2 == 0) {
                        digit2 = pos2 < len2 ? Character.digit(name2.charAt(pos2++), 10) : -1;
                    }
                }
                while (digit1 == digit2 && digit1 >= 0) {
                    digit1 = pos1 < len1 ? Character.digit(name1.charAt(pos1++), 10) : -1;
                    digit2 = pos2 < len2 ? Character.digit(name2.charAt(pos2++), 10) : -1;
                }
                boolean dig1 = digit1 >= 0;
                boolean dig2 = digit2 >= 0;
                int i = 0;
                while (dig1 && dig2) {
                    dig1 = pos1 + i < len1 && Character.isDigit(name1.charAt(pos1 + i));
                    dig2 = pos2 + i < len2 && Character.isDigit(name2.charAt(pos2 + i));
                    ++i;
                }
                if (dig1 != dig2) {
                    return dig1 ? 1 : -1;
                }
                if (digit1 != digit2) {
                    return digit1 - digit2;
                }
            }
            return ch1 - ch2;
        }
        return len1 - len2;
    }

    public static URL makeURLToFile(String fileName) {
        if (fileName.startsWith("file://")) {
            fileName = fileName.substring(6);
        }
        if (fileName.startsWith("file:/")) {
            fileName = fileName.substring(5);
        }
        File file = new File(fileName);
        try {
            return file.toURL();
        }
        catch (MalformedURLException e) {
            System.out.println("Cannot find file " + fileName);
            return null;
        }
    }

    public static String getFilePath(URL url) {
        int slashPos;
        int colonPos;
        if (url == null) {
            return "";
        }
        String filePath = url.getFile();
        int backSlashPos = filePath.lastIndexOf(92);
        int charPos = Math.max(backSlashPos, Math.max(colonPos = filePath.lastIndexOf(58), slashPos = filePath.lastIndexOf(47)));
        if (charPos < 0) {
            return "";
        }
        return filePath.substring(0, charPos + 1);
    }

    public static String getFileNameWithoutExtension(URL url) {
        int dotPos;
        int slashPos;
        int colonPos;
        String fileName = url.getFile();
        int backSlashPos = fileName.lastIndexOf(92);
        int charPos = Math.max(backSlashPos, Math.max(colonPos = fileName.lastIndexOf(58), slashPos = fileName.lastIndexOf(47)));
        if (charPos >= 0) {
            fileName = fileName.substring(charPos + 1);
        }
        if ((dotPos = fileName.lastIndexOf(46)) >= 0) {
            fileName = fileName.substring(0, dotPos);
        }
        StringBuffer buf = null;
        for (int i = 0; i < fileName.length(); ++i) {
            char ch = fileName.charAt(i);
            if (ch == '\n' || ch == '|' || ch == ':' || ch == ' ' || ch == '{' || ch == '}' || ch == ';') {
                if (buf == null) {
                    buf = new StringBuffer();
                    buf.append(fileName.substring(0, i));
                }
                buf.append('-');
                continue;
            }
            if (buf == null) continue;
            buf.append(ch);
        }
        if (buf != null) {
            String newS = buf.toString();
            System.out.println("File name " + fileName + " was converted to " + newS);
            return newS;
        }
        return fileName;
    }

    public static String getExtension(URL url) {
        if (url == null) {
            return "";
        }
        String fileName = url.getFile();
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos < 0) {
            return "";
        }
        return fileName.substring(dotPos + 1);
    }

    public static InputStream getURLStream(URL url) {
        return TextUtils.getURLStream(url, null);
    }

    public static InputStream getURLStream(URL url, StringBuffer errorMsg) {
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                if (errorMsg != null) {
                    errorMsg.append("Error: cannot open " + e.getMessage() + "\n");
                }
                System.out.println("Error: cannot open " + e.getMessage());
            }
        }
        return null;
    }

    public static boolean URLExists(URL url) {
        return TextUtils.URLExists(url, null);
    }

    public static boolean URLExists(URL url, StringBuffer errorMsg) {
        if (url == null) {
            return false;
        }
        try {
            URLConnection con = url.openConnection();
            con.connect();
            if (con.getContentLength() < 0) {
                return false;
            }
        }
        catch (IOException e) {
            if (errorMsg != null) {
                errorMsg.append("Error: cannot open " + e.getMessage() + "\n");
            }
            return false;
        }
        return true;
    }

    public static class NetworksByName
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Network n1 = (Network)o1;
            Network n2 = (Network)o2;
            String s1 = n1.describe(false);
            String s2 = n2.describe(false);
            return s1.compareToIgnoreCase(s2);
        }
    }

    public static class PrefsByName
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Pref p1 = (Pref)o1;
            Pref p2 = (Pref)o2;
            String s1 = p1.getPrefName();
            String s2 = p2.getPrefName();
            return s1.compareToIgnoreCase(s2);
        }
    }

    public static class CellsByDate
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Cell c1 = (Cell)o1;
            Cell c2 = (Cell)o2;
            Date r1 = c1.getRevisionDate();
            Date r2 = c2.getRevisionDate();
            return r1.compareTo(r2);
        }
    }

    public static class CellsByVersion
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Cell c1 = (Cell)o1;
            Cell c2 = (Cell)o2;
            return c2.getVersion() - c1.getVersion();
        }
    }

    public static class CellsByView
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Cell c1 = (Cell)o1;
            Cell c2 = (Cell)o2;
            View v1 = c1.getView();
            View v2 = c2.getView();
            return v1.getOrder() - v2.getOrder();
        }
    }

    public static class ObjectsByToString
    implements Comparator {
        public int compare(Object o1, Object o2) {
            String s1 = o1.toString();
            String s2 = o2.toString();
            return s1.compareToIgnoreCase(s2);
        }
    }

    private static class StringsWithNumbers
    implements Comparator {
        private StringsWithNumbers() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return TextUtils.nameSameNumeric(s1, s2);
        }
    }

    public static class UnitScale {
        private final String name;
        private final int index;
        private final String postFix;
        private final Number multiplier;
        private static final int UNIT_BASE = -3;
        private static final int UNIT_END = 5;
        public static final UnitScale GIGA = new UnitScale("Giga", "giga:  x 1000000000", -3, "G", new Integer(1000000000));
        public static final UnitScale MEGA = new UnitScale("Mega", "mega:  x 1000000", -2, "meg", new Integer(1000000));
        public static final UnitScale KILO = new UnitScale("Kilo", "kilo:  x 1000", -1, "k", new Integer(1000));
        public static final UnitScale NONE = new UnitScale("", "-:     x 1", 0, "", new Integer(1));
        public static final UnitScale MILLI = new UnitScale("Milli", "milli: x 10 ^ -3", 1, "m", new Double(0.001));
        public static final UnitScale MICRO = new UnitScale("Micro", "micro: x 10 ^ -6", 2, "u", new Double(1.0E-6));
        public static final UnitScale NANO = new UnitScale("Nano", "nano:  x 10 ^ -9", 3, "n", new Double(1.0E-9));
        public static final UnitScale PICO = new UnitScale("Pico", "pico:  x 10 ^ -12", 4, "p", new Double(1.0E-12));
        public static final UnitScale FEMTO = new UnitScale("Femto", "femto: x 10 ^ -15", 5, "f", new Double(1.0E-15));
        public static final UnitScale ATTO = new UnitScale("Atto", "atto:  x 10 ^ -18", 6, "a", new Double(1.0E-18));
        public static final UnitScale ZEPTO = new UnitScale("Zepto", "zepto: x 10 ^ -21", 7, "z", new Double(1.0E-21));
        public static final UnitScale YOCTO = new UnitScale("Yocto", "yocto: x 10 ^ -24", 8, "y", new Double(1.0E-24));
        private static final UnitScale[] allUnits = new UnitScale[]{GIGA, MEGA, KILO, NONE, MILLI, MICRO, NANO, PICO, FEMTO, ATTO, ZEPTO, YOCTO};

        private UnitScale(String name, String description, int index, String postFix, Number multiplier) {
            this.name = name;
            this.index = index;
            this.postFix = postFix;
            this.multiplier = multiplier;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getPostFix() {
            return this.postFix;
        }

        public Number getMultiplier() {
            return this.multiplier;
        }

        public static UnitScale findFromIndex(int index) {
            return allUnits[index - -3];
        }

        public static UnitScale[] getUnitScales() {
            return allUnits;
        }

        public String toString() {
            return this.name;
        }
    }
}

