/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.Aborter;
import com.sun.electric.tool.ncc.NccEngine;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.NccResult;
import com.sun.electric.tool.ncc.Passed;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.CompareList;
import com.sun.electric.tool.ncc.basic.CompareLists;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.processing.HierarchyInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class NccBottomUp {
    private static final Passed passed = new Passed();

    private void prln(String s) {
        System.out.println(s);
    }

    private CellContext selectAndRemoveReferenceCellContext(List cellCtxts) {
        Iterator it = cellCtxts.iterator();
        while (it.hasNext()) {
            CellContext cc = (CellContext)it.next();
            if (!cc.cell.isSchematic()) continue;
            it.remove();
            return cc;
        }
        it = cellCtxts.iterator();
        CellContext refCell = (CellContext)it.next();
        it.remove();
        return refCell;
    }

    private boolean hasBlackBoxAnnotation(CompareList compareList) {
        Iterator it = compareList.iterator();
        while (it.hasNext()) {
            String reason;
            Cell c = ((CellContext)it.next()).cell;
            NccCellAnnotations ann = NccCellAnnotations.getAnnotations(c);
            if (ann == null || (reason = ann.getBlackBoxReason()) == null) continue;
            this.prln("Black box: " + NccUtils.fullName(c) + " because " + reason);
            return true;
        }
        return false;
    }

    private NccResult compareAndPrintStatus(Cell cell1, VarContext ctxt1, Cell cell2, VarContext ctxt2, HierarchyInfo hierInfo, NccOptions options, Aborter aborter) {
        this.prln("Comparing: " + NccUtils.fullName(cell1) + " with: " + NccUtils.fullName(cell2));
        System.out.flush();
        Date before = new Date();
        NccResult result = NccEngine.compare(cell1, ctxt1, cell2, ctxt2, hierInfo, options, aborter);
        if (options.checkNetEquivalenceMap) {
            result.getNetEquivalence().regressionTest();
        }
        Date after = new Date();
        if (!aborter.userWantsToAbort()) {
            String timeStr = NccUtils.hourMinSec(before, after);
            this.prln(result.summary(options.checkSizes) + " in " + timeStr + ".");
            System.out.flush();
        }
        return result;
    }

    private NccResult compareCellsInCompareList(CompareList compareList, HierarchyInfo hierInfo, boolean blackBoxAnn, NccOptions options, Aborter aborter) {
        ArrayList<CellContext> cellCntxts = new ArrayList<CellContext>();
        HashSet<Cell> compareListCells = new HashSet<Cell>();
        Iterator it = compareList.iterator();
        while (it.hasNext()) {
            CellContext cc = (CellContext)it.next();
            cellCntxts.add(cc);
            compareListCells.add(cc.cell);
        }
        Cell cell = ((CellContext)cellCntxts.iterator().next()).cell;
        String grpNm = cell.getLibrary().getName() + ":" + cell.getName();
        hierInfo.beginNextCompareList(grpNm);
        if (this.hasNotSubcircuitAnnotation(cellCntxts)) {
            hierInfo.purgeCurrentCompareList();
        }
        NccResult result = new NccResult(true, true, true, null);
        CellContext refCC = this.selectAndRemoveReferenceCellContext(cellCntxts);
        Iterator it2 = cellCntxts.iterator();
        while (it2.hasNext()) {
            CellContext thisCC = (CellContext)it2.next();
            if (blackBoxAnn || options.skipPassed && passed.getPassed(refCC.cell, thisCC.cell)) {
                boolean ok;
                if (hierInfo == null || (ok = NccUtils.buildBlackBoxes(refCC, thisCC, hierInfo, options, aborter))) continue;
                return null;
            }
            hierInfo.restrictSubcktDetection(refCC, thisCC, compareListCells);
            result.abandonNccGlobals();
            NccResult r = this.compareAndPrintStatus(refCC.cell, refCC.context, thisCC.cell, thisCC.context, hierInfo, options, aborter);
            result.andEquals(r);
            if (r.match()) {
                passed.setPassed(refCC.cell, thisCC.cell);
            }
            if ((r.match() || !options.haltAfterFirstMismatch) && !aborter.userWantsToAbort()) continue;
            break;
        }
        if (!blackBoxAnn && options.operation != 0) {
            hierInfo.purgeCurrentCompareList();
        }
        return result;
    }

    private boolean hasNotSubcircuitAnnotation(List cellContextsInGroup) {
        Iterator it = cellContextsInGroup.iterator();
        while (it.hasNext()) {
            String notSubcktReason;
            Cell c = ((CellContext)it.next()).cell;
            NccCellAnnotations anns = NccCellAnnotations.getAnnotations(c);
            if (anns == null || (notSubcktReason = anns.getNotSubcircuitReason()) == null) continue;
            System.out.println("For this hierarchical NCC I'm not treating " + NccUtils.fullName(c) + " as a subcircuit because " + notSubcktReason);
            return true;
        }
        return false;
    }

    private NccResult processCompareLists(List compareLists, NccOptions options, Aborter aborter) {
        NccResult result = new NccResult(true, true, true, null);
        HierarchyInfo hierInfo = new HierarchyInfo();
        Iterator it = compareLists.iterator();
        while (it.hasNext()) {
            CompareList compareList = (CompareList)it.next();
            boolean blackBoxAnn = this.hasBlackBoxAnnotation(compareList);
            if (options.operation == 2 && !blackBoxAnn && it.hasNext() || options.checkSizes && options.operation != 2 && !compareList.isSafeToCheckSizes() && !blackBoxAnn) continue;
            result.abandonNccGlobals();
            NccResult r = this.compareCellsInCompareList(compareList, hierInfo, blackBoxAnn, options, aborter);
            if (r == null) {
                this.prln("Halting multiple cell NCC because of failure to build a black box");
                return result;
            }
            result.andEquals(r);
            if (aborter.userWantsToAbort()) {
                return result;
            }
            if (result.exportMatch() && result.topologyMatch() || !options.haltAfterFirstMismatch) continue;
            this.prln("Halting NCC after finding first mismatch");
            return result;
        }
        return result;
    }

    private NccResult compareCells(CellContext cc1, CellContext cc2, NccOptions options, Aborter aborter) {
        List compareLists = CompareLists.getCompareLists(cc1, cc2);
        return this.processCompareLists(compareLists, options, aborter);
    }

    public static NccResult compare(CellContext cc1, CellContext cc2, NccOptions options, Aborter aborter) {
        NccBottomUp ncch = new NccBottomUp();
        return ncch.compareCells(cc1, cc2, options, aborter);
    }

    public static void clearPassedHistory() {
        passed.clear();
    }
}

