/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class DXF
extends Input {
    private int lastGroupID;
    private String lastText;
    private boolean lastPairValid;
    private int ignoredPoints;
    private int ignoredAttributeDefs;
    private int ignoredAttributes;
    private int readPolyLines;
    private int readLines;
    private int readCircles;
    private int readSolids;
    private int read3DFaces;
    private int readArcs;
    private int readInserts;
    private int readTexts;
    private DXFLayer firstLayer;
    private ForwardRef firstForwardRef;
    private Cell mainCell;
    private Cell curCell;
    private List<String> headerText;
    private List<Integer> headerID;
    private int inputMode;
    private HashSet<String> validLayerNames;
    private HashSet<String> ignoredLayerNames;
    private TextUtils.UnitScale dispUnit;
    private int groupID;
    private String text;
    public static final Variable.Key DXF_LAYER_KEY = Variable.newKey("IO_dxf_layer");
    public static final Variable.Key DXF_HEADER_TEXT_KEY = Variable.newKey("IO_dxf_header_text");
    public static final Variable.Key DXF_HEADER_ID_KEY = Variable.newKey("IO_dxf_header_ID");

    protected Library importALibrary(Library lib) {
        try {
            if (this.readLibrary(lib)) {
                return null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lib;
    }

    private boolean readLibrary(Library lib) throws IOException {
        String warning;
        this.setCurUnits();
        this.getAcceptableLayers();
        this.mainCell = Cell.makeInstance(lib, lib.getName());
        if (this.mainCell == null) {
            return true;
        }
        Job.getUserInterface().setCurrentCell(lib, this.mainCell);
        this.curCell = this.mainCell;
        this.headerID = new ArrayList<Integer>();
        this.headerText = new ArrayList<String>();
        this.ignoredLayerNames = new HashSet();
        this.lastPairValid = false;
        boolean err = false;
        this.firstLayer = null;
        this.firstForwardRef = null;
        this.ignoredAttributeDefs = 0;
        this.ignoredAttributes = 0;
        this.ignoredPoints = 0;
        this.readSolids = 0;
        this.readCircles = 0;
        this.readLines = 0;
        this.readPolyLines = 0;
        this.readTexts = 0;
        this.readInserts = 0;
        this.readArcs = 0;
        this.read3DFaces = 0;
        this.inputMode = 0;
        while (!this.getNextPair()) {
            if (this.groupID != 0) {
                System.out.println("Expected group 0 (start section) at line " + this.lineReader.getLineNumber());
                break;
            }
            if (this.text.equals("EOF")) break;
            if (this.text.equals("SECTION")) {
                if (this.getNextPair()) break;
                if (this.groupID != 2) {
                    System.out.println("Expected group 2 (name) at line " + this.lineReader.getLineNumber());
                    err = true;
                    break;
                }
                if (this.text.equals("HEADER")) {
                    err = this.readHeaderSection();
                    if (!err) continue;
                    break;
                }
                if (this.text.equals("TABLES")) {
                    err = this.readTablesSection();
                    if (!err) continue;
                    break;
                }
                if (this.text.equals("BLOCKS")) {
                    err = this.readEntities(lib);
                    if (!err) continue;
                    break;
                }
                if (this.text.equals("ENTITIES")) {
                    err = this.readEntities(lib);
                    if (!err) continue;
                    break;
                }
                if (this.text.equals("CLASSES")) {
                    err = this.ignoreSection();
                    if (!err) continue;
                    break;
                }
                if (this.text.equals("OBJECTS")) {
                    err = this.ignoreSection();
                    if (!err) continue;
                    break;
                }
            }
            System.out.println("Unknown section name (" + this.text + ") at line " + this.lineReader.getLineNumber());
            err = true;
            break;
        }
        ForwardRef fr = this.firstForwardRef;
        while (fr != null) {
            Cell found = null;
            Iterator<Cell> it = lib.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                if (!cell.getName().equals(fr.refName)) continue;
                found = cell;
                break;
            }
            if (found == null) {
                System.out.println("Cannot find block '" + fr.refName + "'");
            } else if (IOTool.isDXFInputFlattensHierarchy()) {
                if (this.extractInsert(found, fr.x, fr.y, fr.xSca, fr.ySca, fr.rot, fr.parent)) {
                    return true;
                }
            } else {
                if ((fr.xSca != 1.0 || fr.ySca != 1.0) && (found = this.getScaledCell(found, fr.xSca, fr.ySca)) == null) {
                    return true;
                }
                ERectangle bounds = found.getBounds();
                Orientation orient = Orientation.fromAngle(fr.rot * 10);
                NodeInst ni = NodeInst.makeInstance(found, new Point2D.Double(fr.x, fr.y), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), fr.parent, orient, null, 0);
                if (ni == null) {
                    return true;
                }
                ni.setExpanded();
            }
            fr = fr.nextForwardRef;
        }
        if (this.headerID.size() > 0) {
            int len = this.headerID.size();
            Integer[] headerIDs = new Integer[len];
            for (int i = 0; i < len; ++i) {
                headerIDs[i] = this.headerID.get(i);
            }
            lib.newVar(DXF_HEADER_ID_KEY, (Object)headerIDs);
        }
        if (this.headerText.size() > 0) {
            int len = this.headerText.size();
            String[] headerTexts = new String[len];
            for (int i = 0; i < len; ++i) {
                headerTexts[i] = this.headerText.get(i);
            }
            lib.newVar(DXF_HEADER_TEXT_KEY, (Object)headerTexts);
        }
        if (this.readPolyLines > 0 || this.readLines > 0 || this.readCircles > 0 || this.readSolids > 0 || this.read3DFaces > 0 || this.readArcs > 0 || this.readTexts > 0 || this.readInserts > 0) {
            warning = "Read";
            boolean first = true;
            if (this.readPolyLines > 0) {
                if (first) {
                    warning = warning + ",";
                }
                first = false;
                warning = warning + " " + this.readPolyLines + " polylines";
            }
            if (this.readLines > 0) {
                if (first) {
                    warning = warning + ",";
                }
                first = false;
                warning = warning + " " + this.readLines + " lines";
            }
            if (this.readCircles > 0) {
                if (first) {
                    warning = warning + ",";
                }
                first = false;
                warning = warning + " " + this.readCircles + " circles";
            }
            if (this.readSolids > 0) {
                if (first) {
                    warning = warning + ",";
                }
                first = false;
                warning = warning + " " + this.readSolids + " solids";
            }
            if (this.read3DFaces > 0) {
                if (first) {
                    warning = warning + ",";
                }
                first = false;
                warning = warning + " " + this.read3DFaces + " 3d faces";
            }
            if (this.readArcs > 0) {
                if (first) {
                    warning = warning + ",";
                }
                first = false;
                warning = warning + " " + this.readArcs + " arcs";
            }
            if (this.readTexts > 0) {
                if (first) {
                    warning = warning + ",";
                }
                first = false;
                warning = warning + " " + this.readTexts + " texts";
            }
            if (this.readInserts > 0) {
                if (first) {
                    warning = warning + ",";
                }
                first = false;
                warning = warning + " " + this.readInserts + " inserts";
            }
            System.out.println(warning);
        }
        if (this.ignoredPoints > 0 || this.ignoredAttributes > 0 || this.ignoredAttributeDefs > 0) {
            warning = "Ignored";
            boolean first = true;
            if (this.ignoredPoints > 0) {
                if (first) {
                    warning = warning + ",";
                }
                first = false;
                warning = warning + " " + this.ignoredPoints + " points";
            }
            if (this.ignoredAttributes > 0) {
                if (first) {
                    warning = warning + ",";
                }
                first = false;
                warning = warning + " " + this.ignoredAttributes + " attributes";
            }
            if (this.ignoredAttributeDefs > 0) {
                if (first) {
                    warning = warning + ",";
                }
                first = false;
                warning = warning + " " + this.ignoredAttributeDefs + " attribute definitions";
            }
            System.out.println(warning);
        }
        if (this.ignoredLayerNames.size() > 0) {
            warning = "Ignored layers ";
            boolean first = true;
            for (String name : this.ignoredLayerNames) {
                if (!first) {
                    warning = warning + ", ";
                }
                first = false;
                warning = warning + "'" + name + "'";
            }
            System.out.println(warning);
        }
        return err;
    }

    private boolean getNextPair() throws IOException {
        if (this.lastPairValid) {
            this.text = this.lastText;
            this.groupID = this.lastGroupID;
            this.lastPairValid = false;
            return false;
        }
        do {
            this.lastText = this.getNextLine(false);
            if (this.lastText == null) {
                System.out.println("Unexpected end-of-file at line " + this.lineReader.getLineNumber());
                return true;
            }
            String groupLine = this.lastText.trim();
            if (!TextUtils.isANumber(groupLine)) {
                System.out.println("Invalid group ID on line " + this.lineReader.getLineNumber() + " (" + this.lastText + ")");
                return true;
            }
            this.groupID = TextUtils.atoi(groupLine);
            if (this.inputMode == 2) {
                this.getNextLine(true);
            }
            this.lastText = this.getNextLine(true);
            if (this.lastText == null) {
                System.out.println("Unexpected end-of-file at line " + this.lineReader.getLineNumber());
                return true;
            }
            this.text = this.lastText.trim();
            if (this.inputMode == 2) {
                this.getNextLine(true);
            }
            if (this.inputMode != 0) continue;
            if (this.lastText.length() != 0) {
                this.inputMode = 1;
                continue;
            }
            this.inputMode = 2;
            this.lastText = this.getNextLine(true);
            if (this.lastText == null) {
                System.out.println("Unexpected end-of-file at line " + this.lineReader.getLineNumber());
                return true;
            }
            this.text = this.lastText;
            this.getNextLine(true);
        } while (this.groupID == 999);
        return false;
    }

    private String getNextLine(boolean canBeBlank) throws IOException {
        String text;
        do {
            text = this.lineReader.readLine();
        } while (!canBeBlank && text.length() == 0);
        return text;
    }

    private boolean readHeaderSection() throws IOException {
        int line = 0;
        while (true) {
            if (this.getNextPair()) {
                return true;
            }
            if (this.groupID == 0 && this.text.equals("ENDSEC")) break;
            this.headerID.add(new Integer(this.groupID));
            this.headerText.add(this.text);
            ++line;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean readTablesSection() throws IOException {
        block9: while (true) {
            if (this.getNextPair()) {
                return true;
            }
            if (this.groupID == 0 && this.text.equals("ENDSEC")) break;
            if (this.groupID != 0 || !this.text.equals("TABLE")) continue;
            if (this.getNextPair()) {
                return true;
            }
            if (this.groupID != 2 || !this.text.equals("LAYER")) continue;
            if (this.getNextPair()) {
                return true;
            }
            if (this.groupID != 70) continue;
            layer = null;
            block10: while (true) {
                if (this.getNextPair()) {
                    return true;
                }
                if (this.groupID != 0 || !this.text.equals("ENDTAB")) ** break;
                continue block9;
                if (this.groupID == 0 && this.text.equals("LAYER")) {
                    layer = new DXFLayer();
                    DXFLayer.access$902(layer, null);
                    DXFLayer.access$1002(layer, -1);
                    DXFLayer.access$1102(layer, 1.0);
                    DXFLayer.access$1202(layer, 1.0);
                    DXFLayer.access$1302(layer, 1.0);
                    DXFLayer.access$1402(layer, this.firstLayer);
                    this.firstLayer = layer;
                }
                if (this.groupID == 2 && layer != null) {
                    DXFLayer.access$902(layer, this.text);
                }
                if (this.groupID != 62 || layer == null) continue;
                DXFLayer.access$1002(layer, TextUtils.atoi(this.text));
                found = null;
                l = this.firstLayer;
                while (l != null) {
                    if (l != layer && DXFLayer.access$1000(l) == DXFLayer.access$1000(layer)) {
                        found = l;
                        break;
                    }
                    l = DXFLayer.access$1400(l);
                }
                if (found != null) {
                    DXFLayer.access$1102(layer, DXFLayer.access$1100(found));
                    DXFLayer.access$1202(layer, DXFLayer.access$1200(found));
                    DXFLayer.access$1302(layer, DXFLayer.access$1300(found));
                    continue;
                }
                switch (DXFLayer.access$1000(layer)) {
                    case 1: {
                        DXFLayer.access$1102(layer, 1.0);
                        DXFLayer.access$1202(layer, 0.0);
                        DXFLayer.access$1302(layer, 0.0);
                        continue block10;
                    }
                    case 2: {
                        DXFLayer.access$1102(layer, 1.0);
                        DXFLayer.access$1202(layer, 1.0);
                        DXFLayer.access$1302(layer, 0.0);
                        continue block10;
                    }
                    case 3: {
                        DXFLayer.access$1102(layer, 0.0);
                        DXFLayer.access$1202(layer, 1.0);
                        DXFLayer.access$1302(layer, 0.0);
                        continue block10;
                    }
                    case 4: {
                        DXFLayer.access$1102(layer, 0.0);
                        DXFLayer.access$1202(layer, 1.0);
                        DXFLayer.access$1302(layer, 1.0);
                        continue block10;
                    }
                    case 5: {
                        DXFLayer.access$1102(layer, 0.0);
                        DXFLayer.access$1202(layer, 0.0);
                        DXFLayer.access$1302(layer, 1.0);
                        continue block10;
                    }
                    case 6: {
                        DXFLayer.access$1102(layer, 1.0);
                        DXFLayer.access$1202(layer, 0.0);
                        DXFLayer.access$1302(layer, 1.0);
                        continue block10;
                    }
                    case 7: {
                        DXFLayer.access$1102(layer, 0.75);
                        DXFLayer.access$1202(layer, 0.75);
                        DXFLayer.access$1302(layer, 0.75);
                        continue block10;
                    }
                }
                DXFLayer.access$1102(layer, Math.random());
                DXFLayer.access$1202(layer, Math.random());
                DXFLayer.access$1302(layer, Math.random());
            }
            break;
        }
        return false;
    }

    private boolean ignoreSection() throws IOException {
        do {
            if (!this.getNextPair()) continue;
            return true;
        } while (this.groupID != 0 || !this.text.equals("ENDSEC"));
        return false;
    }

    private boolean readEntities(Library lib) throws IOException {
        block18: {
            block19: {
                while (true) {
                    if (this.getNextPair()) {
                        return true;
                    }
                    if (this.groupID != 0) {
                        System.out.println("Unknown group code (" + this.groupID + ") at line " + this.lineReader.getLineNumber());
                        return true;
                    }
                    if (this.text.equals("ARC")) {
                        if (!this.readArcEntity()) continue;
                        return true;
                    }
                    if (this.text.equals("ATTDEF")) {
                        this.ignoreEntity();
                        ++this.ignoredAttributeDefs;
                        continue;
                    }
                    if (this.text.equals("ATTRIB")) {
                        this.ignoreEntity();
                        ++this.ignoredAttributes;
                        continue;
                    }
                    if (this.text.equals("BLOCK")) {
                        String msg = this.readBlock();
                        if (msg == null) {
                            return true;
                        }
                        this.curCell = Cell.makeInstance(lib, this.makeBlockName(msg));
                        if (this.curCell != null) continue;
                        return true;
                    }
                    if (this.text.equals("CIRCLE")) {
                        if (!this.readCircleEntity()) continue;
                        return true;
                    }
                    if (this.text.equals("ENDBLK")) {
                        this.ignoreEntity();
                        this.curCell = this.mainCell;
                        continue;
                    }
                    if (this.text.equals("ENDSEC")) break block18;
                    if (this.text.equals("INSERT")) {
                        if (!this.readInsertEntity(lib)) continue;
                        return true;
                    }
                    if (this.text.equals("LINE")) {
                        if (!this.readLineEntity()) continue;
                        return true;
                    }
                    if (this.text.equals("POINT")) {
                        this.ignoreEntity();
                        ++this.ignoredPoints;
                        continue;
                    }
                    if (this.text.equals("POLYLINE")) {
                        if (!this.readPolyLineEntity()) continue;
                        return true;
                    }
                    if (this.text.equals("SEQEND")) {
                        this.ignoreEntity();
                        continue;
                    }
                    if (this.text.equals("SOLID")) {
                        if (!this.readSolidEntity()) continue;
                        return true;
                    }
                    if (this.text.equals("TEXT")) {
                        if (!this.readTextEntity()) continue;
                        return true;
                    }
                    if (this.text.equals("VIEWPORT")) {
                        this.ignoreEntity();
                        continue;
                    }
                    if (!this.text.equals("3DFACE")) break block19;
                    if (this.read3DFaceEntity()) break;
                }
                return true;
            }
            System.out.println("Unknown entity type (" + this.text + ") at line " + this.lineReader.getLineNumber());
            return true;
        }
        return false;
    }

    private double scaleString(String text) {
        double v = TextUtils.atof(text);
        return TextUtils.convertFromDistance(v, Artwork.tech(), this.dispUnit);
    }

    private boolean readArcEntity() throws IOException {
        int iAngle;
        Orientation orient;
        NodeInst ni;
        DXFLayer layer = null;
        double x = 0.0;
        double y = 0.0;
        double rad = 0.0;
        double sAngle = 0.0;
        double eAngle = 0.0;
        do {
            if (this.getNextPair()) {
                return true;
            }
            switch (this.groupID) {
                case 8: {
                    layer = this.getLayer(this.text);
                    break;
                }
                case 10: {
                    x = this.scaleString(this.text);
                    break;
                }
                case 20: {
                    y = this.scaleString(this.text);
                    break;
                }
                case 30: {
                    break;
                }
                case 40: {
                    rad = this.scaleString(this.text);
                    break;
                }
                case 50: {
                    sAngle = TextUtils.atof(this.text);
                    break;
                }
                case 51: {
                    eAngle = TextUtils.atof(this.text);
                }
            }
        } while (this.groupID != 0);
        this.pushPair(this.groupID, this.text);
        if (!this.isAcceptableLayer(layer)) {
            return false;
        }
        if (sAngle >= 360.0) {
            sAngle -= 360.0;
        }
        if ((ni = NodeInst.makeInstance(Artwork.tech().circleNode, new Point2D.Double(x, y), rad * 2.0, rad * 2.0, this.curCell, orient = Orientation.fromAngle(iAngle = (int)(sAngle * 10.0)), null, 0)) == null) {
            return true;
        }
        if (sAngle > eAngle) {
            eAngle += 360.0;
        }
        double startOffset = sAngle;
        ni.setArcDegrees((startOffset -= (double)iAngle / 10.0) * Math.PI / 1800.0, (eAngle - sAngle) * Math.PI / 180.0);
        ni.newVar(DXF_LAYER_KEY, (Object)layer.layerName);
        ++this.readArcs;
        return false;
    }

    private String readBlock() throws IOException {
        String saveMsg = null;
        while (true) {
            if (this.getNextPair()) {
                return null;
            }
            if (this.groupID == 2) {
                saveMsg = this.text;
                continue;
            }
            if (this.groupID == 0) break;
        }
        this.pushPair(this.groupID, this.text);
        return saveMsg;
    }

    private boolean readCircleEntity() throws IOException {
        DXFLayer layer = null;
        double x = 0.0;
        double y = 0.0;
        double rad = 0.0;
        do {
            if (this.getNextPair()) {
                return true;
            }
            switch (this.groupID) {
                case 8: {
                    layer = this.getLayer(this.text);
                    break;
                }
                case 10: {
                    x = this.scaleString(this.text);
                    break;
                }
                case 20: {
                    y = this.scaleString(this.text);
                    break;
                }
                case 30: {
                    break;
                }
                case 40: {
                    rad = this.scaleString(this.text);
                }
            }
        } while (this.groupID != 0);
        this.pushPair(this.groupID, this.text);
        if (!this.isAcceptableLayer(layer)) {
            return false;
        }
        NodeInst ni = NodeInst.makeInstance(Artwork.tech().circleNode, new Point2D.Double(x, y), rad * 2.0, rad * 2.0, this.curCell);
        if (ni == null) {
            return true;
        }
        ni.newVar(DXF_LAYER_KEY, (Object)layer.layerName);
        ++this.readCircles;
        return false;
    }

    private boolean readInsertEntity(Library lib) throws IOException {
        int rot = 0;
        String name = null;
        int xRep = 1;
        int yRep = 1;
        double x = 0.0;
        double y = 0.0;
        double xSca = 1.0;
        double ySca = 1.0;
        do {
            if (this.getNextPair()) {
                return true;
            }
            switch (this.groupID) {
                case 8: {
                    break;
                }
                case 10: {
                    x = this.scaleString(this.text);
                    break;
                }
                case 20: {
                    y = this.scaleString(this.text);
                    break;
                }
                case 30: {
                    break;
                }
                case 50: {
                    rot = TextUtils.atoi(this.text);
                    break;
                }
                case 41: {
                    xSca = TextUtils.atof(this.text);
                    break;
                }
                case 42: {
                    ySca = TextUtils.atof(this.text);
                    break;
                }
                case 70: {
                    xRep = TextUtils.atoi(this.text);
                    break;
                }
                case 71: {
                    yRep = TextUtils.atoi(this.text);
                    break;
                }
                case 44: {
                    break;
                }
                case 45: {
                    break;
                }
                case 2: {
                    name = this.text;
                }
            }
        } while (this.groupID != 0);
        this.pushPair(this.groupID, this.text);
        String pt = this.makeBlockName(name);
        if (pt != null) {
            if (xRep != 1 || yRep != 1) {
                System.out.println("Cannot insert block '" + pt + "' repeated " + xRep + "x" + yRep + " times");
                return false;
            }
            Cell found = null;
            Iterator<Cell> it = lib.getCells();
            while (it.hasNext()) {
                Cell np = it.next();
                if (!np.getName().equals(pt)) continue;
                found = np;
                break;
            }
            if (found == null) {
                ForwardRef fr = new ForwardRef();
                fr.refName = pt;
                fr.parent = this.curCell;
                fr.x = x;
                fr.y = y;
                fr.rot = rot;
                fr.xSca = xSca;
                fr.ySca = ySca;
                fr.nextForwardRef = this.firstForwardRef;
                this.firstForwardRef = fr;
                return false;
            }
            if (IOTool.isDXFInputFlattensHierarchy()) {
                if (this.extractInsert(found, x, y, xSca, ySca, rot, this.curCell)) {
                    return true;
                }
            } else {
                Orientation orient;
                double sY;
                if ((xSca != 1.0 || ySca != 1.0) && (found = this.getScaledCell(found, xSca, ySca)) == null) {
                    return true;
                }
                double sX = found.getDefWidth();
                NodeInst ni = NodeInst.makeInstance(found, new Point2D.Double(x, y), sX, sY = found.getDefHeight(), this.curCell, orient = Orientation.fromAngle(rot * 10), null, 0);
                if (ni == null) {
                    return true;
                }
                ni.setExpanded();
            }
        }
        ++this.readInserts;
        return false;
    }

    private boolean readLineEntity() throws IOException {
        NodeInst ni;
        DXFLayer layer = null;
        boolean lineType = false;
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        do {
            if (this.getNextPair()) {
                return true;
            }
            switch (this.groupID) {
                case 8: {
                    layer = this.getLayer(this.text);
                    break;
                }
                case 10: {
                    x1 = this.scaleString(this.text);
                    break;
                }
                case 20: {
                    y1 = this.scaleString(this.text);
                    break;
                }
                case 30: {
                    break;
                }
                case 11: {
                    x2 = this.scaleString(this.text);
                    break;
                }
                case 21: {
                    y2 = this.scaleString(this.text);
                    break;
                }
            }
        } while (this.groupID != 0);
        this.pushPair(this.groupID, this.text);
        if (!this.isAcceptableLayer(layer)) {
            return false;
        }
        double cX = (x1 + x2) / 2.0;
        double cY = (y1 + y2) / 2.0;
        double sX = Math.abs(x1 - x2);
        double sY = Math.abs(y1 - y2);
        PrimitiveNode np = Artwork.tech().openedDashedPolygonNode;
        if (!lineType) {
            np = Artwork.tech().openedPolygonNode;
        }
        if ((ni = NodeInst.makeInstance(np, new Point2D.Double(cX, cY), sX, sY, this.curCell)) == null) {
            return true;
        }
        Point2D[] points = new EPoint[]{new EPoint(x1, y1), new EPoint(x2, y2)};
        ni.setTrace(points);
        ni.newVar(DXF_LAYER_KEY, (Object)layer.layerName);
        ++this.readLines;
        return false;
    }

    private boolean readPolyLineEntity() throws IOException {
        boolean closed = false;
        DXFLayer layer = null;
        boolean lineType = false;
        boolean inEnd = false;
        ArrayList<PolyPoint> polyPoints = new ArrayList<PolyPoint>();
        PolyPoint curPP = null;
        boolean hasBulgeInfo = false;
        while (true) {
            if (this.getNextPair()) {
                return true;
            }
            if (this.groupID == 8) {
                layer = this.getLayer(this.text);
                continue;
            }
            if (this.groupID == 10) {
                if (curPP == null) continue;
                curPP.x = this.scaleString(this.text);
                continue;
            }
            if (this.groupID == 20) {
                if (curPP == null) continue;
                curPP.y = this.scaleString(this.text);
                continue;
            }
            if (this.groupID == 30) {
                if (curPP == null) continue;
                curPP.z = this.scaleString(this.text);
                continue;
            }
            if (this.groupID == 42) {
                if (curPP == null) continue;
                curPP.bulge = TextUtils.atof(this.text);
                if (curPP.bulge == 0.0) continue;
                hasBulgeInfo = true;
                continue;
            }
            if (this.groupID == 70) {
                int i = TextUtils.atoi(this.text);
                if ((i & 1) == 0) continue;
                closed = true;
                continue;
            }
            if (this.groupID != 0) continue;
            if (inEnd) break;
            if (this.text.equals("SEQEND")) {
                inEnd = true;
                continue;
            }
            if (!this.text.equals("VERTEX")) continue;
            curPP = new PolyPoint();
            curPP.bulge = 0.0;
            polyPoints.add(curPP);
        }
        this.pushPair(this.groupID, this.text);
        int count = polyPoints.size();
        if (this.isAcceptableLayer(layer) && count >= 3) {
            if (hasBulgeInfo) {
                int start = 1;
                if (closed) {
                    start = 0;
                }
                for (int i = start; i < count; ++i) {
                    NodeInst ni;
                    double cY;
                    double cX;
                    int last = i - 1;
                    if (i == 0) {
                        last = count - 1;
                    }
                    PolyPoint pp = (PolyPoint)polyPoints.get(i);
                    PolyPoint lastPp = (PolyPoint)polyPoints.get(last);
                    double x1 = lastPp.x;
                    double y1 = lastPp.y;
                    double x2 = pp.x;
                    double y2 = pp.y;
                    if (lastPp.bulge != 0.0) {
                        double arcRad;
                        if (Math.abs(lastPp.bulge) == 1.0) {
                            Orientation orient;
                            cX = (x1 + x2) / 2.0;
                            cY = (y1 + y2) / 2.0;
                            if (y1 == cY && x1 == cX || y2 == cY && x2 == cX) {
                                System.out.println("Domain error in polyline bulge computation");
                                continue;
                            }
                            double sA = Math.atan2(y1 - cY, x1 - cX);
                            double eA = Math.atan2(y2 - cY, x2 - cX);
                            if (lastPp.bulge < 0.0) {
                                double r2 = sA;
                                sA = eA;
                                eA = r2;
                            }
                            if (sA < 0.0) {
                                sA += Math.PI * 2;
                            }
                            sA = sA * 1800.0 / Math.PI;
                            int iAngle = (int)sA;
                            double rad = new Point2D.Double(cX, cY).distance(new Point2D.Double(x1, y1));
                            NodeInst ni2 = NodeInst.makeInstance(Artwork.tech().circleNode, new Point2D.Double(cX, cY), rad * 2.0, rad * 2.0, this.curCell, orient = Orientation.fromAngle(iAngle), null, 0);
                            if (ni2 == null) {
                                return true;
                            }
                            double startOffset = sA;
                            ni2.setArcDegrees((startOffset -= (double)iAngle) * Math.PI / 1800.0, Math.PI);
                            ni2.newVar(DXF_LAYER_KEY, (Object)layer.layerName);
                            continue;
                        }
                        double x01 = x1;
                        double y01 = y1;
                        double x02 = x2;
                        double y02 = y2;
                        double dx = x02 - x01;
                        double dy = y02 - y01;
                        double dist = Math.hypot(dx, dy);
                        double incAngle = Math.atan(lastPp.bulge) * 4.0;
                        double rad = arcRad = Math.abs(dist / 2.0 / Math.sin(incAngle / 2.0));
                        double r2 = arcRad * arcRad;
                        double delta_1 = -dist / 2.0;
                        double delta_12 = delta_1 * delta_1;
                        double delta_2 = Math.sqrt(r2 - delta_12);
                        double bulgeSign = lastPp.bulge;
                        if (Math.abs(bulgeSign) > 1.0) {
                            bulgeSign = -bulgeSign;
                        }
                        double xcf = 0.0;
                        double ycf = 0.0;
                        if (bulgeSign > 0.0) {
                            xcf = x02 + (delta_1 * (x02 - x01) + delta_2 * (y01 - y02)) / dist;
                            ycf = y02 + (delta_1 * (y02 - y01) + delta_2 * (x02 - x01)) / dist;
                        } else {
                            xcf = x02 + (delta_1 * (x02 - x01) + delta_2 * (y02 - y01)) / dist;
                            ycf = y02 + (delta_1 * (y02 - y01) + delta_2 * (x01 - x02)) / dist;
                        }
                        x1 = xcf;
                        y1 = ycf;
                        if (y01 == ycf && x01 == xcf || y02 == ycf && x02 == xcf) {
                            System.out.println("Domain error in polyline computation");
                            continue;
                        }
                        double sA = Math.atan2(y01 - ycf, x01 - xcf);
                        double eA = Math.atan2(y02 - ycf, x02 - xcf);
                        if (lastPp.bulge < 0.0) {
                            r2 = sA;
                            sA = eA;
                            eA = r2;
                        }
                        if (sA < 0.0) {
                            sA += Math.PI * 2;
                        }
                        if (eA < 0.0) {
                            eA += Math.PI * 2;
                        }
                        sA = sA * 1800.0 / Math.PI;
                        eA = eA * 1800.0 / Math.PI;
                        int iAngle = (int)sA;
                        Orientation orient = Orientation.fromAngle(iAngle);
                        NodeInst ni3 = NodeInst.makeInstance(Artwork.tech().circleNode, new Point2D.Double(x1, y1), rad * 2.0, rad * 2.0, this.curCell, orient, null, 0);
                        if (ni3 == null) {
                            return true;
                        }
                        if (sA > eA) {
                            eA += 3600.0;
                        }
                        double startOffset = sA;
                        ni3.setArcDegrees((startOffset -= (double)iAngle) * Math.PI / 1800.0, (eA - sA) * Math.PI / 1800.0);
                        ni3.newVar(DXF_LAYER_KEY, (Object)layer.layerName);
                        continue;
                    }
                    cX = (x1 + x2) / 2.0;
                    cY = (y1 + y2) / 2.0;
                    PrimitiveNode np = Artwork.tech().openedDashedPolygonNode;
                    if (!lineType) {
                        np = Artwork.tech().openedPolygonNode;
                    }
                    if ((ni = NodeInst.makeInstance(np, new Point2D.Double(cX, cY), Math.abs(x1 - x2), Math.abs(y1 - y2), this.curCell)) == null) {
                        return true;
                    }
                    Point2D[] points = new Point2D[]{new Point2D.Double(x1, y1), new Point2D.Double(x2, y2)};
                    ni.setTrace(points);
                    ni.newVar(DXF_LAYER_KEY, (Object)layer.layerName);
                }
            } else {
                NodeInst ni;
                double lX = 0.0;
                double hX = 0.0;
                double lY = 0.0;
                double hY = 0.0;
                for (int i = 0; i < count; ++i) {
                    PolyPoint pp = (PolyPoint)polyPoints.get(i);
                    if (i == 0) {
                        lX = hX = pp.x;
                        lY = hY = pp.y;
                        continue;
                    }
                    if (pp.x < lX) {
                        lX = pp.x;
                    }
                    if (pp.x > hX) {
                        hX = pp.x;
                    }
                    if (pp.y < lY) {
                        lY = pp.y;
                    }
                    if (!(pp.y > hY)) continue;
                    hY = pp.y;
                }
                double cX = (lX + hX) / 2.0;
                double cY = (lY + hY) / 2.0;
                PrimitiveNode np = Artwork.tech().closedPolygonNode;
                if (!closed) {
                    np = !lineType ? Artwork.tech().openedPolygonNode : Artwork.tech().openedDashedPolygonNode;
                }
                if ((ni = NodeInst.makeInstance(np, new Point2D.Double(cX, cY), hX - lX, hY - lY, this.curCell)) == null) {
                    return true;
                }
                Point2D[] points = new Point2D[count];
                for (int i = 0; i < count; ++i) {
                    PolyPoint pp = (PolyPoint)polyPoints.get(i);
                    points[i] = new Point2D.Double(pp.x, pp.y);
                }
                ni.setTrace(points);
                ni.newVar(DXF_LAYER_KEY, (Object)layer.layerName);
            }
        }
        ++this.readPolyLines;
        return false;
    }

    private boolean readSolidEntity() throws IOException {
        double hY;
        double lY;
        double cY;
        double hX;
        DXFLayer layer = null;
        double factor = 1.0;
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double x3 = 0.0;
        double y3 = 0.0;
        double x4 = 0.0;
        double y4 = 0.0;
        do {
            if (this.getNextPair()) {
                return true;
            }
            switch (this.groupID) {
                case 8: {
                    layer = this.getLayer(this.text);
                    break;
                }
                case 10: {
                    x1 = this.scaleString(this.text);
                    break;
                }
                case 20: {
                    y1 = this.scaleString(this.text);
                    break;
                }
                case 30: {
                    break;
                }
                case 11: {
                    x2 = this.scaleString(this.text);
                    break;
                }
                case 21: {
                    y2 = this.scaleString(this.text);
                    break;
                }
                case 31: {
                    break;
                }
                case 12: {
                    x3 = this.scaleString(this.text);
                    break;
                }
                case 22: {
                    y3 = this.scaleString(this.text);
                    break;
                }
                case 32: {
                    break;
                }
                case 13: {
                    x4 = this.scaleString(this.text);
                    break;
                }
                case 23: {
                    y4 = this.scaleString(this.text);
                    break;
                }
                case 33: {
                    break;
                }
                case 230: {
                    factor = TextUtils.atof(this.text);
                }
            }
        } while (this.groupID != 0);
        this.pushPair(this.groupID, this.text);
        x1 *= factor;
        x2 *= factor;
        x3 *= factor;
        x4 *= factor;
        if (!this.isAcceptableLayer(layer)) {
            return false;
        }
        double lX = Math.min(Math.min(x1, x2), Math.min(x3, x4));
        double cX = (lX + (hX = Math.max(Math.max(x1, x2), Math.max(x3, x4)))) / 2.0;
        NodeInst ni = NodeInst.makeInstance(Artwork.tech().filledPolygonNode, new Point2D.Double(cX, cY = ((lY = Math.min(Math.min(y1, y2), Math.min(y3, y4))) + (hY = Math.max(Math.max(y1, y2), Math.max(y3, y4)))) / 2.0), hX - lX, hY - lY, this.curCell);
        if (ni == null) {
            return true;
        }
        Point2D[] points = new Point2D[]{new Point2D.Double(x1, y1), new Point2D.Double(x2, y2), new Point2D.Double(x3, y3), new Point2D.Double(x4, y4)};
        ni.setTrace(points);
        ni.newVar(DXF_LAYER_KEY, (Object)layer.layerName);
        ++this.readSolids;
        return false;
    }

    private boolean readTextEntity() throws IOException {
        DXFLayer layer = null;
        String msg = null;
        double x = 0.0;
        double y = 0.0;
        double height = 0.0;
        double xAlign = 0.0;
        boolean gotXA = false;
        do {
            if (this.getNextPair()) {
                return true;
            }
            switch (this.groupID) {
                case 8: {
                    layer = this.getLayer(this.text);
                    break;
                }
                case 10: {
                    x = this.scaleString(this.text);
                    break;
                }
                case 20: {
                    y = this.scaleString(this.text);
                    break;
                }
                case 40: {
                    height = this.scaleString(this.text);
                    break;
                }
                case 11: {
                    xAlign = this.scaleString(this.text);
                    gotXA = true;
                    break;
                }
                case 1: {
                    msg = this.text;
                }
            }
        } while (this.groupID != 0);
        this.pushPair(this.groupID, this.text);
        double lX = x;
        double hX = x;
        double lY = y;
        double hY = y;
        if (gotXA) {
            lX = Math.min(x, xAlign);
            hX = lX + Math.abs(xAlign - x) * 2.0;
            lY = y;
            hY = y + height;
        } else if (msg != null) {
            double h = msg.length();
            lX = x;
            hX = x + height * h;
            lY = y;
            hY = y + height;
        }
        if (!this.isAcceptableLayer(layer)) {
            return false;
        }
        if (msg != null) {
            NodeInst ni = NodeInst.makeInstance(Generic.tech().invisiblePinNode, new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0), hX - lX, hY - lY, this.curCell);
            if (ni == null) {
                return true;
            }
            TextDescriptor td = TextDescriptor.getNodeTextDescriptor().withPos(AbstractTextDescriptor.Position.BOXED).withAbsSize(63);
            ni.newVar(Artwork.ART_MESSAGE, (Object)msg, td);
            ni.newVar(DXF_LAYER_KEY, (Object)layer.layerName);
            ++this.readTexts;
        }
        return false;
    }

    private boolean read3DFaceEntity() throws IOException {
        double hY;
        double lY;
        double cY;
        double hX;
        DXFLayer layer = null;
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double x3 = 0.0;
        double y3 = 0.0;
        double x4 = 0.0;
        double y4 = 0.0;
        do {
            if (this.getNextPair()) {
                return true;
            }
            switch (this.groupID) {
                case 8: {
                    layer = this.getLayer(this.text);
                    break;
                }
                case 10: {
                    x1 = this.scaleString(this.text);
                    break;
                }
                case 20: {
                    y1 = this.scaleString(this.text);
                    break;
                }
                case 30: {
                    break;
                }
                case 11: {
                    x2 = this.scaleString(this.text);
                    break;
                }
                case 21: {
                    y2 = this.scaleString(this.text);
                    break;
                }
                case 31: {
                    break;
                }
                case 12: {
                    x3 = this.scaleString(this.text);
                    break;
                }
                case 22: {
                    y3 = this.scaleString(this.text);
                    break;
                }
                case 32: {
                    break;
                }
                case 13: {
                    x4 = this.scaleString(this.text);
                    break;
                }
                case 23: {
                    y4 = this.scaleString(this.text);
                    break;
                }
            }
        } while (this.groupID != 0);
        this.pushPair(this.groupID, this.text);
        if (!this.isAcceptableLayer(layer)) {
            return false;
        }
        double lX = Math.min(Math.min(x1, x2), Math.min(x3, x4));
        double cX = (lX + (hX = Math.max(Math.max(x1, x2), Math.max(x3, x4)))) / 2.0;
        NodeInst ni = NodeInst.makeInstance(Artwork.tech().closedPolygonNode, new Point2D.Double(cX, cY = ((lY = Math.min(Math.min(y1, y2), Math.min(y3, y4))) + (hY = Math.max(Math.max(y1, y2), Math.max(y3, y4)))) / 2.0), hX - lX, hY - lY, this.curCell);
        if (ni == null) {
            return true;
        }
        Point2D[] points = new Point2D[]{new Point2D.Double(x1, y1), new Point2D.Double(x2, y2), new Point2D.Double(x3, y3), new Point2D.Double(x4, y4)};
        ni.setTrace(points);
        ni.newVar(DXF_LAYER_KEY, (Object)layer.layerName);
        ++this.read3DFaces;
        return false;
    }

    private void ignoreEntity() throws IOException {
        while (!this.getNextPair() && this.groupID != 0) {
        }
        this.pushPair(this.groupID, this.text);
    }

    private boolean isAcceptableLayer(DXFLayer layer) {
        if (layer == null) {
            return false;
        }
        if (IOTool.isDXFInputReadsAllLayers()) {
            return true;
        }
        if (this.validLayerNames.contains(layer.layerName)) {
            return true;
        }
        this.ignoredLayerNames.add(layer.layerName);
        return false;
    }

    private boolean extractInsert(Cell onp, double x, double y, double xSca, double ySca, int rot, Cell np) {
        Orientation orient = Orientation.fromAngle(rot * 10);
        AffineTransform trans = orient.pureRotate();
        double m00 = trans.getScaleX();
        double m01 = trans.getShearX();
        double m11 = trans.getScaleY();
        double m10 = trans.getShearY();
        ERectangle bounds = onp.getBounds();
        double m02 = bounds.getCenterX() + x;
        double m12 = bounds.getCenterY() + y;
        trans.setTransform(m00, m10, m01, m11, m02, m12);
        Point2D.Double pt = new Point2D.Double(-m02, -m12);
        trans.transform(pt, pt);
        trans.setTransform(m00, m10, m01, m11, ((Point2D)pt).getX(), ((Point2D)pt).getY());
        Iterator<NodeInst> it = onp.getNodes();
        while (it.hasNext()) {
            Variable var;
            NodeInst ni = it.next();
            if (ni.isCellInstance()) {
                System.out.println("Cannot insert block '" + onp + "'...it has inserts in it");
                return true;
            }
            if (ni.getProto() == Generic.tech().cellCenterNode) continue;
            double sX = ni.getXSize() * xSca;
            double sY = ni.getYSize() * ySca;
            double cX = x + ni.getAnchorCenterX() * xSca;
            double cY = y + ni.getAnchorCenterY() * ySca;
            Point2D.Double tPt = new Point2D.Double(cX, cY);
            trans.transform(tPt, tPt);
            NodeInst nNi = NodeInst.makeInstance(ni.getProto(), tPt, sX, sY, np, orient.concatenate(ni.getOrient()), null, 0);
            if (nNi == null) {
                return true;
            }
            if (ni.getProto() == Artwork.tech().closedPolygonNode || ni.getProto() == Artwork.tech().filledPolygonNode || ni.getProto() == Artwork.tech().openedPolygonNode || ni.getProto() == Artwork.tech().openedDashedPolygonNode) {
                Point2D[] oldTrace = ni.getTrace();
                if (oldTrace != null) {
                    int len = oldTrace.length;
                    Point2D[] newTrace = new Point2D[len];
                    for (int i = 0; i < len; ++i) {
                        newTrace[i] = new Point2D.Double(cX + oldTrace[i].getX() * xSca, cY + oldTrace[i].getY() * ySca);
                    }
                    nNi.setTrace(newTrace);
                }
            } else if (ni.getProto() == Generic.tech().invisiblePinNode) {
                var = ni.getVar(Artwork.ART_MESSAGE);
                if (var != null) {
                    nNi.newVar(Artwork.ART_MESSAGE, var.getObject(), var.getTextDescriptor());
                }
            } else if (ni.getProto() == Artwork.tech().circleNode || ni.getProto() == Artwork.tech().thickCircleNode) {
                double[] curvature = ni.getArcDegrees();
                nNi.setArcDegrees(curvature[0], curvature[1]);
            }
            var = ni.getVar(DXF_LAYER_KEY);
            if (var != null) {
                nNi.newVar(DXF_LAYER_KEY, var.getObject());
            }
            if ((var = ni.getVar(Artwork.ART_COLOR)) == null) continue;
            nNi.newVar(Artwork.ART_COLOR, var.getObject());
        }
        return false;
    }

    private Cell getScaledCell(Cell onp, double xSca, double ySca) {
        String fViewName = "scaled" + xSca + "x" + ySca;
        String sViewName = "s" + xSca + "x" + ySca;
        View view = View.findView(fViewName);
        if (view == null && (view = View.newInstance(fViewName, sViewName)) == null) {
            return null;
        }
        Cell rightView = onp.otherView(view);
        if (rightView != null) {
            return rightView;
        }
        String cellName = onp.getName() + "{" + sViewName + "}";
        Cell np = Cell.makeInstance(onp.getLibrary(), cellName);
        if (np == null) {
            return null;
        }
        Iterator<NodeInst> it = onp.getNodes();
        while (it.hasNext()) {
            Variable var;
            NodeInst ni = it.next();
            if (ni.isCellInstance()) {
                System.out.println("Cannot insert block '" + onp + "'...it has inserts in it");
                return null;
            }
            NodeInst nNi = NodeInst.makeInstance(ni.getProto(), ni.getAnchorCenter(), ni.getXSize() * xSca, ni.getYSize() * ySca, np, ni.getOrient(), null, 0);
            if (nNi == null) {
                return null;
            }
            if (ni.getProto() == Artwork.tech().closedPolygonNode || ni.getProto() == Artwork.tech().filledPolygonNode || ni.getProto() == Artwork.tech().openedPolygonNode || ni.getProto() == Artwork.tech().openedDashedPolygonNode) {
                Point2D[] oldTrace = ni.getTrace();
                if (oldTrace != null) {
                    int len = oldTrace.length;
                    Point2D[] newTrace = new Point2D[len];
                    for (int i = 0; i < len; ++i) {
                        newTrace[i] = new Point2D.Double(oldTrace[i].getX() * xSca, oldTrace[i].getY() * ySca);
                    }
                    nNi.setTrace(newTrace);
                }
            } else if (ni.getProto() == Generic.tech().invisiblePinNode) {
                var = ni.getVar(Artwork.ART_MESSAGE);
                if (var != null) {
                    nNi.newVar(Artwork.ART_MESSAGE, var.getObject(), var.getTextDescriptor());
                }
            } else if (ni.getProto() == Artwork.tech().circleNode || ni.getProto() == Artwork.tech().thickCircleNode) {
                double[] curvature = ni.getArcDegrees();
                nNi.setArcDegrees(curvature[0], curvature[1]);
            }
            if ((var = ni.getVar(DXF_LAYER_KEY)) == null) continue;
            nNi.newVar(DXF_LAYER_KEY, var.getObject());
        }
        return np;
    }

    private DXFLayer getLayer(String name) {
        DXFLayer layer = this.firstLayer;
        while (layer != null) {
            if (name.equals(layer.layerName)) {
                return layer;
            }
            layer = layer.next;
        }
        layer = new DXFLayer();
        layer.layerName = name;
        layer.layerColor = -1;
        layer.layerRed = 1.0;
        layer.layerGreen = 1.0;
        layer.layerBlue = 1.0;
        layer.next = this.firstLayer;
        this.firstLayer = layer;
        return layer;
    }

    private void pushPair(int groupID, String text) {
        this.lastGroupID = groupID;
        this.lastText = text;
        this.lastPairValid = true;
    }

    private void getAcceptableLayers() {
        this.validLayerNames = new HashSet();
        Iterator<Layer> it = Artwork.tech().getLayers();
        while (it.hasNext()) {
            Layer lay = it.next();
            String layNames = lay.getDXFLayer();
            if (layNames == null) continue;
            while (layNames.length() > 0) {
                int commaPos = layNames.indexOf(44);
                if (commaPos < 0) {
                    commaPos = layNames.length();
                }
                String oneName = layNames.substring(0, commaPos);
                this.validLayerNames.add(oneName);
                if (!(layNames = layNames.substring(oneName.length())).startsWith(",")) continue;
                layNames = layNames.substring(1);
            }
        }
    }

    private String makeBlockName(String name) {
        StringBuffer infstr = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char chr = name.charAt(i);
            if (chr == '$' || chr == '{' || chr == '}' || chr == ':') {
                chr = '_';
            }
            infstr.append(chr);
        }
        return infstr.toString();
    }

    private void setCurUnits() {
        int units = IOTool.getDXFScale();
        switch (units) {
            case -3: {
                this.dispUnit = TextUtils.UnitScale.GIGA;
                break;
            }
            case -2: {
                this.dispUnit = TextUtils.UnitScale.MEGA;
                break;
            }
            case -1: {
                this.dispUnit = TextUtils.UnitScale.KILO;
                break;
            }
            case 0: {
                this.dispUnit = TextUtils.UnitScale.NONE;
                break;
            }
            case 1: {
                this.dispUnit = TextUtils.UnitScale.MILLI;
                break;
            }
            case 2: {
                this.dispUnit = TextUtils.UnitScale.MICRO;
                break;
            }
            case 3: {
                this.dispUnit = TextUtils.UnitScale.NANO;
                break;
            }
            case 4: {
                this.dispUnit = TextUtils.UnitScale.PICO;
                break;
            }
            case 5: {
                this.dispUnit = TextUtils.UnitScale.FEMTO;
            }
        }
    }

    private static class PolyPoint {
        double x;
        double y;
        double z;
        double bulge;

        private PolyPoint() {
        }
    }

    private static class ForwardRef {
        private String refName;
        private Cell parent;
        private double x;
        private double y;
        private int rot;
        private double xSca;
        private double ySca;
        private ForwardRef nextForwardRef;

        private ForwardRef() {
        }
    }

    private static class DXFLayer {
        private String layerName;
        private int layerColor;
        private double layerRed;
        private double layerGreen;
        private double layerBlue;
        private DXFLayer next;

        private DXFLayer() {
        }

        static /* synthetic */ int access$1000(DXFLayer x0) {
            return x0.layerColor;
        }

        static /* synthetic */ double access$1100(DXFLayer x0) {
            return x0.layerRed;
        }

        static /* synthetic */ double access$1200(DXFLayer x0) {
            return x0.layerGreen;
        }

        static /* synthetic */ double access$1300(DXFLayer x0) {
            return x0.layerBlue;
        }
    }
}

