/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.router;

import com.sun.electric.tool.generator.flag.router.Track;

public class Segment
implements Comparable {
    public final Track track;
    public final int trackNdx;
    public double min;
    public double max;

    public Segment(double xy1, double xy2, Track track, int trackNdx) {
        this.min = Math.min(xy1, xy2);
        this.max = Math.max(xy1, xy2);
        this.track = track;
        this.trackNdx = trackNdx;
    }

    public int compareTo(Object o) {
        double delta = this.min - ((Segment)o).min;
        return (int)Math.signum(delta);
    }

    public boolean isHorizontal() {
        return this.track.isHorizontal();
    }

    public double getTrackCenter() {
        return this.track.getCenter();
    }

    public double getSegmentMin() {
        return this.min;
    }

    public double getSegmentMax() {
        return this.max;
    }

    public void trim(double xy1, double xy2) {
        double xyMin = Math.min(xy1, xy2);
        double xyMax = Math.max(xy1, xy2);
        this.min = Math.max(this.min, xyMin);
        this.max = Math.min(this.max, xyMax);
        this.track.resort(this);
    }

    public String toString() {
        return "center=" + this.getTrackCenter() + " [" + this.min + ", " + this.max + "]";
    }
}

