/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Equipment;

public class HP81250
extends Equipment {
    String s = new String("null");
    String handle = new String();

    public HP81250(String name) {
        super(name);
    }

    void init(String _handle) {
        this.write(":DVT:IDN?");
        this.s = this.read(200).trim();
        System.out.println("dvt idn " + this.s);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.handle = _handle;
    }

    void start() {
        this.write(":dvt:instrument:handle:create? " + this.handle + ", \"DSR\",\"DSRA\"");
        this.s = this.read(200).trim();
        System.out.println("successfully created handle " + this.s);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void run(boolean state) {
        if (state) {
            this.write(":_" + this.handle + ":sgen:glob:init:cont ON");
        } else {
            this.write(":_" + this.handle + ":sgen:glob:init:cont OFF");
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void list() {
        this.write(":dvt:inst:hand:list?");
        this.s = this.read(200).trim();
        System.out.println("list of handles " + this.s);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void load_setting(String setting_name) {
        String actualSetting = new String();
        while (!actualSetting.equals(setting_name.toUpperCase())) {
            this.write(":_" + this.handle + ":mmem:setting:load \"" + setting_name + "\" ");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException _) {
                // empty catch block
            }
            String acSt = this.get_setting();
            actualSetting = acSt.substring(1, acSt.length() - 1);
        }
    }

    String get_setting() {
        this.write(":_" + this.handle + ":mmem:sett:name?");
        this.s = this.read(200).trim();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.s;
    }

    void countConnector() {
        this.write(":_" + this.handle + ":conf:cgr1:mod?");
        this.s = this.read(200).trim();
        System.out.println("number of modules " + this.s);
        Integer iObj = new Integer(this.s);
        for (int i = 1; i <= iObj; ++i) {
            this.write(":_" + this.handle + ":conf:cgr1:mod" + i + ":conn?");
            this.s = this.read(200).trim();
            System.out.println("module number " + i + " has " + this.s + " connectors");
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void setFreq(int f) {
        this.write(":_" + this.handle + ":sgen:global:freq " + f + "e6");
        this.write(":_" + this.handle + ":sgen:global:mux 4");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.write(":_" + this.handle + ":sgen:global:freq?");
        this.s = this.read(200).trim();
    }

    void createSetting(String setting_name) {
        this.run(false);
        this.write(":_" + this.handle + ":mmem:sett:new");
        this.write(":_" + this.handle + ":sgen:pdat1:app \"INPUT_PORT\",1,\"data\",ELEC");
        this.write(":_" + this.handle + ":sgen:PPUL1:app \"INPUT_PORT\",1,\"pulse\",ELEC");
        this.write(":_" + this.handle + ":sgen:PPUL2:app \"INPUT_PORT\",1,\"pulse\",ELEC");
        this.write(":_" + this.handle + ":sgen:conn:pdat1:term1:to (@0102004)");
        this.write(":_" + this.handle + ":sgen:conn:ppul1:term1:to (@0103002)");
        this.write(":_" + this.handle + ":sgen:conn:ppul2:term1:to (@0103001)");
        this.write(":_" + this.handle + ":mod2:conn4:volt:high 1.8");
        this.write(":_" + this.handle + ":mod3:conn2:volt:high 1.8");
        this.write(":_" + this.handle + ":mod3:conn1:volt:high 1.8");
        this.write(":_" + this.handle + ":mod2:conn4:dig:sign:format NRZ");
        this.write(":_" + this.handle + ":mod3:conn2:dig:sign:format RZ");
        this.write(":_" + this.handle + ":mod3:conn1:dig:sign:format RZ");
        this.write(":_" + this.handle + ":mod2:conn4:pulse:dcycle 10");
        this.write(":_" + this.handle + ":mod3:conn2:pulse:dcycle 30");
        this.write(":_" + this.handle + ":mod3:conn1:pulse:dcycle 30");
        this.write(":_" + this.handle + ":sgen:global:period 40e-9");
        this.write(":_" + this.handle + ":sgen:global:mux 4");
        this.write(":_" + this.handle + ":sgen:pdat1:mux 2.5E-1");
        this.write(":_" + this.handle + ":cgr1:mod3:conn2:mux 1");
        this.write(":_" + this.handle + ":cgr1:mod3:conn1:mux 1");
        this.write(":_" + this.handle + ":sgen:pdat1:mux?");
        String s = this.read(200).trim();
        System.out.println("mux " + s);
        this.write(":_" + this.handle + ":mod2:conn4:outp on");
        this.write(":_" + this.handle + ":mod3:conn2:outp on");
        this.write(":_" + this.handle + ":mod3:conn1:outp on");
        this.write(":_" + this.handle + ":SGEN:GLOB:SEQ (3.0,\"\",(SEQ,(LOOP4,0,20,\"00\",(BLOCK,0,16,0,\"00\",(),PAUSE0,0,0)),\"\",(BLOCK,0,16,0,\"00\",(),\"REFRESHCLK\",0,0),\"\",(LOOP5,0,INF,\"00\",(BLOCK,0,16,0,\"00\",(),PAUSE0,0,0))))");
        this.write(":_" + this.handle + ":SGEN:GLOB:SEQ:EVEN (3.0,(\"\",0,(('x','xxxxxxxx','xx',IGNORE))),(\"\",0,(('x','xxxxxxxx','xx',IGNORE))),(\"\",0,(('x','xxxxxxxx','xx',IGNORE))),(\"\",0,(('x','xxxxxxxx','xx',IGNORE))),(\"\",0,(('x','xxxxxxxx','xx',IGNORE))),(\"\",0,(('x','xxxxxxxx','xx',IGNORE))),(\"\",0,(('x','xxxxxxxx','xx',IGNORE))),(\"\",0,(('x','xxxxxxxx','xx',IGNORE))),(\"\",0,(('x','xxxxxxxx','xx',IGNORE))),(\"\",0,(('x','xxxxxxxx','xx',IGNORE))))");
        this.write(":_" + this.handle + ":SGEN:GLOB:SEQ:PCON 0");
        this.write(":_" + this.handle + ":mmem:sett:save \"" + setting_name + "\"");
    }

    void switchConnector(String mod, String conn, String state) {
        this.write(":_" + this.handle + ":mod" + mod + ":conn" + conn + ":outp " + state + "");
    }

    void getConnectorStat() {
        this.write(":_" + this.handle + ":sgen:glob:conn?");
        String s = this.read(200).trim();
        System.out.println("connector stat " + s);
    }

    void destroyHandle() {
        this.write("dvt:instrument:handle:destroy _" + this.handle + "");
        System.out.println("stopped");
        this.write(":dvt:instrument:handle:list?");
        String s = this.read(200).trim();
        System.out.println("handles left " + s);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void stepThruRefresh() {
        this.run(true);
        this.run(false);
    }

    private void checkConnectors() {
        this.start();
        this.list();
        this.load_setting("try2");
        this.setFreq(20);
        this.switchConnector("3", "1", "on");
        this.switchConnector("3", "2", "on");
        this.run(true);
        this.run(false);
        this.switchConnector("3", "1", "off");
        this.switchConnector("3", "2", "off");
        this.destroyHandle();
    }

    public static void main(String[] args) {
        boolean onlyKill = true;
        HP81250 bert = new HP81250("hp81250");
        bert.init("HANDLEA");
        bert.destroyHandle();
    }
}

