/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class SavedViews
extends EModelessDialog
implements HighlightListener {
    private static SavedViews theDialog = null;
    private JList viewList;
    private DefaultListModel viewListModel;
    private JButton done;
    private JLabel jLabel1;
    private JButton restoreView;
    private JButton saveView;
    private JTextField viewName;
    private JScrollPane viewPane;

    public static void showSavedViewsDialog() {
        if (theDialog == null) {
            TopLevel jf = null;
            if (TopLevel.isMDIMode()) {
                jf = TopLevel.getCurrentJFrame();
            }
            theDialog = new SavedViews(jf);
        }
        theDialog.setVisible(true);
        theDialog.toFront();
    }

    private SavedViews(Frame parent) {
        super(parent);
        this.initComponents();
        Highlighter.addHighlightListener(this);
        this.viewListModel = new DefaultListModel();
        this.viewList = new JList(this.viewListModel);
        this.viewList.setSelectionMode(0);
        this.viewPane.setViewportView(this.viewList);
        this.viewList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SavedViews.this.restoreView(null);
                }
            }
        });
        this.finishInitialization();
        this.loadInfo();
    }

    protected void escapePressed() {
        this.done(null);
    }

    private void loadInfo() {
        this.viewListModel.clear();
        EditWindow curWnd = EditWindow.getCurrent();
        if (curWnd == null) {
            return;
        }
        Cell cell = curWnd.getCell();
        if (cell == null) {
            return;
        }
        boolean found = false;
        Iterator<Variable> it = cell.getVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            String name = var.getKey().getName();
            if (!name.startsWith("USER_windowview_")) continue;
            this.viewListModel.addElement(name.substring(16));
            found = true;
        }
        if (found) {
            this.viewList.setSelectedIndex(0);
        }
    }

    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        this.loadInfo();
    }

    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        this.loadInfo();
    }

    private void initComponents() {
        this.done = new JButton();
        this.restoreView = new JButton();
        this.viewPane = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.viewName = new JTextField();
        this.saveView = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Window Views");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SavedViews.this.closeDialog(evt);
            }
        });
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SavedViews.this.done(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.done, gridBagConstraints);
        this.restoreView.setText("Restore View");
        this.restoreView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SavedViews.this.restoreView(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.restoreView, gridBagConstraints);
        this.viewPane.setMinimumSize(new Dimension(150, 150));
        this.viewPane.setPreferredSize(new Dimension(150, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.viewPane, gridBagConstraints);
        this.jLabel1.setText("View name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.viewName.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.viewName, gridBagConstraints);
        this.saveView.setText("Save This View");
        this.saveView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SavedViews.this.saveViewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.saveView, gridBagConstraints);
        this.pack();
    }

    private void saveViewActionPerformed(ActionEvent evt) {
        String name = this.viewName.getText().trim();
        if (name.length() == 0) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        if (!(wf.getContent() instanceof EditWindow)) {
            return;
        }
        EditWindow wnd = (EditWindow)wf.getContent();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        double scale = wnd.getScale();
        Point2D off = wnd.getOffset();
        new SaveViewJob(this, cell, name, scale, off.getX(), off.getY());
    }

    private void done(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void restoreView(ActionEvent evt) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        if (!(wf.getContent() instanceof EditWindow)) {
            return;
        }
        EditWindow wnd = (EditWindow)wf.getContent();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        int index2 = this.viewList.getSelectedIndex();
        String name = (String)this.viewListModel.get(index2);
        Variable var = cell.getVar("USER_windowview_" + name);
        if (var == null) {
            return;
        }
        Double[] pos = (Double[])var.getObject();
        wnd.setScale(pos[0]);
        Point2D.Double off = new Point2D.Double(pos[1], pos[2]);
        wnd.setOffset(off);
        wnd.fullRepaint();
    }

    private void closeDialog(WindowEvent evt) {
        Highlighter.removeHighlightListener(this);
        this.setVisible(false);
        this.dispose();
        theDialog = null;
    }

    private static class SaveViewJob
    extends Job {
        private transient SavedViews dialog;
        private Cell cell;
        private String name;
        private double scale;
        private double offX;
        private double offY;

        protected SaveViewJob(SavedViews dialog, Cell cell, String name, double scale, double offX, double offY) {
            super("Save Window View", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.cell = cell;
            this.name = name;
            this.scale = scale;
            this.offX = offX;
            this.offY = offY;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            Double[] pos = new Double[]{new Double(this.scale), new Double(this.offX), new Double(this.offY)};
            this.cell.newVar("USER_windowview_" + this.name, (Object)pos);
            return true;
        }

        public void terminateOK() {
            this.dialog.loadInfo();
        }
    }
}

