/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree;

import com.sun.electric.database.geometry.btree.CachingPageStorage;

public class MemoryPageStorage
extends CachingPageStorage {
    private CachedPageImpl[] pages = new CachedPageImpl[1];
    private int numpages = 0;

    public MemoryPageStorage(int pagesize) {
        super(pagesize);
    }

    @Override
    public int getNumPages() {
        return this.numpages;
    }

    @Override
    public int createPage() {
        if (this.numpages >= this.pages.length) {
            CachedPageImpl[] newpages = new CachedPageImpl[this.pages.length * 2];
            System.arraycopy(this.pages, 0, newpages, 0, this.pages.length);
            this.pages = newpages;
        }
        this.pages[this.numpages] = new CachedPageImpl(this.numpages);
        return this.numpages++;
    }

    @Override
    public void fsync(int pageid) {
    }

    @Override
    public void writePage(int pageid, byte[] buf, int ofs) {
        System.arraycopy(buf, ofs, this.pages[pageid].buf, 0, this.getPageSize());
    }

    @Override
    public void readPage(int pageid, byte[] buf, int ofs) {
        System.arraycopy(this.pages[pageid].buf, 0, buf, ofs, this.getPageSize());
    }

    @Override
    public synchronized void close() {
        this.pages = null;
    }

    @Override
    public CachingPageStorage.CachedPage getPage(int pageid, boolean readBytes) {
        return this.pages[pageid];
    }

    private class CachedPageImpl
    extends CachingPageStorage.CachedPage {
        private int pageid;
        private byte[] buf;
        private boolean dirty;

        public CachedPageImpl(int pageid) {
            this.pageid = pageid;
            this.buf = new byte[MemoryPageStorage.this.getPageSize()];
        }

        @Override
        public byte[] getBuf() {
            return this.buf;
        }

        @Override
        public int getPageId() {
            return this.pageid;
        }

        @Override
        public void touch() {
        }

        @Override
        public void setDirty() {
            this.dirty = true;
        }

        @Override
        public void flush() {
            this.dirty = false;
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }
    }
}

