/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.general;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.placement.Placement;
import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.general.RowCol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Control
extends PlacementFrame {
    @Override
    public String getAlgorithmName() {
        return "General Placement";
    }

    @Override
    public void runPlacement(List<PlacementFrame.PlacementNode> placementNodes, List<PlacementFrame.PlacementNetwork> allNetworks, String cellName, Job job) {
        if (placementNodes.size() > 100) {
            Cell newCell;
            System.out.println("Large placement task: breaking it into smaller tasks...");
            Library lib = PlacementAdapter.BUpa.doBottomUp(placementNodes, allNetworks);
            System.out.println("Placement decomposed into new library: " + lib.getName());
            System.out.println();
            HashMap<Cell, Cell> placedCells = new HashMap<Cell, Cell>();
            ArrayList<Cell> regularCells = new ArrayList<Cell>();
            ArrayList<Cell> irregularCells = new ArrayList<Cell>();
            Cell allClusters = null;
            Iterator<Cell> it = lib.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                if (cell.getName().equals("ALLCLUSTERS")) {
                    allClusters = cell;
                    continue;
                }
                Boolean useColumns = this.getColumnPlacement(cell);
                if (useColumns == null) {
                    irregularCells.add(cell);
                    continue;
                }
                regularCells.add(cell);
            }
            Placement.PlacementPreferences ppRowCol = new Placement.PlacementPreferences(false);
            ppRowCol.placementAlgorithm = PlacementAdapter.FD3.getAlgorithmName();
            PlacementAdapter.FD3.makeStacksEven.setValue(Boolean.TRUE);
            for (Cell cell : regularCells) {
                newCell = Placement.placeCellNoJob(cell, ppRowCol, true, job);
                if (newCell == null) continue;
                placedCells.put(cell, newCell);
            }
            Placement.PlacementPreferences ppIrregular = new Placement.PlacementPreferences(false);
            ppIrregular.placementAlgorithm = PlacementAdapter.BUpl.getAlgorithmName();
            for (Cell cell : irregularCells) {
                Cell newCell2 = Placement.placeCellNoJob(cell, ppIrregular, true, job);
                if (newCell2 == null) continue;
                placedCells.put(cell, newCell2);
            }
            if (allClusters != null) {
                Iterator<NodeInst> it2 = allClusters.getNodes();
                while (it2.hasNext()) {
                    Cell np;
                    Cell newCell3;
                    NodeInst ni = it2.next();
                    if (!ni.isCellInstance() || (newCell3 = (Cell)placedCells.get(np = (Cell)ni.getProto())) == null || ni.replace(newCell3, false, false) != null) continue;
                    System.out.println("ERROR: Could not replace node " + ni.describe(false) + " in cell " + allClusters.describe(false) + " with cell " + newCell3.describe(false));
                }
                for (Cell cell : placedCells.keySet()) {
                    Iterator<CellUsage> it3 = cell.getUsagesOf();
                    if (it3.hasNext()) continue;
                    cell.kill();
                }
                this.setRedispCell(allClusters);
                Placement.PlacementPreferences ppToplevel = new Placement.PlacementPreferences(false);
                ppToplevel.placementAlgorithm = PlacementAdapter.BUpl.getAlgorithmName();
                newCell = Placement.placeCellNoJob(allClusters, ppToplevel, false, job);
                if (newCell != null) {
                    this.setRedispCell(newCell);
                }
            }
            this.setFailure(true);
        } else {
            Boolean useColumns = RowCol.isColumnPlacement(placementNodes, null, null, true);
            if (useColumns == null) {
                System.out.println("General Placement algorithm chooses " + PlacementAdapter.BUpl.getAlgorithmName() + " to place the cell");
                PlacementAdapter.BUpl.runPlacement(placementNodes, allNetworks, cellName, job);
                return;
            }
            System.out.println("General Placement algorithm chooses " + PlacementAdapter.FD3.getAlgorithmName() + " to place the cell");
            PlacementAdapter.FD3.makeStacksEven.setValue(Boolean.TRUE);
            PlacementAdapter.FD3.runPlacement(placementNodes, allNetworks, cellName, job);
        }
    }

    public Boolean getColumnPlacement(Cell cell) {
        Double commonWid = new Double(-1.0);
        Double commonHei = new Double(-1.0);
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!ni.isCellInstance()) continue;
            if (commonWid != null) {
                if (commonWid < 0.0) {
                    commonWid = new Double(ni.getXSize());
                }
                if (commonWid.doubleValue() != ni.getXSize()) {
                    commonWid = null;
                }
            }
            if (commonHei == null) continue;
            if (commonHei < 0.0) {
                commonHei = new Double(ni.getYSize());
            }
            if (commonHei.doubleValue() == ni.getYSize()) continue;
            commonHei = null;
        }
        if (commonWid == null && commonHei == null) {
            return null;
        }
        Boolean useColumns = Boolean.FALSE;
        if (commonWid != null && commonHei == null) {
            useColumns = Boolean.TRUE;
        }
        return useColumns;
    }
}

