/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.waveform;

import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.util.Iterator;

public class SweepSignal {
    private String name;
    private WaveformWindow ww;
    private boolean included;
    private int sweepIndex;

    public SweepSignal(String name, WaveformWindow ww) {
        this.name = name;
        this.ww = ww;
        this.included = true;
    }

    public String toString() {
        String ret = this.name;
        if (this.included) {
            ret = ret + " >>>>> INCLUDED";
            if (this.ww.getHighlightedSweep() == this.sweepIndex) {
                ret = ret + " !!!!";
            }
        } else {
            ret = ret + " ----- EXCLUDED";
        }
        return ret;
    }

    public void setIncluded(boolean included, boolean update2) {
        if (this.included == included) {
            return;
        }
        this.included = included;
        if (update2) {
            Iterator<Panel> it = this.ww.getPanels();
            while (it.hasNext()) {
                Panel wp = it.next();
                wp.repaintWithRulers();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public void highlight() {
        this.ww.setHighlightedSweep(this.sweepIndex);
        Iterator<Panel> it = this.ww.getPanels();
        while (it.hasNext()) {
            Panel wp = it.next();
            wp.repaintWithRulers();
        }
    }
}

