/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.config.cache;

import com.sun.electric.util.CollectionFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeCache {
    private static TypeCache instance = new TypeCache();
    private Map<Class<?>, Set<Class<?>>> cache = CollectionFactory.createHashMap();

    private TypeCache() {
        this.createTypeHierarchy(Double.class);
        this.createTypeHierarchy(Integer.class);
        this.createTypeHierarchy(String.class);
        this.createTypeHierarchy(Boolean.class);
    }

    public static TypeCache getInstance() {
        return instance;
    }

    public Set<Class<?>> get(Class<?> clazz) {
        return this.cache.get(clazz);
    }

    public void put(Class<?> clazz, Set<Class<?>> set) {
        this.cache.put(clazz, set);
    }

    public void newEntry(Class<?> clazz) {
        HashSet<Class<?>> set = CollectionFactory.createHashSet();
        this.put(clazz, set);
    }

    public boolean contains(Class<?> clazz) {
        return this.cache.containsKey(clazz);
    }

    public boolean contains(Class<?> key, Class<?> value2) {
        if (this.contains(key)) {
            return this.get(key).contains(value2);
        }
        return false;
    }

    public void addEntry(Class<?> clazz, Class<?> entry) {
        Set<Class<?>> set = this.get(clazz);
        if (set == null) {
            this.newEntry(clazz);
            set = this.get(clazz);
        }
        set.add(entry);
        this.put(clazz, set);
    }

    public void createTypeHierarchy(Class<?> clazz) {
        if (this.contains(clazz)) {
            return;
        }
        this.walkThroughTypeHierarchy(clazz, clazz);
    }

    protected void walkThroughTypeHierarchy(Class<?> clazz, Class<?> father) {
        if (clazz == null) {
            return;
        }
        if (this.contains(clazz) && !clazz.equals(father)) {
            Set<Class<?>> path = this.get(clazz);
            for (Class<?> p : path) {
                this.addEntry(father, p);
            }
        } else {
            this.addEntry(father, clazz);
            for (Class<?> interfaces : clazz.getInterfaces()) {
                this.walkThroughTypeHierarchy(interfaces, father);
            }
            this.walkThroughTypeHierarchy(clazz.getSuperclass(), father);
        }
    }
}

