/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2.metrics;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.Block;
import com.sun.electric.tool.placement.genetic2.Reference;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DeltaBBMetric {
    static List<PlacementFrame.PlacementNode> nodesToPlace;
    static List<PlacementFrame.PlacementNetwork> allNetworks;
    static Reference ref;
    static List<Integer>[] networksOfNode;
    public static Map<PlacementFrame.PlacementNode, Integer> nodeBlocks;

    public static void init(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks) {
        int i;
        DeltaBBMetric.allNetworks = allNetworks;
        DeltaBBMetric.nodesToPlace = nodesToPlace;
        nodeBlocks = new HashMap<PlacementFrame.PlacementNode, Integer>();
        Iterator<PlacementFrame.PlacementNode> it = nodesToPlace.iterator();
        for (i = 0; i < nodesToPlace.size(); ++i) {
            nodeBlocks.put(it.next(), new Integer(i));
        }
        networksOfNode = new LinkedList[nodesToPlace.size()];
        for (i = 0; i < networksOfNode.length; ++i) {
            DeltaBBMetric.networksOfNode[i] = new LinkedList<Integer>();
        }
        for (int i2 = 0; i2 < allNetworks.size(); ++i2) {
            PlacementFrame.PlacementNetwork w = allNetworks.get(i2);
            List<PlacementFrame.PlacementPort> pp = w.getPortsOnNet();
            for (PlacementFrame.PlacementPort p : pp) {
                PlacementFrame.PlacementNode n = p.getPlacementNode();
                Integer ii = new Integer(i2);
                if (networksOfNode[nodeBlocks.get(n)].contains(ii)) continue;
                networksOfNode[nodeBlocks.get(n)].add(ii);
            }
        }
    }

    public static void setRef(Reference ref) {
        DeltaBBMetric.ref = ref;
    }

    public static double compute(List<Block> blocks, double[] netLengths) {
        double completeLength = DeltaBBMetric.ref.netLength;
        HashSet<Integer> changedNet = new HashSet<Integer>();
        for (Block b : blocks) {
            for (Integer j : networksOfNode[b.getNr()]) {
                changedNet.add(j);
            }
        }
        for (Integer i : changedNet) {
            PlacementFrame.PlacementNetwork w = allNetworks.get(i);
            List<PlacementFrame.PlacementPort> pp = w.getPortsOnNet();
            double left = Double.POSITIVE_INFINITY;
            double right = Double.NEGATIVE_INFINITY;
            double top = Double.NEGATIVE_INFINITY;
            double bottom = Double.POSITIVE_INFINITY;
            for (PlacementFrame.PlacementPort p : pp) {
                int blockId = nodeBlocks.get(p.getPlacementNode());
                double offX = p.getOffX();
                double offY = p.getOffY();
                Block b = null;
                for (Block currBlock : blocks) {
                    if (currBlock.getNr() != blockId) continue;
                    b = currBlock;
                }
                Orientation o = b != null ? b.getOrientation() : p.getPlacementNode().getPlacementOrientation();
                if (o != Orientation.IDENT) {
                    FixpTransform trans = o.pureRotate();
                    Point2D.Double offset = new Point2D.Double(offX, offY);
                    trans.transform(offset, offset);
                    offX = ((Point2D)offset).getX();
                    offY = ((Point2D)offset).getY();
                }
                double xpos = b != null ? b.getX() + offX : p.getPlacementNode().getPlacementX() + offX;
                double ypos = b != null ? b.getY() + offY : p.getPlacementNode().getPlacementY() + offY;
                if (xpos < left) {
                    left = xpos;
                }
                if (xpos > right) {
                    right = xpos;
                }
                if (ypos > top) {
                    top = ypos;
                }
                if (!(ypos < bottom)) continue;
                bottom = ypos;
            }
            netLengths[i.intValue()] = right - left + (top - bottom);
            completeLength += netLengths[i];
            completeLength -= DeltaBBMetric.ref.netLengths[i];
        }
        return completeLength;
    }

    public static double old_compute(List<Block> blocks, double[] netLengths) {
        double completeLength = 0.0;
        int n = 0;
        for (PlacementFrame.PlacementNetwork w : allNetworks) {
            List<PlacementFrame.PlacementPort> pp = w.getPortsOnNet();
            double left = Double.POSITIVE_INFINITY;
            double right = Double.NEGATIVE_INFINITY;
            double top = Double.NEGATIVE_INFINITY;
            double bottom = Double.POSITIVE_INFINITY;
            for (PlacementFrame.PlacementPort p : pp) {
                int blockId = nodeBlocks.get(p.getPlacementNode());
                double offX = p.getOffX();
                double offY = p.getOffY();
                Block b = null;
                for (Block currBlock : blocks) {
                    if (currBlock.getNr() != blockId) continue;
                    b = currBlock;
                }
                Orientation o = b != null ? b.getOrientation() : p.getPlacementNode().getPlacementOrientation();
                if (o != Orientation.IDENT) {
                    FixpTransform trans = o.pureRotate();
                    Point2D.Double offset = new Point2D.Double(offX, offY);
                    trans.transform(offset, offset);
                    offX = ((Point2D)offset).getX();
                    offY = ((Point2D)offset).getY();
                }
                double xpos = b != null ? b.getX() + offX : p.getPlacementNode().getPlacementX() + offX;
                double ypos = b != null ? b.getY() + offY : p.getPlacementNode().getPlacementY() + offY;
                if (xpos < left) {
                    left = xpos;
                }
                if (xpos > right) {
                    right = xpos;
                }
                if (ypos > top) {
                    top = ypos;
                }
                if (!(ypos < bottom)) continue;
                bottom = ypos;
            }
            completeLength += right - left + (top - bottom);
            netLengths[n] = right - left + (top - bottom);
            ++n;
        }
        return completeLength;
    }

    public static double compute() {
        double completeLength = 0.0;
        int n = 0;
        for (PlacementFrame.PlacementNetwork w : allNetworks) {
            List<PlacementFrame.PlacementPort> pp = w.getPortsOnNet();
            if (w.getPortsOnNet().size() == 0) {
                System.exit(-1337);
            }
            double l = pp.get(0).getPlacementNode().getPlacementX() + pp.get(0).getRotatedOffX();
            double r = pp.get(0).getPlacementNode().getPlacementX() + pp.get(0).getRotatedOffX();
            double u = pp.get(0).getPlacementNode().getPlacementY() + pp.get(0).getRotatedOffY();
            double d = pp.get(0).getPlacementNode().getPlacementY() + pp.get(0).getRotatedOffY();
            for (PlacementFrame.PlacementPort p : pp) {
                double xpos = p.getPlacementNode().getPlacementX() + p.getRotatedOffX();
                double ypos = p.getPlacementNode().getPlacementY() + p.getRotatedOffY();
                if (xpos < l) {
                    l = xpos;
                } else if (xpos > r) {
                    r = xpos;
                }
                if (ypos < d) {
                    d = ypos;
                    continue;
                }
                if (!(ypos > u)) continue;
                u = ypos;
            }
            completeLength += r - l + (u - d);
            DeltaBBMetric.ref.netLengths[n] = r - l + (u - d);
            ++n;
        }
        return completeLength;
    }
}

