/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree;

import com.sun.electric.database.geometry.btree.BTree;
import com.sun.electric.database.geometry.btree.CachingPageStorage;
import com.sun.electric.database.geometry.btree.NodeCursor;
import com.sun.electric.database.geometry.btree.unboxed.UnboxedInt;
import java.io.Serializable;

class InteriorNodeCursor<K extends Serializable & Comparable, V extends Serializable, S extends Serializable>
extends NodeCursor<K, V, S> {
    private final int INTERIOR_HEADER_SIZE;
    private final int INTERIOR_ENTRY_SIZE;
    private final int INTERIOR_MAX_BUCKETS;
    private final int SIZEOF_SUMMARY;
    private int numbuckets;

    public InteriorNodeCursor(BTree<K, V, S> bt) {
        super(bt);
        this.SIZEOF_SUMMARY = bt.summary == null ? 0 : bt.summary.getSize();
        this.INTERIOR_HEADER_SIZE = 12;
        this.INTERIOR_ENTRY_SIZE = bt.uk.getSize() + this.SIZEOF_SUMMARY + 4 + 4;
        this.INTERIOR_MAX_BUCKETS = (this.ps.getPageSize() - this.INTERIOR_HEADER_SIZE - 4 - this.SIZEOF_SUMMARY) / this.INTERIOR_ENTRY_SIZE;
    }

    public int insertNewBucketAt(int idx) {
        assert (!this.isFull());
        assert (idx != 0);
        if (idx < this.getNumBuckets()) {
            System.arraycopy(this.getBuf(), this.INTERIOR_HEADER_SIZE + (idx - 1) * this.INTERIOR_ENTRY_SIZE, this.getBuf(), this.INTERIOR_HEADER_SIZE + idx * this.INTERIOR_ENTRY_SIZE, this.endOfBuf() - (this.INTERIOR_HEADER_SIZE + (idx - 1) * this.INTERIOR_ENTRY_SIZE));
        }
        this.setNumBuckets(this.getNumBuckets() + 1);
        return this.INTERIOR_HEADER_SIZE + idx * this.INTERIOR_ENTRY_SIZE - this.bt.uk.getSize();
    }

    public static boolean isInteriorNode(byte[] buf) {
        return UnboxedInt.instance.deserializeInt(buf, 8) != 0;
    }

    @Override
    public int getMaxBuckets() {
        return this.INTERIOR_MAX_BUCKETS;
    }

    @Override
    public void initBuf(CachingPageStorage.CachedPage cp, int parent, boolean isRightMost) {
        super.setBuf(cp);
        this.setRightMost(isRightMost);
        this.setParent(parent);
    }

    @Override
    public int getNumBuckets() {
        return this.numbuckets;
    }

    @Override
    protected void setNumBuckets(int num) {
        this.numbuckets = num;
        this.bt.ui.serializeInt(this.numbuckets, this.getBuf(), 8);
    }

    @Override
    public void setBuf(CachingPageStorage.CachedPage cp) {
        super.setBuf(cp);
        this.numbuckets = this.bt.ui.deserializeInt(this.getBuf(), 8);
    }

    public void initRoot() {
        this.bt.rootpage = this.ps.createPage();
        super.setBuf(this.ps.getPage(this.bt.rootpage, false));
        this.setNumBuckets(1);
        this.setRightMost(true);
        this.setParent(this.bt.rootpage);
    }

    @Override
    public boolean isLeafNode() {
        return false;
    }

    @Override
    protected int endOfBuf() {
        return this.INTERIOR_HEADER_SIZE + this.getNumBuckets() * this.INTERIOR_ENTRY_SIZE - this.SIZEOF_SUMMARY - 4;
    }

    public int getBucketPageId(int idx) {
        return this.bt.ui.deserializeInt(this.getBuf(), this.INTERIOR_HEADER_SIZE + this.INTERIOR_ENTRY_SIZE * idx);
    }

    public void setBucketPageId(int idx, int pageid) {
        this.bt.ui.serializeInt(pageid, this.getBuf(), this.INTERIOR_HEADER_SIZE + this.INTERIOR_ENTRY_SIZE * idx);
    }

    @Override
    public int compare(byte[] key, int key_ofs, int keynum) {
        if (keynum <= 0) {
            return 1;
        }
        if (keynum >= this.getNumBuckets()) {
            return -1;
        }
        return this.bt.uk.compare(key, key_ofs, this.getBuf(), this.INTERIOR_HEADER_SIZE + keynum * this.INTERIOR_ENTRY_SIZE - this.bt.uk.getSize());
    }

    @Override
    protected void scoot(byte[] oldBuf, int endOfBuf, int splitPoint) {
        int len = this.INTERIOR_HEADER_SIZE + this.INTERIOR_ENTRY_SIZE * splitPoint;
        System.arraycopy(oldBuf, len, this.getBuf(), this.INTERIOR_HEADER_SIZE, endOfBuf - len);
    }

    @Override
    public void getKey(int keynum, byte[] key, int key_ofs) {
        assert (keynum != 0);
        System.arraycopy(this.getBuf(), this.INTERIOR_HEADER_SIZE + keynum * this.INTERIOR_ENTRY_SIZE - this.bt.uk.getSize(), key, key_ofs, this.bt.uk.getSize());
    }

    public void setNumValsBelowBucket(int idx, int num) {
        if (idx == this.getNumBuckets() - 1) {
            throw new RuntimeException("InteriorNodeCursors don't store numValuesBelowBucket() for their last bucket");
        }
        assert (idx >= 0 && idx < this.getNumBuckets() - 1);
        this.bt.ui.serializeInt(num, this.getBuf(), this.INTERIOR_HEADER_SIZE + 4 + this.SIZEOF_SUMMARY + this.INTERIOR_ENTRY_SIZE * idx);
    }

    @Override
    public int getNumValsBelowBucket(int bucket) {
        if (bucket >= this.getNumBuckets()) {
            return 0;
        }
        assert (bucket < this.getNumBuckets() - 1);
        return this.bt.ui.deserializeInt(this.getBuf(), this.INTERIOR_HEADER_SIZE + 4 + this.SIZEOF_SUMMARY + this.INTERIOR_ENTRY_SIZE * bucket);
    }

    public void mergeSummaryCommutative(int idx, byte[] buf, int ofs) {
        if (idx == this.getNumBuckets() - 1 && this.isRightMost()) {
            throw new RuntimeException("RightMost InteriorNodeCursors don't store a summary value for their last bucket");
        }
        assert (idx >= 0 && idx < this.getNumBuckets());
        this.bt.summary.multiply(buf, ofs, this.getBuf(), this.INTERIOR_HEADER_SIZE + 4 + this.INTERIOR_ENTRY_SIZE * idx, this.getBuf(), this.INTERIOR_HEADER_SIZE + 4 + this.INTERIOR_ENTRY_SIZE * idx);
    }

    public void setSummary(int idx, byte[] buf, int ofs) {
        if (idx == this.getNumBuckets() - 1 && this.isRightMost()) {
            throw new RuntimeException("RightMost InteriorNodeCursors don't store a summary value for their last bucket");
        }
        assert (idx >= 0 && idx < this.getNumBuckets());
        System.arraycopy(buf, ofs, this.getBuf(), this.INTERIOR_HEADER_SIZE + 4 + this.INTERIOR_ENTRY_SIZE * idx, this.bt.summary.getSize());
    }

    @Override
    public void getSummary(int idx, byte[] buf, int ofs) {
        if (idx == this.getNumBuckets() - 1 && this.isRightMost()) {
            throw new RuntimeException("RightMost InteriorNodeCursors don't store a summary value for their last bucket");
        }
        assert (idx >= 0 && idx < this.getNumBuckets());
        System.arraycopy(this.getBuf(), this.INTERIOR_HEADER_SIZE + 4 + this.INTERIOR_ENTRY_SIZE * idx, buf, ofs, this.bt.summary.getSize());
    }

    public int getSlotByChildPageId(int pageid) {
        for (int i = 0; i < this.getNumBuckets(); ++i) {
            if (this.getBucketPageId(i) != pageid) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void getSummary(byte[] buf, int ofs) {
        this.getSummary(0, buf, ofs);
        for (int i = 1; i < this.getNumBuckets(); ++i) {
            this.bt.summary.multiply(buf, ofs, this.getBuf(), this.INTERIOR_HEADER_SIZE + 4 + this.INTERIOR_ENTRY_SIZE * i, buf, ofs);
        }
    }

    @Override
    public int split(byte[] key, int key_ofs, int splitPoint) {
        int ret = super.split(key, key_ofs, splitPoint);
        for (int i = 0; i < this.getNumBuckets(); ++i) {
            CachingPageStorage.CachedPage cp = this.ps.getPage(this.getBucketPageId(i), true);
            this.bt.ui.serializeInt(this.getPageId(), cp.getBuf(), 0);
            cp.setDirty();
        }
        return ret;
    }
}

