/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.patterns;

import com.sun.electric.tool.util.concurrent.barriers.SimpleTDBarrier;
import com.sun.electric.tool.util.concurrent.barriers.TDBarrier;
import com.sun.electric.tool.util.concurrent.exceptions.PoolNotInitializedException;
import com.sun.electric.tool.util.concurrent.patterns.PTask;
import com.sun.electric.tool.util.concurrent.runtime.taskParallel.IThreadPool;
import com.sun.electric.tool.util.concurrent.runtime.taskParallel.ThreadPool;

public class PJob {
    public static final int SERIAL = -1;
    protected IThreadPool pool;
    protected TDBarrier barrier;

    public PJob() {
        this(ThreadPool.getThreadPool());
    }

    public PJob(IThreadPool pool) {
        this.pool = pool;
        this.barrier = new SimpleTDBarrier(0);
    }

    public synchronized void finishTask() {
        this.barrier.setActive(true);
    }

    public void execute() {
        this.execute(true);
    }

    public void execute(boolean block) {
        if (block) {
            this.join();
        }
    }

    public void join() {
        while (!this.barrier.isTerminated()) {
        }
    }

    public void add(PTask task, int threadID) {
        if (this.pool == null) {
            throw new PoolNotInitializedException();
        }
        this.barrier.setActive(false);
        this.pool.add(task, threadID);
    }

    public void add(PTask task) {
        this.add(task, -1);
    }

    public IThreadPool getThreadPool() {
        return this.pool;
    }
}

