/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.database.Environment;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.Variable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.Preferences;

public class Setting {
    private final Group xmlGroup;
    private final String xmlPath;
    private final Object factoryObj;
    private final String prefNode;
    private final String prefName;
    private boolean valid;
    private final String description;
    private final String location;
    private final String[] trueMeaning;
    private static Comparator<Setting> SETTINGS_BY_PREF_NAME = new Comparator<Setting>(){

        @Override
        public int compare(Setting s1, Setting s2) {
            String n1 = s1.getPrefName();
            String n2 = s2.getPrefName();
            return n1.compareTo(n2);
        }
    };

    public static RootGroup read(IdReader reader) throws IOException {
        RootGroup root = new RootGroup();
        root.read(reader);
        root.lock();
        return root;
    }

    protected Setting(String prefName, String prefGroup, Group xmlGroup, String xmlName, String location, String description, Object factoryObj, String ... trueMeaning) {
        if (xmlGroup == null) {
            throw new NullPointerException();
        }
        if (xmlGroup.root.isLocked()) {
            throw new IllegalStateException();
        }
        if (xmlName == null) {
            xmlName = prefName;
        }
        assert (TextUtils.isValidLayerName(xmlName));
        assert (!xmlGroup.settings.containsKey(xmlName));
        this.xmlPath = xmlGroup + xmlName;
        this.xmlGroup = xmlGroup;
        this.factoryObj = factoryObj;
        this.prefName = prefName;
        this.prefNode = prefGroup;
        xmlGroup.settings.put(xmlName, this);
        this.valid = true;
        this.description = description;
        this.location = location;
        this.trueMeaning = trueMeaning != null && trueMeaning.length > 0 ? (String[])trueMeaning.clone() : null;
    }

    public boolean getBoolean() {
        return (Boolean)this.getValue();
    }

    public int getInt() {
        return (Integer)this.getValue();
    }

    public long getLong() {
        return (Long)this.getValue();
    }

    public double getDouble() {
        return (Double)this.getValue();
    }

    public String getString() {
        String s2 = (String)this.getValue();
        if (s2 == null) {
            throw new NullPointerException();
        }
        return s2;
    }

    public Object getValue() {
        return Environment.getThreadEnvironment().getValue(this);
    }

    public String toString() {
        return this.getXmlPath();
    }

    public String getXmlPath() {
        return this.xmlPath;
    }

    public String getPrefName() {
        return this.prefName;
    }

    public String getPrefPath() {
        return this.prefNode + "/" + this.prefName;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }

    public void setValidOption(boolean valid) {
        if (this.xmlGroup.root.isLocked()) {
            throw new IllegalStateException();
        }
        this.valid = valid;
    }

    public boolean isValidOption() {
        return this.valid;
    }

    public String[] getTrueMeaning() {
        return this.trueMeaning != null ? (String[])this.trueMeaning.clone() : null;
    }

    public Object getFactoryValue() {
        return this.factoryObj;
    }

    public double getDoubleFactoryValue() {
        return (Double)this.factoryObj;
    }

    public int getIntFactoryValue() {
        return (Integer)this.factoryObj;
    }

    public void saveToPreferences(Preferences prefRoot, Object v) {
        assert (v.getClass() == this.factoryObj.getClass());
        Preferences prefs = prefRoot.node(this.prefNode);
        if (v.equals(this.factoryObj)) {
            prefs.remove(this.prefName);
            return;
        }
        if (v instanceof Boolean) {
            prefs.putBoolean(this.prefName, (Boolean)v);
        } else if (v instanceof Integer) {
            prefs.putInt(this.prefName, (Integer)v);
        } else if (v instanceof Long) {
            prefs.putLong(this.prefName, (Long)v);
        } else if (v instanceof Double) {
            prefs.putDouble(this.prefName, (Double)v);
        } else if (v instanceof String) {
            prefs.put(this.prefName, (String)v);
        } else assert (false);
    }

    public Object getValueFromPreferences(Preferences prefRoot) {
        Preferences prefs = prefRoot.node(this.prefNode);
        Object cachedObj = null;
        if (this.factoryObj instanceof Boolean) {
            cachedObj = prefs.getBoolean(this.prefName, (Boolean)this.factoryObj);
        } else if (this.factoryObj instanceof Integer) {
            cachedObj = prefs.getInt(this.prefName, (Integer)this.factoryObj);
        } else if (this.factoryObj instanceof Long) {
            cachedObj = prefs.getLong(this.prefName, (Long)this.factoryObj);
        } else if (this.factoryObj instanceof Double) {
            cachedObj = prefs.getDouble(this.prefName, (Double)this.factoryObj);
        } else if (this.factoryObj instanceof String) {
            cachedObj = prefs.get(this.prefName, (String)this.factoryObj);
        }
        assert (cachedObj != null);
        return cachedObj;
    }

    private void writeSetting(IdWriter writer) throws IOException {
        Variable.writeObject(writer, this.factoryObj);
        writer.writeString(this.prefNode);
        writer.writeString(this.prefName);
        writer.writeBoolean(this.valid);
        writer.writeString(this.description);
        writer.writeString(this.location);
        boolean hasTrueMeaning = this.trueMeaning != null;
        writer.writeBoolean(hasTrueMeaning);
        if (hasTrueMeaning) {
            writer.writeInt(this.trueMeaning.length);
            for (String s2 : this.trueMeaning) {
                writer.writeString(s2);
            }
        }
    }

    private static Setting readSetting(IdReader reader, Group group, String xmlName) throws IOException {
        Object factoryObj = Variable.readObject(reader);
        String prefGroup = reader.readString();
        String prefName = reader.readString();
        boolean valid = reader.readBoolean();
        String description = reader.readString();
        String location = reader.readString();
        String[] trueMeaning = null;
        boolean hasTrueMeaning = reader.readBoolean();
        if (hasTrueMeaning) {
            trueMeaning = new String[reader.readInt()];
            for (int i = 0; i < trueMeaning.length; ++i) {
                trueMeaning[i] = reader.readString();
            }
        }
        Setting setting = new Setting(prefName, prefGroup, group, xmlName, location, description, factoryObj, trueMeaning);
        setting.setValidOption(valid);
        return setting;
    }

    public static class SettingChangeBatch
    implements Serializable {
        public HashMap<String, Object> changesForSettings = new HashMap();

        public void add(Setting setting, Object newValue) {
            this.changesForSettings.put(setting.xmlPath, newValue);
        }
    }

    public static class RootGroup
    extends Group {
        private boolean locked;

        public static RootGroup newEmptyGroup() {
            RootGroup rootGroup = new RootGroup();
            rootGroup.lock();
            return rootGroup;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void lock() {
            this.locked = true;
        }

        @Override
        public void write(IdWriter writer) throws IOException {
            super.write(writer);
        }
    }

    public static class Group {
        public final String xmlPath;
        private final RootGroup root;
        private final LinkedHashMap<String, Group> children = new LinkedHashMap();
        private final LinkedHashMap<String, Setting> settings = new LinkedHashMap();

        private Group(RootGroup root, String xmlPath) {
            this.root = root;
            this.xmlPath = xmlPath;
        }

        private Group() {
            this.root = (RootGroup)this;
            this.xmlPath = "";
        }

        public Group node(String nodeName) {
            assert (nodeName.indexOf(46) == -1);
            if (nodeName.length() == 0) {
                return this;
            }
            Group child = this.children.get(nodeName);
            if (child == null) {
                if (this.root.isLocked()) {
                    throw new IllegalStateException();
                }
                child = new Group(this.root, this.xmlPath + nodeName + '.');
                this.children.put(nodeName, child);
            }
            return child;
        }

        public String getXmlPath() {
            return this.xmlPath;
        }

        public Setting makeBooleanSetting(String prefName, String prefGroup, String xmlName, String location, String description, boolean factory) {
            return new Setting(prefName, prefGroup, this, xmlName, location, description, factory, new String[0]);
        }

        public Setting makeIntSetting(String prefName, String prefGroup, String xmlName, String location, String description, int factory, String ... trueMeaning) {
            return new Setting(prefName, prefGroup, this, xmlName, location, description, factory, trueMeaning);
        }

        public Setting makeLongSetting(String prefName, String prefGroup, String xmlName, String location, String description, long factory) {
            return new Setting(prefName, prefGroup, this, xmlName, location, description, factory, new String[0]);
        }

        public Setting makeDoubleSetting(String prefName, String prefGroup, String xmlName, String location, String description, double factory) {
            return new Setting(prefName, prefGroup, this, xmlName, location, description, factory, new String[0]);
        }

        public Setting makeStringSetting(String prefName, String prefGroup, String xmlName, String location, String description, String factory) {
            return new Setting(prefName, prefGroup, this, xmlName, location, description, factory, new String[0]);
        }

        public Setting getSetting(String xmlPath) {
            int pos = xmlPath.indexOf(46);
            if (pos < 0) {
                return this.settings.get(xmlPath);
            }
            Group child = this.children.get(xmlPath.substring(0, pos));
            if (child == null) {
                return null;
            }
            return child.getSetting(xmlPath.substring(pos + 1));
        }

        public Collection<Setting> getSettings() {
            ArrayList<Setting> list = new ArrayList<Setting>();
            this.gatherSettings(list);
            return list;
        }

        private void gatherSettings(ArrayList<Setting> list) {
            list.addAll(this.settings.values());
            for (Group child : this.children.values()) {
                child.gatherSettings(list);
            }
        }

        public Map<Setting, Object> getDiskSettings(Map<Setting, Object> settingValues) {
            TreeMap<Setting, Object> result2 = new TreeMap<Setting, Object>(SETTINGS_BY_PREF_NAME);
            for (Setting setting : this.getSettings()) {
                Object value = settingValues.get(setting);
                if (!setting.isValidOption() || value.equals(setting.getFactoryValue())) continue;
                result2.put(setting, value);
            }
            return result2;
        }

        public String toString() {
            return this.xmlPath;
        }

        void write(IdWriter writer) throws IOException {
            String key;
            writer.writeInt(this.settings.size());
            for (Map.Entry<String, Setting> entry : this.settings.entrySet()) {
                key = entry.getKey();
                Setting setting = entry.getValue();
                writer.writeString(key);
                setting.writeSetting(writer);
            }
            writer.writeInt(this.children.size());
            for (Map.Entry<String, Object> entry : this.children.entrySet()) {
                key = entry.getKey();
                Group child = (Group)entry.getValue();
                writer.writeString(key);
                child.write(writer);
            }
        }

        void read(IdReader reader) throws IOException {
            int numSettings = reader.readInt();
            for (int i = 0; i < numSettings; ++i) {
                String key = reader.readString();
                Setting.readSetting(reader, this, key);
            }
            int numChildren = reader.readInt();
            for (int i = 0; i < numChildren; ++i) {
                String key = reader.readString();
                Group child = this.node(key);
                child.read(reader);
            }
        }
    }
}

