/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Member;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ClassInitializer;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpVisitor;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import gnu.expr.ObjectExp;
import gnu.expr.PairClassType;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.mapping.OutPort;
import java.util.Hashtable;
import java.util.Vector;

public class ClassExp
extends LambdaExp {
    boolean simple;
    public static final int IS_ABSTRACT = 16384;
    public static final int INTERFACE_SPECIFIED = 32768;
    public static final int CLASS_SPECIFIED = 65536;
    public static final int HAS_SUBCLASS = 131072;
    boolean explicitInit;
    ClassType instanceType;
    public String classNameSpecifier;
    public Expression[] supers;
    public int superClassIndex = -1;
    public LambdaExp initMethod;
    public LambdaExp clinitMethod;
    boolean partsDeclared;

    public boolean isSimple() {
        return this.simple;
    }

    public void setSimple(boolean value) {
        this.simple = value;
    }

    @Override
    public final boolean isAbstract() {
        return this.getFlag(16384);
    }

    public boolean isMakingClassPair() {
        return this.type != this.instanceType;
    }

    @Override
    public Type getType() {
        return this.simple ? Compilation.typeClass : Compilation.typeClassType;
    }

    @Override
    public ClassType getClassType() {
        return this.type;
    }

    public ClassExp() {
    }

    public ClassExp(boolean simple2) {
        this.simple = simple2;
        this.instanceType = this.type = new ClassType();
    }

    @Override
    protected boolean mustCompile() {
        return true;
    }

    @Override
    public void compile(Compilation comp, Target target) {
        if (target instanceof IgnoreTarget) {
            return;
        }
        this.compileMembers(comp);
        this.compilePushClass(comp, target);
    }

    public void compilePushClass(Compilation comp, Target target) {
        int nargs;
        ClassType typeType;
        ClassType new_class = this.type;
        CodeAttr code = comp.getCode();
        comp.loadClassRef(new_class);
        boolean needsLink = this.getNeedsClosureEnv();
        if (this.isSimple() && !needsLink) {
            return;
        }
        if (this.isMakingClassPair() || needsLink) {
            if (new_class == this.instanceType) {
                code.emitDup(this.instanceType);
            } else {
                comp.loadClassRef(this.instanceType);
            }
            typeType = ClassType.make("gnu.expr.PairClassType");
            nargs = needsLink ? 3 : 2;
        } else {
            typeType = ClassType.make("gnu.bytecode.Type");
            nargs = 1;
        }
        Type[] argsClass = new Type[nargs];
        if (needsLink) {
            this.getOwningLambda().loadHeapFrame(comp);
            argsClass[--nargs] = Type.pointer_type;
        }
        ClassType typeClass = ClassType.make("java.lang.Class");
        while (--nargs >= 0) {
            argsClass[nargs] = typeClass;
        }
        Method makeMethod = typeType.addMethod("make", argsClass, typeType, 9);
        code.emitInvokeStatic(makeMethod);
        target.compileFromStack(comp, typeType);
    }

    @Override
    protected ClassType getCompiledClassType(Compilation comp) {
        return this.type;
    }

    public void setTypes(Compilation comp) {
        ClassType[] interfaces;
        int nsupers = this.supers == null ? 0 : this.supers.length;
        ClassType[] superTypes = new ClassType[nsupers];
        ClassType superType = null;
        int j = 0;
        for (int i = 0; i < nsupers; ++i) {
            int modifiers;
            ClassType t;
            block31: {
                Type st = Language.getDefaultLanguage().getTypeFor(this.supers[i]);
                if (!(st instanceof ClassType)) {
                    comp.setLine(this.supers[i]);
                    comp.error('e', "invalid super type");
                    continue;
                }
                t = (ClassType)st;
                try {
                    modifiers = t.getModifiers();
                }
                catch (RuntimeException ex) {
                    modifiers = 0;
                    if (comp == null) break block31;
                    comp.error('e', "unknown super-type " + t.getName());
                }
            }
            if ((modifiers & 0x200) == 0) {
                if (j < i) {
                    comp.error('e', "duplicate superclass for " + this);
                }
                superType = t;
                this.superClassIndex = i;
                continue;
            }
            superTypes[j++] = t;
        }
        if (superType != null && (this.flags & 0x8000) != 0) {
            comp.error('e', "cannot be interface since has superclass");
        }
        if (!this.simple && superType == null && (this.flags & 0x10000) == 0 && (this.getFlag(131072) || this.nameDecl != null && this.nameDecl.isPublic())) {
            PairClassType ptype = new PairClassType();
            this.type = ptype;
            ptype.setInterface(true);
            ptype.instanceType = this.instanceType;
            ClassType[] interfaces2 = new ClassType[]{this.type};
            this.instanceType.setSuper(Type.pointer_type);
            this.instanceType.setInterfaces(interfaces2);
        } else if (this.getFlag(32768)) {
            this.instanceType.setInterface(true);
        }
        this.type.setSuper(superType == null ? Type.pointer_type : superType);
        if (j == nsupers) {
            interfaces = superTypes;
        } else {
            interfaces = new ClassType[j];
            System.arraycopy(superTypes, 0, interfaces, 0, j);
        }
        this.type.setInterfaces(interfaces);
        if (this.type.getName() == null) {
            String name;
            if (this.classNameSpecifier != null) {
                name = this.classNameSpecifier;
            } else {
                int nlen;
                name = this.getName();
                if (name != null && (nlen = name.length()) > 2 && name.charAt(0) == '<' && name.charAt(nlen - 1) == '>') {
                    name = name.substring(1, nlen - 1);
                }
            }
            if (name == null) {
                StringBuffer nbuf = new StringBuffer(100);
                comp.getModule().classFor(comp);
                nbuf.append(comp.mainClass.getName());
                nbuf.append('$');
                int len = nbuf.length();
                int i = 0;
                while (true) {
                    nbuf.append(i);
                    name = nbuf.toString();
                    if (comp.findNamedClass(name) != null) {
                        nbuf.setLength(len);
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if (!this.isSimple() || this instanceof ObjectExp) {
                name = comp.generateClassName(name);
            } else {
                int dot;
                int start = 0;
                StringBuffer nbuf = new StringBuffer(100);
                while ((dot = name.indexOf(46, start)) >= 0) {
                    nbuf.append(Compilation.mangleNameIfNeeded(name.substring(start, dot)));
                    start = dot + 1;
                    if (start >= name.length()) continue;
                    nbuf.append('.');
                }
                if (start == 0) {
                    int dot2;
                    String mainName = comp.mainClass == null ? null : comp.mainClass.getName();
                    int n = dot2 = mainName == null ? -1 : mainName.lastIndexOf(46);
                    if (dot2 > 0) {
                        nbuf.append(mainName.substring(0, dot2 + 1));
                    } else if (comp.classPrefix != null) {
                        nbuf.append(comp.classPrefix);
                    }
                } else if (start == 1 && start < name.length()) {
                    nbuf.setLength(0);
                    nbuf.append(comp.mainClass.getName());
                    nbuf.append('$');
                }
                if (start < name.length()) {
                    nbuf.append(Compilation.mangleNameIfNeeded(name.substring(start)));
                }
                name = nbuf.toString();
            }
            this.type.setName(name);
            comp.addClass(this.type);
            if (this.isMakingClassPair()) {
                this.instanceType.setName(this.type.getName() + "$class");
                comp.addClass(this.instanceType);
            }
        }
    }

    public void declareParts(Compilation comp) {
        if (this.partsDeclared) {
            return;
        }
        this.partsDeclared = true;
        Hashtable<String, Declaration> seenFields = new Hashtable<String, Declaration>();
        for (Declaration decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
            if (!decl.getCanRead()) continue;
            int flags = decl.getAccessFlags((short)1);
            if (decl.getFlag(2048L)) {
                flags |= 8;
            }
            if (this.isMakingClassPair()) {
                Type ftype = decl.getType().getImplementationType();
                this.type.addMethod(ClassExp.slotToMethodName("get", decl.getName()), flags |= 0x400, Type.typeArray0, ftype);
                Type[] stypes = new Type[]{ftype};
                this.type.addMethod(ClassExp.slotToMethodName("set", decl.getName()), flags, stypes, Type.voidType);
                continue;
            }
            String fname = Compilation.mangleNameIfNeeded(decl.getName());
            decl.field = this.instanceType.addField(fname, decl.getType(), flags);
            decl.setSimple(false);
            Declaration old = (Declaration)seenFields.get(fname);
            if (old != null) {
                ClassExp.duplicateDeclarationError(old, decl, comp);
            }
            seenFields.put(fname, decl);
        }
        LambdaExp child = this.firstChild;
        while (child != null) {
            if (child.isAbstract()) {
                this.setFlag(16384);
            }
            if ("*init*".equals(child.getName())) {
                this.explicitInit = true;
                if (child.isAbstract()) {
                    comp.error('e', "*init* method cannot be abstract", child);
                }
                if (this.type instanceof PairClassType) {
                    comp.error('e', "'*init*' methods only supported for simple classes");
                }
            }
            child.outer = this;
            if (child != this.initMethod && child != this.clinitMethod && child.nameDecl != null && !child.nameDecl.getFlag(2048L) || !this.isMakingClassPair()) {
                child.addMethodFor(this.type, comp, null);
            }
            if (this.isMakingClassPair()) {
                child.addMethodFor(this.instanceType, comp, this.type);
            }
            child = child.nextSibling;
        }
        if (!this.explicitInit && !this.instanceType.isInterface()) {
            Compilation.getConstructor(this.instanceType, this);
        }
        if (this.isAbstract()) {
            this.instanceType.setModifiers(this.instanceType.getModifiers() | 0x400);
        }
        if (this.nameDecl != null) {
            this.instanceType.setModifiers(this.instanceType.getModifiers() & 0xFFFFFFFE | this.nameDecl.getAccessFlags((short)1));
        }
    }

    static void getImplMethods(ClassType interfaceType, String mname, Type[] paramTypes, Vector vec) {
        ClassType implType;
        if (interfaceType instanceof PairClassType) {
            implType = ((PairClassType)interfaceType).instanceType;
        } else {
            if (!interfaceType.isInterface()) {
                return;
            }
            try {
                Class reflectClass = interfaceType.getReflectClass();
                if (reflectClass == null) {
                    return;
                }
                String implTypeName = interfaceType.getName() + "$class";
                ClassLoader loader = reflectClass.getClassLoader();
                Class<?> implClass = Class.forName(implTypeName, false, loader);
                implType = (ClassType)Type.make(implClass);
            }
            catch (Throwable ex) {
                return;
            }
        }
        Type[] itypes = new Type[paramTypes.length + 1];
        itypes[0] = interfaceType;
        System.arraycopy(paramTypes, 0, itypes, 1, paramTypes.length);
        Method implMethod = implType.getDeclaredMethod(mname, itypes);
        if (implMethod != null) {
            int count = vec.size();
            if (count == 0 || !vec.elementAt(count - 1).equals(implMethod)) {
                vec.addElement(implMethod);
            }
        } else {
            ClassType[] superInterfaces = interfaceType.getInterfaces();
            for (int i = 0; i < superInterfaces.length; ++i) {
                ClassExp.getImplMethods(superInterfaces[i], mname, paramTypes, vec);
            }
        }
    }

    private static void usedSuperClasses(ClassType clas, Compilation comp) {
        comp.usedClass(clas.getSuperclass());
        ClassType[] interfaces = clas.getInterfaces();
        if (interfaces != null) {
            int i = interfaces.length;
            while (--i >= 0) {
                comp.usedClass(interfaces[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassType compileMembers(Compilation comp) {
        ClassType saveClass = comp.curClass;
        Method saveMethod = comp.method;
        try {
            int nmethods;
            Method[] methods;
            CodeAttr code;
            String filename;
            ClassType new_class;
            comp.curClass = new_class = this.getCompiledClassType(comp);
            LambdaExp outer = this.outerLambda();
            AttrContainer enclosing = null;
            if (outer instanceof ClassExp) {
                enclosing = outer.type;
            } else if (outer != null && !(outer instanceof ModuleExp)) {
                enclosing = saveMethod;
            } else if (outer instanceof ModuleExp && this.type.getName().indexOf(36) > 0) {
                enclosing = outer.type;
            }
            if (enclosing != null) {
                new_class.setEnclosingMember((Member)((Object)enclosing));
                if (enclosing instanceof ClassType) {
                    ((ClassType)enclosing).addMemberClass(new_class);
                }
            }
            if (this.instanceType != new_class) {
                this.instanceType.setEnclosingMember(this.type);
                this.type.addMemberClass(this.instanceType);
            }
            ClassExp.usedSuperClasses(this.type, comp);
            if (this.type != this.instanceType) {
                ClassExp.usedSuperClasses(this.instanceType, comp);
            }
            if ((filename = this.getFileName()) != null) {
                new_class.setSourceFile(filename);
            }
            LambdaExp saveLambda = comp.curLambda;
            comp.curLambda = this;
            this.allocFrame(comp);
            LambdaExp child = this.firstChild;
            while (child != null) {
                if (!child.isAbstract()) {
                    Method save_method = comp.method;
                    LambdaExp save_lambda = comp.curLambda;
                    String saveFilename = comp.getFileName();
                    int saveLine = comp.getLineNumber();
                    int saveColumn = comp.getColumnNumber();
                    comp.setLine(child);
                    comp.method = child.getMainMethod();
                    Declaration childDecl = child.nameDecl;
                    if (childDecl == null || !childDecl.getFlag(2048L)) {
                        child.declareThis(comp.curClass);
                    }
                    comp.curClass = this.instanceType;
                    comp.curLambda = child;
                    comp.method.initCode();
                    child.allocChildClasses(comp);
                    child.allocParameters(comp);
                    if ("*init*".equals(child.getName())) {
                        PrimProcedure pproc;
                        Object value;
                        Expression exp;
                        code = comp.getCode();
                        if (this.staticLinkField != null) {
                            code.emitPushThis();
                            code.emitLoad(code.getCurrentScope().getVariable(1));
                            code.emitPutField(this.staticLinkField);
                        }
                        Expression bodyFirst = child.body;
                        while (bodyFirst instanceof BeginExp) {
                            BeginExp bbody = (BeginExp)bodyFirst;
                            if (bbody.length == 0) {
                                bodyFirst = null;
                                continue;
                            }
                            bodyFirst = bbody.exps[0];
                        }
                        ClassType calledInit = null;
                        if (bodyFirst instanceof ApplyExp && (exp = ((ApplyExp)bodyFirst).func) instanceof QuoteExp && (value = ((QuoteExp)exp).getValue()) instanceof PrimProcedure && (pproc = (PrimProcedure)value).isSpecial() && "<init>".equals(pproc.method.getName())) {
                            calledInit = pproc.method.getDeclaringClass();
                        }
                        ClassType superClass = this.instanceType.getSuperclass();
                        if (calledInit != null) {
                            bodyFirst.compileWithPosition(comp, Target.Ignore);
                            if (calledInit != this.instanceType && calledInit != superClass) {
                                comp.error('e', "call to <init> for not this or super class");
                            }
                        } else if (superClass != null) {
                            ClassExp.invokeDefaultSuperConstructor(superClass, comp, this);
                        }
                        child.enterFunction(comp);
                        if (calledInit != this.instanceType) {
                            comp.callInitMethods(this.getCompiledClassType(comp), new Vector<ClassType>(10));
                        }
                        if (calledInit != null) {
                            Expression.compileButFirst(child.body, comp);
                        } else {
                            child.compileBody(comp);
                        }
                    } else {
                        child.enterFunction(comp);
                        child.compileBody(comp);
                    }
                    child.compileEnd(comp);
                    child.generateApplyMethods(comp);
                    comp.method = save_method;
                    comp.curClass = new_class;
                    comp.curLambda = save_lambda;
                    comp.setLine(saveFilename, saveLine, saveColumn);
                }
                child = child.nextSibling;
            }
            if (!this.explicitInit && !this.instanceType.isInterface()) {
                comp.generateConstructor(this.instanceType, this);
            } else if (this.initChain != null) {
                this.initChain.reportError("unimplemented: explicit constructor cannot initialize ", comp);
            }
            if (this.isAbstract()) {
                methods = null;
                nmethods = 0;
            } else {
                methods = this.type.getAbstractMethods();
                nmethods = methods.length;
            }
            for (int i = 0; i < nmethods; ++i) {
                char ch;
                Method meth = methods[i];
                String mname = meth.getName();
                Type[] ptypes = meth.getParameterTypes();
                Type rtype = meth.getReturnType();
                Method mimpl = this.instanceType.getMethod(mname, ptypes);
                if (mimpl != null && !mimpl.isAbstract()) continue;
                if (mname.length() > 3 && mname.charAt(2) == 't' && mname.charAt(1) == 'e' && ((ch = mname.charAt(0)) == 'g' || ch == 's')) {
                    Type ftype;
                    if (ch == 's' && rtype.isVoid() && ptypes.length == 1) {
                        ftype = ptypes[0];
                    } else {
                        if (ch != 'g' || ptypes.length != 0) continue;
                        ftype = rtype;
                    }
                    String fname = Character.toLowerCase(mname.charAt(3)) + mname.substring(4);
                    Field fld = this.instanceType.getField(fname);
                    if (fld == null) {
                        fld = this.instanceType.addField(fname, ftype, 1);
                    }
                    Method impl = this.instanceType.addMethod(mname, 1, ptypes, rtype);
                    code = impl.startCode();
                    code.emitPushThis();
                    if (ch == 'g') {
                        code.emitGetField(fld);
                    } else {
                        code.emitLoad(code.getArg(1));
                        code.emitPutField(fld);
                    }
                    code.emitReturn();
                    continue;
                }
                Vector vec = new Vector();
                ClassExp.getImplMethods(this.type, mname, ptypes, vec);
                if (vec.size() != 1) {
                    String msg = vec.size() == 0 ? "missing implementation for " : "ambiguous implementation for ";
                    comp.error('e', msg + meth);
                    continue;
                }
                Method impl = this.instanceType.addMethod(mname, 1, ptypes, rtype);
                code = impl.startCode();
                for (Variable var = code.getCurrentScope().firstVar(); var != null; var = var.nextVar()) {
                    code.emitLoad(var);
                }
                Method imethod = (Method)vec.elementAt(0);
                code.emitInvokeStatic(imethod);
                code.emitReturn();
            }
            this.generateApplyMethods(comp);
            comp.curLambda = saveLambda;
            ClassType classType = new_class;
            return classType;
        }
        finally {
            comp.curClass = saveClass;
            comp.method = saveMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <R, D> R visit(ExpVisitor<R, D> visitor, D d) {
        Compilation comp = visitor.getCompilation();
        if (comp == null) {
            return visitor.visitClassExp(this, d);
        }
        ClassType saveClass = comp.curClass;
        try {
            comp.curClass = this.type;
            R r = visitor.visitClassExp(this, d);
            return r;
        }
        finally {
            comp.curClass = saveClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <R, D> void visitChildren(ExpVisitor<R, D> visitor, D d) {
        LambdaExp save = visitor.currentLambda;
        visitor.currentLambda = this;
        this.supers = visitor.visitExps(this.supers, this.supers.length, d);
        try {
            LambdaExp child = this.firstChild;
            while (child != null && visitor.exitValue == null) {
                Declaration firstParam;
                if (this.instanceType != null && (firstParam = child.firstDecl()) != null && firstParam.isThisParameter()) {
                    firstParam.setType(this.type);
                }
                visitor.visitLambdaExp(child, d);
                child = child.nextSibling;
            }
        }
        finally {
            visitor.currentLambda = save;
        }
    }

    static void loadSuperStaticLink(Expression superExp, ClassType superClass, Compilation comp) {
        CodeAttr code = comp.getCode();
        superExp.compile(comp, Target.pushValue(Compilation.typeClassType));
        code.emitInvokeStatic(ClassType.make("gnu.expr.PairClassType").getDeclaredMethod("extractStaticLink", 1));
        code.emitCheckcast(superClass.getOuterLinkType());
    }

    static void invokeDefaultSuperConstructor(ClassType superClass, Compilation comp, LambdaExp lexp) {
        CodeAttr code = comp.getCode();
        Method superConstructor = superClass.getDeclaredMethod("<init>", 0);
        if (superConstructor == null) {
            comp.error('e', "super class does not have a default constructor");
        } else {
            code.emitPushThis();
            if (superClass.hasOuterLink() && lexp instanceof ClassExp) {
                ClassExp clExp = (ClassExp)lexp;
                Expression superExp = clExp.supers[clExp.superClassIndex];
                ClassExp.loadSuperStaticLink(superExp, superClass, comp);
            }
            code.emitInvokeSpecial(superConstructor);
        }
    }

    @Override
    public void print(OutPort out) {
        out.startLogicalBlock("(" + this.getExpClassName() + "/", ")", 2);
        Object name = this.getSymbol();
        if (name != null) {
            out.print(name);
            out.print('/');
        }
        out.print(this.id);
        out.print("/fl:");
        out.print(Integer.toHexString(this.flags));
        if (this.supers.length > 0) {
            out.writeSpaceFill();
            out.startLogicalBlock("supers:", "", 2);
            for (int i = 0; i < this.supers.length; ++i) {
                this.supers[i].print(out);
                out.writeSpaceFill();
            }
            out.endLogicalBlock("");
        }
        out.print('(');
        Object prevMode = null;
        int i = 0;
        int key_args = this.keywords == null ? 0 : this.keywords.length;
        for (Declaration decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
            if (i > 0) {
                out.print(' ');
            }
            decl.printInfo(out);
            ++i;
        }
        out.print(") ");
        LambdaExp child = this.firstChild;
        while (child != null) {
            out.writeBreakLinear();
            child.print(out);
            child = child.nextSibling;
        }
        if (this.body != null) {
            out.writeBreakLinear();
            this.body.print(out);
        }
        out.endLogicalBlock(")");
    }

    @Override
    public Field compileSetField(Compilation comp) {
        return new ClassInitializer((ClassExp)this, (Compilation)comp).field;
    }

    public static String slotToMethodName(String prefix, String sname) {
        if (!Compilation.isValidJavaName(sname)) {
            sname = Compilation.mangleName(sname, false);
        }
        int slen = sname.length();
        StringBuffer sbuf = new StringBuffer(slen + 3);
        sbuf.append(prefix);
        if (slen > 0) {
            sbuf.append(Character.toTitleCase(sname.charAt(0)));
            sbuf.append(sname.substring(1));
        }
        return sbuf.toString();
    }

    public Declaration addMethod(LambdaExp lexp, Object mname) {
        Declaration mdecl = this.addDeclaration(mname, Compilation.typeProcedure);
        lexp.outer = this;
        lexp.setClassMethod(true);
        mdecl.noteValue(lexp);
        mdecl.setFlag(0x100000L);
        mdecl.setProcedureDecl(true);
        lexp.setSymbol(mname);
        return mdecl;
    }
}

