/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.AccessExp;
import gnu.expr.ApplyExp;
import gnu.expr.BindingInitializer;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IgnoreTarget;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.Literal;
import gnu.expr.ModuleExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.Target;
import gnu.expr.ThisExp;
import gnu.expr.TypeValue;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.Location;
import gnu.mapping.Named;
import gnu.mapping.Namespace;
import gnu.mapping.OutPort;
import gnu.mapping.Symbol;
import gnu.mapping.WrappedException;
import gnu.math.IntNum;
import gnu.text.Char;
import gnu.text.SourceLocator;
import java.lang.reflect.Field;

public class Declaration
implements SourceLocator {
    static int counter;
    protected int id = ++counter;
    Object symbol;
    public ScopeExp context;
    protected Type type;
    protected Expression typeExp;
    Declaration next;
    int evalIndex;
    Variable var;
    Declaration nextCapturedVar;
    public Declaration base;
    public gnu.bytecode.Field field;
    protected Expression value = QuoteExp.undefined_exp;
    static final String UNKNOWN_PREFIX = "loc$";
    public static final String PRIVATE_PREFIX = "$Prvt$";
    static final int INDIRECT_BINDING = 1;
    static final int CAN_READ = 2;
    static final int CAN_CALL = 4;
    static final int CAN_WRITE = 8;
    static final int IS_FLUID = 16;
    static final int PRIVATE = 32;
    static final int IS_SIMPLE = 64;
    static final int PROCEDURE = 128;
    public static final int IS_ALIAS = 256;
    public static final int NOT_DEFINING = 512;
    public static final int EXPORT_SPECIFIED = 1024;
    public static final int STATIC_SPECIFIED = 2048;
    public static final int NONSTATIC_SPECIFIED = 4096;
    public static final int TYPE_SPECIFIED = 8192;
    public static final int IS_CONSTANT = 16384;
    public static final int IS_SYNTAX = 32768;
    public static final int IS_UNKNOWN = 65536;
    public static final int IS_IMPORTED = 131072;
    public static final int IS_SINGLE_VALUE = 262144;
    public static final int EXTERNAL_ACCESS = 524288;
    public static final int FIELD_OR_METHOD = 0x100000;
    public static final int IS_NAMESPACE_PREFIX = 0x200000;
    public static final int PRIVATE_ACCESS = 0x1000000;
    public static final int PRIVATE_SPECIFIED = 0x1000000;
    public static final int PROTECTED_ACCESS = 0x2000000;
    public static final int PUBLIC_ACCESS = 0x4000000;
    public static final int PACKAGE_ACCESS = 0x8000000;
    public static final int IS_DYNAMIC = 0x10000000;
    public static final int EARLY_INIT = 0x20000000;
    public static final int MODULE_REFERENCE = 0x40000000;
    public static final long VOLATILE_ACCESS = 0x80000000L;
    public static final long TRANSIENT_ACCESS = 0x100000000L;
    public static final long ENUM_ACCESS = 0x200000000L;
    public static final long FINAL_ACCESS = 0x400000000L;
    public static final long CLASS_ACCESS_FLAGS = 0x603000000L;
    public static final long FIELD_ACCESS_FLAGS = 32463912960L;
    public static final long METHOD_ACCESS_FLAGS = 0x40F000000L;
    protected long flags = 64L;
    public ApplyExp firstCall;
    Method makeLocationMethod = null;
    String filename;
    int position;

    public void setCode(int code) {
        if (code >= 0) {
            throw new Error("code must be negative");
        }
        this.id = code;
    }

    public int getCode() {
        return this.id;
    }

    public final Expression getTypeExp() {
        if (this.typeExp == null) {
            this.setType(Type.objectType);
        }
        return this.typeExp;
    }

    public final Type getType() {
        if (this.type == null) {
            this.setType(Type.objectType);
        }
        return this.type;
    }

    public final void setType(Type type) {
        this.type = type;
        if (this.var != null) {
            this.var.setType(type);
        }
        this.typeExp = QuoteExp.getInstance(type);
    }

    public final void setTypeExp(Expression typeExp) {
        this.typeExp = typeExp;
        Type t = null;
        t = typeExp instanceof TypeValue ? ((TypeValue)((Object)typeExp)).getImplementationType() : Language.getDefaultLanguage().getTypeFor(typeExp, false);
        if (t == null) {
            t = Type.pointer_type;
        }
        this.type = t;
        if (this.var != null) {
            this.var.setType(t);
        }
    }

    public final String getName() {
        return this.symbol == null ? null : (this.symbol instanceof Symbol ? ((Symbol)this.symbol).getName() : this.symbol.toString());
    }

    public final void setName(Object symbol) {
        this.symbol = symbol;
    }

    public final Object getSymbol() {
        return this.symbol;
    }

    public final void setSymbol(Object symbol) {
        this.symbol = symbol;
    }

    public final Declaration nextDecl() {
        return this.next;
    }

    public final void setNext(Declaration next) {
        this.next = next;
    }

    public Variable getVariable() {
        return this.var;
    }

    public final boolean isSimple() {
        return (this.flags & 0x40L) != 0L;
    }

    public final void setSimple(boolean b) {
        this.setFlag(b, 64L);
        if (this.var != null && !this.var.isParameter()) {
            this.var.setSimple(b);
        }
    }

    public final void setSyntax() {
        this.setSimple(false);
        this.setFlag(0x2000C000L);
    }

    public final ScopeExp getContext() {
        return this.context;
    }

    void loadOwningObject(Declaration owner, Compilation comp) {
        if (owner == null) {
            owner = this.base;
        }
        if (owner != null) {
            owner.load(null, 0, comp, Target.pushObject);
        } else {
            this.getContext().currentLambda().loadHeapFrame(comp);
        }
    }

    public void load(AccessExp access, int flags, Compilation comp, Target target) {
        Declaration owner;
        if (target instanceof IgnoreTarget) {
            return;
        }
        Declaration declaration = owner = access == null ? null : access.contextDecl();
        if (this.isAlias() && this.value instanceof ReferenceExp) {
            ReferenceExp rexp = (ReferenceExp)this.value;
            Declaration orig = rexp.binding;
            if (!(orig == null || (flags & 2) != 0 && !orig.isIndirectBinding() || owner != null && orig.needsContext())) {
                orig.load(rexp, flags, comp, target);
                return;
            }
        }
        if (this.isFluid() && this.context instanceof FluidLetExp) {
            this.base.load(access, flags, comp, target);
            return;
        }
        CodeAttr code = comp.getCode();
        Type rtype = this.getType();
        if (!this.isIndirectBinding() && (flags & 2) != 0) {
            Method meth;
            ClassType ltype;
            if (this.field == null) {
                throw new Error("internal error: cannot take location of " + this);
            }
            boolean immediate = comp.immediate;
            if (this.field.getStaticFlag()) {
                ltype = ClassType.make("gnu.kawa.reflect.StaticFieldLocation");
                meth = ltype.getDeclaredMethod("make", immediate ? 1 : 2);
            } else {
                ltype = ClassType.make("gnu.kawa.reflect.FieldLocation");
                meth = ltype.getDeclaredMethod("make", immediate ? 2 : 3);
                this.loadOwningObject(owner, comp);
            }
            if (immediate) {
                comp.compileConstant(this);
            } else {
                comp.compileConstant(this.field.getDeclaringClass().getName());
                comp.compileConstant(this.field.getName());
            }
            code.emitInvokeStatic(meth);
            rtype = ltype;
        } else {
            if (this.field != null) {
                comp.usedClass(this.field.getDeclaringClass());
                comp.usedClass(this.field.getType());
                if (!this.field.getStaticFlag()) {
                    this.loadOwningObject(owner, comp);
                    code.emitGetField(this.field);
                } else {
                    code.emitGetStatic(this.field);
                }
            } else if (this.isIndirectBinding() && comp.immediate && this.getVariable() == null) {
                Environment env = Environment.getCurrent();
                Symbol sym = this.symbol instanceof Symbol ? (Symbol)this.symbol : env.getSymbol(this.symbol.toString());
                Object property = null;
                if (this.isProcedureDecl() && comp.getLanguage().hasSeparateFunctionNamespace()) {
                    property = EnvironmentKey.FUNCTION;
                }
                Location loc = env.getLocation(sym, property);
                comp.compileConstant(loc, Target.pushValue(Compilation.typeLocation));
            } else {
                ClassExp cl;
                Object val;
                if (comp.immediate && (val = this.getConstantValue()) != null) {
                    comp.compileConstant(val, target);
                    return;
                }
                if (!(this.value == QuoteExp.undefined_exp || !this.ignorable() || this.value instanceof LambdaExp && ((LambdaExp)this.value).outer instanceof ModuleExp)) {
                    this.value.compile(comp, target);
                    return;
                }
                Variable var = this.getVariable();
                if (this.context instanceof ClassExp && var == null && !this.getFlag(128L) && (cl = (ClassExp)this.context).isMakingClassPair()) {
                    String getName = ClassExp.slotToMethodName("get", this.getName());
                    Method getter = cl.type.getDeclaredMethod(getName, 0);
                    cl.loadHeapFrame(comp);
                    code.emitInvoke(getter);
                } else {
                    if (var == null) {
                        var = this.allocateVariable(code);
                    }
                    code.emitLoad(var);
                }
            }
            if (this.isIndirectBinding() && (flags & 2) == 0) {
                int line;
                String filename;
                if (access != null && (filename = access.getFileName()) != null && (line = access.getLineNumber()) > 0) {
                    ClassType typeUnboundLocationException = ClassType.make("gnu.mapping.UnboundLocationException");
                    boolean isInTry = code.isInTry();
                    int column = access.getColumnNumber();
                    Label startTry = new Label(code);
                    startTry.define(code);
                    code.emitInvokeVirtual(Compilation.getLocationMethod);
                    Label endTry = new Label(code);
                    endTry.define(code);
                    Label endLabel = new Label(code);
                    endLabel.setTypes(code);
                    if (isInTry) {
                        code.emitGoto(endLabel);
                    } else {
                        code.setUnreachable();
                    }
                    int fragment_cookie = 0;
                    if (!isInTry) {
                        fragment_cookie = code.beginFragment(endLabel);
                    }
                    code.addHandler(startTry, endTry, typeUnboundLocationException);
                    code.emitDup(typeUnboundLocationException);
                    code.emitPushString(filename);
                    code.emitPushInt(line);
                    code.emitPushInt(column);
                    code.emitInvokeVirtual(typeUnboundLocationException.getDeclaredMethod("setLine", 3));
                    code.emitThrow();
                    if (isInTry) {
                        endLabel.define(code);
                    } else {
                        code.endFragment(fragment_cookie);
                    }
                } else {
                    code.emitInvokeVirtual(Compilation.getLocationMethod);
                }
                rtype = Type.pointer_type;
            }
        }
        target.compileFromStack(comp, rtype);
    }

    public void compileStore(Compilation comp) {
        CodeAttr code = comp.getCode();
        if (this.isSimple()) {
            code.emitStore(this.getVariable());
        } else if (!this.field.getStaticFlag()) {
            this.loadOwningObject(null, comp);
            code.emitSwap();
            code.emitPutField(this.field);
        } else {
            code.emitPutStatic(this.field);
        }
    }

    public final Expression getValue() {
        if (this.value == QuoteExp.undefined_exp) {
            if (this.field != null && (this.field.getModifiers() & 0x18) == 24 && !this.isIndirectBinding()) {
                try {
                    this.value = new QuoteExp(this.field.getReflectField().get(null));
                }
                catch (Throwable ex) {}
            }
        } else if (this.value instanceof QuoteExp && this.getFlag(8192L) && this.value.getType() != this.type) {
            try {
                Object val = ((QuoteExp)this.value).getValue();
                Type t = this.getType();
                this.value = new QuoteExp(t.coerceFromObject(val), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.value;
    }

    public final void setValue(Expression value) {
        this.value = value;
    }

    public final Object getConstantValue() {
        Expression v = this.getValue();
        if (!(v instanceof QuoteExp) || v == QuoteExp.undefined_exp) {
            return null;
        }
        return ((QuoteExp)v).getValue();
    }

    public final boolean hasConstantValue() {
        Expression v = this.getValue();
        return v instanceof QuoteExp && v != QuoteExp.undefined_exp;
    }

    boolean shouldEarlyInit() {
        return this.getFlag(0x20000000L) || this.isCompiletimeConstant();
    }

    public boolean isCompiletimeConstant() {
        return this.getFlag(16384L) && this.hasConstantValue();
    }

    public final boolean needsExternalAccess() {
        return (this.flags & 0x80020L) == 524320L || (this.flags & 0x200020L) == 0x200020L;
    }

    public final boolean needsContext() {
        return this.base == null && this.field != null && !this.field.getStaticFlag();
    }

    public final boolean getFlag(long flag) {
        return (this.flags & flag) != 0L;
    }

    public final void setFlag(boolean setting, long flag) {
        this.flags = setting ? (this.flags |= flag) : (this.flags &= flag ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final void setFlag(long flag) {
        this.flags |= flag;
    }

    public final boolean isPublic() {
        return this.context instanceof ModuleExp && (this.flags & 0x20L) == 0L;
    }

    public final boolean isPrivate() {
        return (this.flags & 0x20L) != 0L;
    }

    public final void setPrivate(boolean isPrivate) {
        this.setFlag(isPrivate, 32L);
    }

    public short getAccessFlags(short defaultFlags) {
        short flags;
        if (this.getFlag(0xF000000L)) {
            flags = 0;
            if (this.getFlag(0x1000000L)) {
                flags = (short)(flags | 2);
            }
            if (this.getFlag(0x2000000L)) {
                flags = (short)(flags | 4);
            }
            if (this.getFlag(0x4000000L)) {
                flags = (short)(flags | 1);
            }
        } else {
            flags = defaultFlags;
        }
        if (this.getFlag(0x80000000L)) {
            flags = (short)(flags | 0x40);
        }
        if (this.getFlag(0x100000000L)) {
            flags = (short)(flags | 0x80);
        }
        if (this.getFlag(0x200000000L)) {
            flags = (short)(flags | 0x4000);
        }
        if (this.getFlag(0x400000000L)) {
            flags = (short)(flags | 0x10);
        }
        return flags;
    }

    public final boolean isAlias() {
        return (this.flags & 0x100L) != 0L;
    }

    public final void setAlias(boolean flag) {
        this.setFlag(flag, 256L);
    }

    public final boolean isFluid() {
        return (this.flags & 0x10L) != 0L;
    }

    public final void setFluid(boolean fluid) {
        this.setFlag(fluid, 16L);
    }

    public final boolean isProcedureDecl() {
        return (this.flags & 0x80L) != 0L;
    }

    public final void setProcedureDecl(boolean val) {
        this.setFlag(val, 128L);
    }

    public final boolean isNamespaceDecl() {
        return (this.flags & 0x200000L) != 0L;
    }

    public final boolean isIndirectBinding() {
        return (this.flags & 1L) != 0L;
    }

    public final void setIndirectBinding(boolean indirectBinding) {
        this.setFlag(indirectBinding, 1L);
    }

    public void maybeIndirectBinding(Compilation comp) {
        if (this.isLexical() && !(this.context instanceof ModuleExp) || this.context == comp.mainLambda) {
            this.setIndirectBinding(true);
        }
    }

    public final boolean getCanRead() {
        return (this.flags & 2L) != 0L;
    }

    public final void setCanRead(boolean read) {
        this.setFlag(read, 2L);
    }

    public final void setCanRead() {
        this.setFlag(true, 2L);
        if (this.base != null) {
            this.base.setCanRead();
        }
    }

    public final boolean getCanCall() {
        return (this.flags & 4L) != 0L;
    }

    public final void setCanCall(boolean called) {
        this.setFlag(called, 4L);
    }

    public final void setCanCall() {
        this.setFlag(true, 4L);
        if (this.base != null) {
            this.base.setCanRead();
        }
    }

    public final boolean getCanWrite() {
        return (this.flags & 8L) != 0L;
    }

    public final void setCanWrite(boolean written) {
        this.flags = written ? (this.flags |= 8L) : (this.flags &= 0xFFFFFFFFFFFFFFF7L);
    }

    public final void setCanWrite() {
        this.flags |= 8L;
        if (this.base != null) {
            this.base.setCanRead();
        }
    }

    public final boolean isThisParameter() {
        return this.symbol == ThisExp.THIS_NAME;
    }

    public boolean ignorable() {
        if (this.getCanRead() || this.isPublic()) {
            return false;
        }
        if (this.getCanWrite() && this.getFlag(65536L)) {
            return false;
        }
        if (!this.getCanCall()) {
            return true;
        }
        Expression value = this.getValue();
        if (value == null || !(value instanceof LambdaExp)) {
            return false;
        }
        LambdaExp lexp = (LambdaExp)value;
        return !lexp.isHandlingTailCalls() || lexp.getInlineOnly();
    }

    public boolean needsInit() {
        return !this.ignorable() && (this.value != QuoteExp.nullExp || this.base == null);
    }

    public boolean isStatic() {
        if (this.field != null) {
            return this.field.getStaticFlag();
        }
        if (this.getFlag(2048L) || this.isCompiletimeConstant()) {
            return true;
        }
        if (this.getFlag(4096L)) {
            return false;
        }
        LambdaExp lambda2 = this.context.currentLambda();
        return lambda2 instanceof ModuleExp && ((ModuleExp)lambda2).isStatic();
    }

    public final boolean isLexical() {
        return (this.flags & 0x10010010L) == 0L;
    }

    public static final boolean isUnknown(Declaration decl) {
        return decl == null || decl.getFlag(65536L);
    }

    public void noteValue(Expression value) {
        if (this.value == QuoteExp.undefined_exp) {
            if (value instanceof LambdaExp) {
                ((LambdaExp)value).nameDecl = this;
            }
            this.value = value;
        } else if (this.value != value) {
            if (this.value instanceof LambdaExp) {
                ((LambdaExp)this.value).nameDecl = null;
            }
            this.value = null;
        }
    }

    protected Declaration() {
    }

    public Declaration(Variable var) {
        this((Object)var.getName(), var.getType());
        this.var = var;
    }

    public Declaration(Object name) {
        this.setName(name);
    }

    public Declaration(Object name, Type type) {
        this.setName(name);
        this.setType(type);
    }

    public Declaration(Object name, gnu.bytecode.Field field) {
        this(name, field.getType());
        this.field = field;
        this.setSimple(false);
    }

    public void pushIndirectBinding(Compilation comp) {
        CodeAttr code = comp.getCode();
        code.emitPushString(this.getName());
        if (this.makeLocationMethod == null) {
            Type[] args = new Type[]{Type.pointer_type, Type.string_type};
            this.makeLocationMethod = Compilation.typeLocation.addMethod("make", args, Compilation.typeLocation, 9);
        }
        code.emitInvokeStatic(this.makeLocationMethod);
    }

    public final Variable allocateVariable(CodeAttr code) {
        if (!this.isSimple() || this.var == null) {
            String vname = null;
            if (this.symbol != null) {
                vname = Compilation.mangleNameIfNeeded(this.getName());
            }
            if (this.isAlias() && this.getValue() instanceof ReferenceExp) {
                Declaration base = Declaration.followAliases(this);
                this.var = base == null ? null : base.var;
            } else {
                ClassType type = this.isIndirectBinding() ? Compilation.typeLocation : this.getType().getImplementationType();
                this.var = this.context.getVarScope().addVariable(code, type, vname);
            }
        }
        return this.var;
    }

    public final void setLocation(SourceLocator location2) {
        this.filename = location2.getFileName();
        this.setLine(location2.getLineNumber(), location2.getColumnNumber());
    }

    public final void setFile(String filename) {
        this.filename = filename;
    }

    public final void setLine(int lineno, int colno) {
        if (lineno < 0) {
            lineno = 0;
        }
        if (colno < 0) {
            colno = 0;
        }
        this.position = (lineno << 12) + colno;
    }

    public final void setLine(int lineno) {
        this.setLine(lineno, 0);
    }

    @Override
    public final String getFileName() {
        return this.filename;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return this.filename;
    }

    @Override
    public final int getLineNumber() {
        int line = this.position >> 12;
        return line == 0 ? -1 : line;
    }

    @Override
    public final int getColumnNumber() {
        int column = this.position & 0xFFF;
        return column == 0 ? -1 : column;
    }

    @Override
    public boolean isStableSourceLocation() {
        return true;
    }

    public void printInfo(OutPort out) {
        StringBuffer sbuf = new StringBuffer();
        this.printInfo(sbuf);
        out.print(sbuf.toString());
    }

    public void printInfo(StringBuffer sbuf) {
        sbuf.append(this.symbol);
        sbuf.append('/');
        sbuf.append(this.id);
        sbuf.append("/fl:");
        sbuf.append(Long.toHexString(this.flags));
        if (this.ignorable()) {
            sbuf.append("(ignorable)");
        }
        Expression tx = this.typeExp;
        Type t = this.getType();
        if (tx != null && !(tx instanceof QuoteExp)) {
            sbuf.append("::");
            sbuf.append(tx);
        } else if (this.type != null && t != Type.pointer_type) {
            sbuf.append("::");
            sbuf.append(t.getName());
        }
        if (this.base != null) {
            sbuf.append("(base:#");
            sbuf.append(this.base.id);
            sbuf.append(')');
        }
    }

    public String toString() {
        return "Declaration[" + this.symbol + '/' + this.id + ']';
    }

    public static Declaration followAliases(Declaration decl) {
        Expression declValue;
        while (decl != null && decl.isAlias() && (declValue = decl.getValue()) instanceof ReferenceExp) {
            ReferenceExp rexp = (ReferenceExp)declValue;
            Declaration orig = rexp.binding;
            if (orig == null) break;
            decl = orig;
        }
        return decl;
    }

    public void makeField(Compilation comp, Expression value) {
        this.setSimple(false);
        this.makeField(comp.mainClass, comp, value);
    }

    public void makeField(ClassType frameType, Compilation comp, Expression value) {
        boolean external_access = this.needsExternalAccess();
        int fflags = 0;
        boolean isConstant = this.getFlag(16384L);
        boolean typeSpecified = this.getFlag(8192L);
        if (comp.immediate && this.context instanceof ModuleExp && !isConstant && !typeSpecified) {
            this.setIndirectBinding(true);
        }
        if (this.isPublic() || external_access || comp.immediate) {
            fflags |= 1;
        }
        if (this.isStatic() || this.getFlag(0x10010010L) && this.isIndirectBinding() && !this.isAlias() || value instanceof ClassExp && !((LambdaExp)value).getNeedsClosureEnv()) {
            fflags |= 8;
        }
        if ((this.isIndirectBinding() || isConstant && (this.shouldEarlyInit() || this.context instanceof ModuleExp && ((ModuleExp)this.context).staticInitRun())) && (this.context instanceof ClassExp || this.context instanceof ModuleExp)) {
            fflags |= 0x10;
        }
        Type ftype = this.getType().getImplementationType();
        if (this.isIndirectBinding() && !ftype.isSubtype(Compilation.typeLocation)) {
            ftype = Compilation.typeLocation;
        }
        if (!this.ignorable()) {
            int nlength;
            String fname = this.getName();
            if (fname == null) {
                fname = "$unnamed$0";
                nlength = fname.length() - 2;
            } else {
                fname = Compilation.mangleNameIfNeeded(fname);
                if (this.getFlag(65536L)) {
                    fname = UNKNOWN_PREFIX + fname;
                }
                if (external_access && !this.getFlag(0x40000000L)) {
                    fname = PRIVATE_PREFIX + fname;
                }
                nlength = fname.length();
            }
            int counter = 0;
            while (frameType.getDeclaredField(fname) != null) {
                fname = fname.substring(0, nlength) + '$' + ++counter;
            }
            this.field = frameType.addField(fname, ftype, fflags);
            if (value instanceof QuoteExp) {
                Object val = ((QuoteExp)value).getValue();
                if (this.field.getStaticFlag() && val.getClass().getName().equals(ftype.getName())) {
                    Literal literal = comp.litTable.findLiteral(val);
                    if (literal.field == null) {
                        literal.assign(this.field, comp.litTable);
                    }
                } else if (ftype instanceof PrimType || "java.lang.String".equals(ftype.getName())) {
                    if (val instanceof Char) {
                        val = IntNum.make(((Char)val).intValue());
                    }
                    this.field.setConstantValue(val, frameType);
                    return;
                }
            }
        }
        if (!this.shouldEarlyInit() && (this.isIndirectBinding() || value != null && !(value instanceof ClassExp))) {
            BindingInitializer.create(this, value, comp);
        }
    }

    Location makeIndirectLocationFor() {
        Symbol sym = this.symbol instanceof Symbol ? (Symbol)this.symbol : Namespace.EmptyNamespace.getSymbol(this.symbol.toString().intern());
        return Location.make(sym);
    }

    public static Declaration getDeclarationFromStatic(String cname, String fname) {
        ClassType clas = ClassType.make(cname);
        gnu.bytecode.Field fld = clas.getDeclaredField(fname);
        Declaration decl = new Declaration((Object)fname, fld);
        decl.setFlag(18432L);
        return decl;
    }

    public static Declaration getDeclarationValueFromStatic(String className, String fieldName, String name) {
        try {
            Class<?> cls = Class.forName(className);
            Field fld = cls.getDeclaredField(fieldName);
            Object value = fld.get(null);
            Declaration decl = new Declaration((Object)name, ClassType.make(className).getDeclaredField(fieldName));
            decl.noteValue(new QuoteExp(value));
            decl.setFlag(18432L);
            return decl;
        }
        catch (Exception ex) {
            throw new WrappedException(ex);
        }
    }

    public static Declaration getDeclaration(Named proc) {
        return Declaration.getDeclaration(proc, proc.getName());
    }

    public static Declaration getDeclaration(Object proc, String name) {
        int fflags;
        Class procClass;
        gnu.bytecode.Field procField = null;
        if (name != null && (procClass = PrimProcedure.getProcedureClass(proc)) != null) {
            ClassType procType = (ClassType)Type.make(procClass);
            String fname = Compilation.mangleNameIfNeeded(name);
            procField = procType.getDeclaredField(fname);
        }
        if (procField != null && ((fflags = procField.getModifiers()) & 8) != 0) {
            Declaration decl = new Declaration((Object)name, procField);
            decl.noteValue(new QuoteExp(proc));
            if ((fflags & 0x10) != 0) {
                decl.setFlag(16384L);
            }
            return decl;
        }
        return null;
    }
}

