/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.ConstantValueAttr;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.Location;
import gnu.bytecode.Member;
import gnu.bytecode.PrimType;
import gnu.bytecode.SignatureAttr;
import java.io.DataOutputStream;
import java.io.IOException;

public class Field
extends Location
implements AttrContainer,
Member {
    int flags;
    Field next;
    Attribute attributes;
    ClassType owner;
    String sourceName;
    java.lang.reflect.Field rfield;

    public final Attribute getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(Attribute attributes) {
        this.attributes = attributes;
    }

    public Field(ClassType ctype) {
        if (ctype.last_field == null) {
            ctype.fields = this;
        } else {
            ctype.last_field.next = this;
        }
        ctype.last_field = this;
        ++ctype.fields_count;
        this.owner = ctype;
    }

    public final ClassType getDeclaringClass() {
        return this.owner;
    }

    public final ConstantPool getConstants() {
        return this.owner.constants;
    }

    public final void setStaticFlag(boolean is_static) {
        this.flags = is_static ? (this.flags |= 8) : (this.flags ^= 0xFFFFFFF7);
    }

    public final boolean getStaticFlag() {
        return (this.flags & 8) != 0;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final int getModifiers() {
        return this.flags;
    }

    void write(DataOutputStream dstr, ClassType classfile) throws IOException {
        dstr.writeShort(this.flags);
        dstr.writeShort(this.name_index);
        dstr.writeShort(this.signature_index);
        Attribute.writeAll(this, dstr);
    }

    void assign_constants(ClassType classfile) {
        ConstantPool constants = classfile.constants;
        String signature = this.type.getSignature();
        String genericSignature = this.getType().getGenericSignature();
        if (genericSignature != null && !genericSignature.equals(signature)) {
            SignatureAttr attr = new SignatureAttr(genericSignature);
            attr.addToFrontOf(this);
        }
        if (this.name_index == 0 && this.name != null) {
            this.name_index = constants.addUtf8((String)this.name).index;
        }
        if (this.signature_index == 0 && this.type != null) {
            this.signature_index = constants.addUtf8((String)signature).index;
        }
        Attribute.assignConstants(this, classfile);
    }

    public synchronized java.lang.reflect.Field getReflectField() throws NoSuchFieldException {
        if (this.rfield == null) {
            this.rfield = this.owner.getReflectClass().getDeclaredField(this.getName());
        }
        return this.rfield;
    }

    public void setSourceName(String name) {
        this.sourceName = name;
    }

    public String getSourceName() {
        if (this.sourceName == null) {
            this.sourceName = this.getName().intern();
        }
        return this.sourceName;
    }

    public static Field searchField(Field fields, String name) {
        while (fields != null) {
            if (fields.getSourceName() == name) {
                return fields;
            }
            fields = fields.next;
        }
        return null;
    }

    public final Field getNext() {
        return this.next;
    }

    public final void setConstantValue(Object value, ClassType ctype) {
        CpoolEntry entry;
        ConstantPool cpool = ctype.constants;
        if (cpool == null) {
            ctype.constants = cpool = new ConstantPool();
        }
        char sig1 = this.type.getSignature().charAt(0);
        switch (sig1) {
            case 'Z': {
                entry = cpool.addInt(PrimType.booleanValue(value) ? 1 : 0);
                break;
            }
            case 'C': {
                if (value instanceof Character) {
                    entry = cpool.addInt(((Character)value).charValue());
                    break;
                }
            }
            case 'B': 
            case 'I': 
            case 'S': {
                entry = cpool.addInt(((Number)value).intValue());
                break;
            }
            case 'J': {
                entry = cpool.addLong(((Number)value).longValue());
                break;
            }
            case 'F': {
                entry = cpool.addFloat(((Number)value).floatValue());
                break;
            }
            case 'D': {
                entry = cpool.addDouble(((Number)value).doubleValue());
                break;
            }
            default: {
                entry = cpool.addString(value.toString());
            }
        }
        ConstantValueAttr attr = new ConstantValueAttr(entry.getIndex());
        attr.addToFrontOf(this);
    }

    public boolean hasConstantValueAttr() {
        return Attribute.get(this, "ConstantValue") != null;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(100);
        sbuf.append("Field:");
        sbuf.append(this.getDeclaringClass().getName());
        sbuf.append('.');
        sbuf.append(this.name);
        return sbuf.toString();
    }
}

