/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.SwitchState;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import java.util.Stack;

public class ApplyExp
extends Expression {
    Expression func;
    Expression[] args;
    boolean tailCall;
    LambdaExp context;
    public ApplyExp nextCall;

    public final Expression getFunction() {
        return this.func;
    }

    public final Expression[] getArgs() {
        return this.args;
    }

    public final int getArgCount() {
        return this.args.length;
    }

    public void setFunction(Expression expression) {
        this.func = expression;
    }

    public void setArgs(Expression[] expressionArray) {
        this.args = expressionArray;
    }

    public final boolean isTailCall() {
        return this.tailCall;
    }

    public final void setTailCall(boolean bl) {
        this.tailCall = bl;
    }

    public ApplyExp(Expression expression, Expression[] expressionArray) {
        this.func = expression;
        this.args = expressionArray;
    }

    public ApplyExp(Procedure procedure, Expression[] expressionArray) {
        this.func = new QuoteExp(procedure);
        this.args = expressionArray;
    }

    public ApplyExp(Method method, Expression[] expressionArray) {
        this.func = new QuoteExp(new PrimProcedure(method));
        this.args = expressionArray;
    }

    public Object eval(Environment environment) throws Throwable {
        Procedure procedure = (Procedure)this.func.eval(environment);
        int n = this.args.length;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = this.args[n2].eval(environment);
            ++n2;
        }
        return procedure.applyN(objectArray);
    }

    public void eval(Environment environment, CallContext callContext) throws Throwable {
        Procedure procedure = (Procedure)this.func.eval(environment);
        int n = this.args.length;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = this.args[n2].eval(environment);
            ++n2;
        }
        if (procedure == null) {
            throw new NullPointerException();
        }
        callContext.setArgsN(objectArray);
        callContext.proc = procedure;
    }

    public static void compileToArray(Expression[] expressionArray, Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (expressionArray.length == 0) {
            codeAttr.emitGetStatic(Compilation.noArgsField);
            return;
        }
        LambdaExp lambdaExp = compilation.curLambda;
        codeAttr.emitPushInt(expressionArray.length);
        codeAttr.emitNewArray(Type.pointer_type);
        int n = 0;
        while (n < expressionArray.length) {
            Expression expression = expressionArray[n];
            if (Compilation.usingCPStyle && !(expression instanceof QuoteExp) && !(expression instanceof ReferenceExp)) {
                expression.compile(compilation, Target.pushObject);
                codeAttr.emitSwap();
                codeAttr.emitDup(1, 1);
                codeAttr.emitSwap();
                codeAttr.emitPushInt(n);
                codeAttr.emitSwap();
            } else {
                codeAttr.emitDup(Compilation.objArrayType);
                codeAttr.emitPushInt(n);
                expression.compile(compilation, Target.pushObject);
            }
            codeAttr.emitArrayStore(Type.pointer_type);
            ++n;
        }
    }

    public void compile(Compilation compilation, Target target) {
        ApplyExp.compile(this, compilation, target, true);
    }

    public static void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        ApplyExp.compile(applyExp, compilation, target, false);
    }

    static void compile(ApplyExp applyExp, Compilation compilation, Target target, boolean bl) {
        boolean bl2;
        boolean bl3;
        Object object2;
        Object object3;
        Object object4;
        int n = applyExp.args.length;
        Expression expression = applyExp.func;
        LambdaExp lambdaExp = null;
        String string = null;
        if (expression instanceof LambdaExp) {
            lambdaExp = (LambdaExp)expression;
            string = lambdaExp.getName();
            if (string == null) {
                string = "<lambda>";
            }
        } else if (expression instanceof ReferenceExp) {
            object4 = ((ReferenceExp)expression).binding;
            if (!((Declaration)object4).getFlag(65536) && !((Declaration)object4).getFlag(1)) {
                object3 = ((Declaration)object4).getValue();
                string = ((Declaration)object4).getName();
                if (object3 != null && object3 instanceof LambdaExp) {
                    lambdaExp = (LambdaExp)object3;
                }
                if (object3 != null && object3 instanceof QuoteExp) {
                    object2 = ((QuoteExp)object3).getValue();
                    if (bl && object2 instanceof Inlineable) {
                        ((Inlineable)object2).compile(applyExp, compilation, target);
                        return;
                    }
                }
            }
        } else if (expression instanceof QuoteExp && (object4 = ((QuoteExp)expression).getValue()) instanceof Inlineable && bl) {
            ((Inlineable)object4).compile(applyExp, compilation, target);
            return;
        }
        object4 = compilation.getCode();
        if (lambdaExp != null) {
            object2 = null;
            if (n < lambdaExp.min_args) {
                object2 = "too few args for ";
            } else if (lambdaExp.max_args >= 0 && n > lambdaExp.max_args) {
                object2 = "too many args " + n + " for ";
            } else if (!lambdaExp.isHandlingTailCalls() && compilation.inlineOk(lambdaExp) && (object3 = lambdaExp.getMethod(n)) != null) {
                boolean bl4 = ((Method)object3).getStaticFlag();
                Expression[] expressionArray = applyExp.getArgs();
                int n2 = 0;
                Type[] typeArray = ((Method)object3).getParameterTypes();
                if (!bl4 || lambdaExp.declareClosureEnv() != null) {
                    if (bl4) {
                        n2 = 1;
                    }
                    if (compilation.curLambda == lambdaExp) {
                        ((CodeAttr)object4).emitLoad(lambdaExp.closureEnv);
                    } else {
                        lambdaExp.getOwningLambda().loadHeapFrame(compilation);
                    }
                }
                boolean bl5 = lambdaExp.restArgType() != null;
                PrimProcedure.compileArgs(expressionArray, n2 > 0 ? Type.void_type : null, typeArray, bl5, string, lambdaExp, compilation);
                ((CodeAttr)object4).emitInvoke((Method)object3);
                target.compileFromStack(compilation, lambdaExp.getReturnType());
                return;
            }
            if (object2 != null) {
                compilation.error('w', (String)object2 + string);
                lambdaExp = null;
            }
        }
        if (Compilation.usingCPStyle()) {
            Field field;
            int n3;
            object2 = new Label((CodeAttr)object4);
            SwitchState switchState = compilation.fswitch;
            int n4 = switchState.getMaxValue() + 1;
            switchState.addCase(n4, (Label)object2, (CodeAttr)object4);
            expression.compile(compilation, new StackTarget(Compilation.typeProcedure));
            compilation.loadCallContext();
            compilation.loadCallContext();
            ((CodeAttr)object4).emitPushInt(n4);
            ((CodeAttr)object4).emitPutField(Compilation.pcCallContextField);
            ((CodeAttr)object4).emitInvokeVirtual(Compilation.applyCpsMethod);
            Type[] typeArray = ((CodeAttr)object4).saveStackTypeState(false);
            Stack<Field> stack = new Stack<Field>();
            if (typeArray != null) {
                n3 = typeArray.length;
                while (--n3 >= 0) {
                    field = compilation.allocLocalField(typeArray[n3], null);
                    ((CodeAttr)object4).emitPushThis();
                    ((CodeAttr)object4).emitSwap();
                    ((CodeAttr)object4).emitPutField(field);
                    stack.push(field);
                }
            }
            ((CodeAttr)object4).emitReturn();
            ((Label)object2).define((CodeAttr)object4);
            if (typeArray != null) {
                n3 = typeArray.length;
                while (--n3 >= 0) {
                    field = (Field)stack.pop();
                    ((CodeAttr)object4).emitPushThis();
                    ((CodeAttr)object4).emitGetField(field);
                    compilation.freeLocalField(field);
                }
            }
            return;
        }
        boolean bl6 = bl3 = applyExp.tailCall && lambdaExp != null && lambdaExp == compilation.curLambda;
        if (lambdaExp != null && lambdaExp.getInlineOnly() && !bl3 && lambdaExp.min_args == n) {
            Declaration declaration = lambdaExp.firstDecl();
            int n5 = 0;
            while (n5 < n) {
                applyExp.args[n5].compile(compilation, declaration.getType());
                declaration = declaration.nextDecl();
                ++n5;
            }
            LambdaExp lambdaExp2 = compilation.curLambda;
            compilation.curLambda = lambdaExp;
            lambdaExp.allocChildClasses(compilation);
            lambdaExp.allocParameters(compilation);
            ApplyExp.popParams((CodeAttr)object4, lambdaExp, false);
            lambdaExp.enterFunction(compilation);
            lambdaExp.body.compileWithPosition(compilation, target);
            lambdaExp.compileEnd(compilation);
            lambdaExp.compileChildMethods(compilation);
            compilation.curLambda = lambdaExp2;
            return;
        }
        if (compilation.curLambda.isHandlingTailCalls() && (applyExp.isTailCall() || target instanceof ConsumerTarget) && !compilation.curLambda.getInlineOnly()) {
            ClassType classType = Compilation.typeCallContext;
            expression.compile(compilation, new StackTarget(Compilation.typeProcedure));
            compilation.loadCallContext();
            ((CodeAttr)object4).emitDupX();
            if (!applyExp.isTailCall()) {
                ((CodeAttr)object4).emitDupX();
            }
            if (n <= 4) {
                int n6 = 0;
                while (n6 < n) {
                    applyExp.args[n6].compile(compilation, Target.pushObject);
                    ++n6;
                }
                ((CodeAttr)object4).emitInvoke(classType.getDeclaredMethod("setArgs", n));
            } else {
                ApplyExp.compileToArray(applyExp.args, compilation);
                ((CodeAttr)object4).emitInvoke(classType.getDeclaredMethod("setArgsN", 1));
            }
            ((CodeAttr)object4).emitPutField(Compilation.procCallContextField);
            if (applyExp.isTailCall()) {
                ((CodeAttr)object4).emitReturn();
            } else {
                ((CodeAttr)object4).emitLoad(((ConsumerTarget)target).getConsumerVariable());
                ((CodeAttr)object4).emitInvoke(classType.getDeclaredMethod("runUntilValue", 1));
            }
            return;
        }
        if (!bl3) {
            expression.compile(compilation, new StackTarget(Compilation.typeProcedure));
        }
        boolean bl7 = bl3 ? lambdaExp.min_args != lambdaExp.max_args : (bl2 = n > 4);
        if (bl2) {
            ApplyExp.compileToArray(applyExp.args, compilation);
            object3 = Compilation.applyNmethod;
        } else if (bl3) {
            Declaration declaration = lambdaExp.firstDecl();
            int n7 = 0;
            while (n7 < n) {
                applyExp.args[n7].compile(compilation, declaration.getType());
                declaration = declaration.nextDecl();
                ++n7;
            }
            object3 = null;
        } else {
            int n8 = 0;
            while (n8 < n) {
                applyExp.args[n8].compile(compilation, Target.pushObject);
                ++n8;
            }
            object3 = Compilation.applymethods[n];
        }
        if (bl3) {
            ApplyExp.popParams((CodeAttr)object4, lambdaExp, bl2);
            ((CodeAttr)object4).emitTailCall(false, lambdaExp.scope);
            return;
        }
        ((CodeAttr)object4).emitInvokeVirtual((Method)object3);
        target.compileFromStack(compilation, Type.pointer_type);
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkApplyExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.func = expWalker.walk(this.func);
        if (expWalker.exitValue == null) {
            this.args = expWalker.walkExps(this.args, this.args.length);
        }
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Apply", ")", 2);
        if (this.tailCall) {
            outPort.print(" [tailcall]");
        }
        outPort.writeSpaceFill();
        this.printLineColumn(outPort);
        this.func.print(outPort);
        int n = 0;
        while (n < this.args.length) {
            outPort.writeSpaceLinear();
            this.args[n].print(outPort);
            ++n;
        }
        outPort.endLogicalBlock(")");
    }

    private static void popParams(CodeAttr codeAttr, LambdaExp lambdaExp, boolean bl) {
        Variable variable = lambdaExp.scope.firstVar();
        if (variable != null && variable.getName() == "this") {
            variable = variable.nextVar();
        }
        if (variable != null && variable.getName() == "$ctx") {
            variable = variable.nextVar();
        }
        if (variable != null && variable.getName() == "argsArray") {
            if (bl) {
                ApplyExp.popParams(codeAttr, variable, 1);
                return;
            }
            variable = variable.nextVar();
        }
        ApplyExp.popParams(codeAttr, variable, lambdaExp.min_args);
    }

    private static void popParams(CodeAttr codeAttr, Variable variable, int n) {
        if (n > 0) {
            ApplyExp.popParams(codeAttr, variable.nextVar(), n - 1);
            codeAttr.emitStore(variable);
        }
    }

    public final Type getType() {
        Object object2;
        Expression expression = this.func;
        if (expression instanceof ReferenceExp && (object2 = ((ReferenceExp)expression).binding) != null && !((Declaration)object2).getFlag(65536)) {
            expression = ((Declaration)object2).getValue();
        }
        if (expression instanceof QuoteExp && (object2 = ((QuoteExp)expression).getValue()) instanceof Inlineable) {
            return ((Inlineable)object2).getReturnType(this.args);
        }
        if (expression instanceof LambdaExp) {
            return ((LambdaExp)expression).getReturnType();
        }
        return super.getType();
    }

    public static Expression inlineIfConstant(Procedure procedure, ApplyExp applyExp) {
        int n;
        int n2 = n = applyExp.args.length;
        while (--n2 >= 0) {
            if (applyExp.args[n2] instanceof QuoteExp) continue;
            return applyExp;
        }
        Object[] objectArray = new Object[n];
        int n3 = n;
        while (--n3 >= 0) {
            objectArray[n3] = ((QuoteExp)applyExp.args[n3]).getValue();
        }
        try {
            return new QuoteExp(procedure.applyN(objectArray));
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

