/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.Signal;
import gnu.lists.SeqPosition;
import gnu.mapping.InPort;
import gnu.mapping.WrappedException;
import java.io.IOException;

public final class Marker
extends SeqPosition {
    Buffer buffer;

    public final boolean isPoint() {
        return this.buffer != null && this.sequence == null;
    }

    public Marker() {
    }

    public Marker(Marker marker) {
        this.buffer = marker.buffer;
        if (this.buffer != null) {
            if (marker.isPoint()) {
                this.set(this.buffer, this.buffer.getDot(), true);
            } else {
                this.set(marker);
            }
        }
    }

    public Marker(Buffer buffer, int n, boolean bl) {
        super(buffer, n, bl);
        this.buffer = buffer;
    }

    public int getOffset() {
        if (this.buffer == null) {
            return -1;
        }
        if (this.isPoint()) {
            return this.buffer.getDot();
        }
        return this.nextIndex();
    }

    public int getPoint() {
        return 1 + this.getOffset();
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setDot(int n) {
        this.set(this.buffer, n);
    }

    public void set(Buffer buffer, int n) {
        if (this.isPoint()) {
            if (buffer != this.buffer) {
                String string = buffer == null ? "Can't make point-marker point nowhere: " : "Can't change buffer of point-marker: ";
                throw new Error(string + this);
            }
            this.buffer.setDot(n);
        } else {
            if (this.sequence != null) {
                this.release();
            }
            this.sequence = null;
            if (buffer == null) {
                this.buffer = null;
                return;
            }
            if (n < 0) {
                n = 0;
            } else {
                int n2 = buffer.length();
                if (n > n2) {
                    n = n2;
                }
            }
            this.set(buffer, n, false);
        }
    }

    public void removeChar(int n) {
        if (this.isPoint()) {
            this.buffer.removeChar(n);
        } else {
            this.buffer.removePos(this.ipos, n);
        }
    }

    public void insert(char[] cArray, int n, int n2, Object object2) {
        int n3 = this.getOffset();
        this.buffer.insert(cArray, n, n2, object2, this.ipos);
        this.setDot(n3 += n2);
    }

    public void insert(String string, Object object2) {
        int n = this.getOffset();
        if (this.isPoint()) {
            this.buffer.insert(string, object2);
        } else {
            this.buffer.insert(string, object2, this.ipos);
        }
        this.setDot(n += string.length());
    }

    public void insert(char c, int n, Object object2) {
        if (n < 0) {
            return;
        }
        int n2 = n > 500 ? 500 : n;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = n2;
        while (--n3 >= 0) {
            stringBuffer.append(c);
        }
        String string = stringBuffer.toString();
        while (true) {
            this.insert(string, object2);
            if ((n -= n2) == 0) break;
            if (n >= 500) continue;
            n2 = n;
            stringBuffer.setLength(n2);
            string = stringBuffer.toString();
        }
    }

    public void forwardChar(int n) {
        int n2;
        int n3 = this.getOffset();
        if (n3 + n > (n2 = this.buffer.maxDot())) {
            n3 = n2;
            Signal.signal("End of buffer");
        }
        this.setDot(n3 += n);
    }

    public void backwardChar(int n) {
        int n2 = this.getOffset();
        if (n2 < n) {
            n2 = 0;
            Signal.signal("Beginning of buffer");
        }
        this.setDot(n2 -= n);
    }

    public int currentColumn() {
        return this.buffer.currentColumn(this.getOffset());
    }

    public int moveToColumn(int n, boolean bl) {
        int n2 = this.buffer.lineStartOffset(this.getOffset());
        InPort inPort = this.buffer.openReader(n2, this.buffer.maxDot() - n2);
        int n3 = 0;
        try {
            int n4;
            block6: {
                int n5;
                n4 = n2;
                do {
                    int n6;
                    if ((n6 = inPort.read()) < 0 || n6 == 10) {
                        if (bl) {
                            // empty if block
                        }
                        break block6;
                    }
                    n5 = this.buffer.charWidth((char)n6, n3);
                    ++n4;
                } while ((n3 += n5) < n);
                if (n3 <= n || bl) {
                    // empty if block
                }
            }
            this.setDot(n4);
            return n3;
        }
        catch (IOException iOException) {
            throw new WrappedException(iOException);
        }
    }

    public int forwardLine(int n) {
        long l = this.buffer.forwardLine(n, this.getOffset());
        this.setDot((int)l);
        return (int)(l >> 32);
    }

    public boolean isBeginningOfLine() {
        int n = this.getOffset();
        return n == 0 || this.buffer.charAt(n - 1) == '\n';
    }

    public boolean isEndOfLine() {
        int n = this.getOffset();
        return n == this.buffer.length() || this.buffer.charAt(n) == '\n';
    }

    public int hashCode() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.hashCode() ^ this.getOffset();
    }

    public boolean equals(Object object2) {
        if (!(object2 instanceof Marker)) {
            return false;
        }
        Marker marker = (Marker)object2;
        return this.buffer == marker.buffer && this.getOffset() == marker.getOffset();
    }

    public String toString() {
        if (this.buffer == null) {
            return "#<marker in no buffer>";
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("#<marker at ");
        stringBuffer.append(this.getPoint());
        stringBuffer.append(" in ");
        stringBuffer.append(this.buffer.getName());
        stringBuffer.append('>');
        return stringBuffer.toString();
    }
}

