/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class RomanIntegerFormat
extends NumberFormat {
    private static RomanIntegerFormat newRoman;
    private static RomanIntegerFormat oldRoman;
    public boolean oldStyle;
    static final String codes = "IVXLCDM";

    public RomanIntegerFormat(boolean bl) {
        this.oldStyle = bl;
    }

    public RomanIntegerFormat() {
    }

    public static RomanIntegerFormat getInstance(boolean bl) {
        if (bl) {
            if (oldRoman == null) {
                oldRoman = new RomanIntegerFormat(true);
            }
            return oldRoman;
        }
        if (newRoman == null) {
            newRoman = new RomanIntegerFormat(false);
        }
        return newRoman;
    }

    public static String format(int n, boolean bl) {
        if (n <= 0 || n >= 4999) {
            return Integer.toString(n);
        }
        StringBuffer stringBuffer = new StringBuffer(20);
        int n2 = 1000;
        for (int i = 3; i >= 0; --i) {
            int n3 = n / n2;
            n -= n3 * n2;
            if (n3 != 0) {
                if (!(bl || n3 != 4 && n3 != 9)) {
                    stringBuffer.append(codes.charAt(2 * i));
                    stringBuffer.append(codes.charAt(2 * i + (n3 + 1) / 5));
                } else {
                    int n4 = n3;
                    if (n4 >= 5) {
                        stringBuffer.append(codes.charAt(2 * i + 1));
                        n4 -= 5;
                    }
                    while (--n4 >= 0) {
                        stringBuffer.append(codes.charAt(2 * i));
                    }
                }
            }
            n2 /= 10;
        }
        return stringBuffer.toString();
    }

    public static String format(int n) {
        return RomanIntegerFormat.format(n, false);
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        String string = l > 0L && l < (long)(this.oldStyle ? 4999 : 3999) ? RomanIntegerFormat.format((int)l, this.oldStyle) : Long.toString(l);
        if (fieldPosition != null) {
            int n;
            long l2 = 1L;
            int n2 = n = string.length();
            while (--n2 > 0) {
                l2 = 10L * l2 + 9L;
            }
            StringBuffer stringBuffer2 = new StringBuffer(n);
            new DecimalFormat("0").format(l2, stringBuffer2, fieldPosition);
        }
        stringBuffer.append(string);
        return stringBuffer;
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        long l = (long)d;
        if ((double)l == d) {
            return this.format(l, stringBuffer, fieldPosition);
        }
        stringBuffer.append(Double.toString(d));
        return stringBuffer;
    }

    public Number parse(String string, ParsePosition parsePosition) {
        throw new Error("RomanIntegerFormat.parseObject - not implemented");
    }
}

