/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.AccessExp;
import gnu.expr.ApplyExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.LangExp;
import gnu.expr.Language;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.Special;
import gnu.kawa.functions.AppendValues;
import gnu.kawa.lispexpr.LispLanguage;
import gnu.kawa.reflect.ClassMethodProc;
import gnu.kawa.reflect.FieldLocation;
import gnu.lists.FString;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.PairWithPosition;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.Location;
import gnu.mapping.Named;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.text.SourceMessages;
import java.io.Externalizable;
import java.util.Stack;
import java.util.Vector;
import kawa.lang.AutoloadProcedure;
import kawa.lang.Macro;
import kawa.lang.PatternScope;
import kawa.lang.Quote;
import kawa.lang.Syntax;
import kawa.lang.SyntaxForm;
import kawa.lang.TemplateScope;

public class Translator
extends Compilation {
    private Environment env;
    public Macro currentMacroDefinition;
    public PatternScope patternScope;
    public Declaration matchArray;
    Stack renamedAliasStack;
    public Stack formStack = new Stack();
    private static Expression errorExp = new ErrorExp("unknown syntax error");
    Syntax currentSyntax;
    Declaration macroContext;
    PairWithPosition positionPair;
    Vector notedAccess;

    public boolean isLexical(Declaration declaration) {
        if (declaration == null) {
            return false;
        }
        if (!declaration.isFluid()) {
            return true;
        }
        ScopeExp scopeExp = this.currentScope();
        ScopeExp scopeExp2 = declaration.getContext();
        while (scopeExp != null) {
            if (scopeExp == scopeExp2) {
                return true;
            }
            if (scopeExp instanceof LambdaExp && !((LambdaExp)scopeExp).getInlineOnly()) {
                return false;
            }
            scopeExp = scopeExp.outer;
        }
        return false;
    }

    public Translator(Language language, SourceMessages sourceMessages) {
        super(language, sourceMessages);
        this.env = Environment.getCurrent();
    }

    public final Environment getGlobalEnvironment() {
        return this.env;
    }

    public Expression parse(Object object2) {
        return this.rewrite(object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression rewrite_car(Pair pair, SyntaxForm syntaxForm) {
        if (syntaxForm == null || syntaxForm.scope == this.current_scope || pair.car instanceof SyntaxForm) {
            return this.rewrite_car(pair, false);
        }
        ScopeExp scopeExp = this.current_scope;
        try {
            this.setCurrentScope(syntaxForm.scope);
            Expression expression = this.rewrite_car(pair, false);
            return expression;
        }
        finally {
            this.setCurrentScope(scopeExp);
        }
    }

    public final Expression rewrite_car(Pair pair, boolean bl) {
        Object object2 = pair.car;
        if (pair instanceof PairWithPosition) {
            return this.rewrite_with_position(object2, bl, (PairWithPosition)pair);
        }
        return this.rewrite(object2, bl);
    }

    public Syntax getCurrentSyntax() {
        return this.currentSyntax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Expression apply_rewrite(Syntax syntax2, Pair pair) {
        Expression expression = errorExp;
        Syntax syntax3 = this.currentSyntax;
        this.currentSyntax = syntax2;
        try {
            expression = syntax2.rewriteForm(pair, this);
        }
        finally {
            this.currentSyntax = syntax3;
        }
        return expression;
    }

    static ReferenceExp getOriginalRef(Declaration declaration) {
        Expression expression;
        if (declaration != null && declaration.isAlias() && !declaration.isIndirectBinding() && (expression = declaration.getValue()) instanceof ReferenceExp) {
            return (ReferenceExp)expression;
        }
        return null;
    }

    final boolean selfEvaluatingSymbol(Object object2) {
        return ((LispLanguage)this.getLanguage()).selfEvaluatingSymbol(object2);
    }

    public boolean matches(Object object2, String string) {
        ReferenceExp referenceExp;
        if (object2 instanceof SyntaxForm) {
            return string == ((SyntaxForm)object2).form;
        }
        if (object2 instanceof Symbol && !this.selfEvaluatingSymbol(object2) && (referenceExp = Translator.getOriginalRef(this.lexical.lookup(object2, -1))) != null) {
            object2 = referenceExp.getSymbol();
        }
        return object2 == string;
    }

    public Declaration lookup(Object object2, int n) {
        Declaration declaration = this.lexical.lookup(object2, n);
        if (declaration != null && (this.getLanguage().getNamespaceOf(declaration) & n) != 0) {
            return declaration;
        }
        return this.lookupGlobal(object2, n);
    }

    public Declaration lookupGlobal(Object object2) {
        return this.lookupGlobal(object2, -1);
    }

    public Declaration lookupGlobal(Object object2, int n) {
        ModuleExp moduleExp = this.currentModule();
        Declaration declaration = moduleExp.lookup(object2, this.getLanguage(), n);
        if (declaration == null) {
            declaration = moduleExp.getNoDefine(object2);
            declaration.setIndirectBinding(true);
        }
        return declaration;
    }

    Syntax check_if_Syntax(Declaration declaration) {
        Declaration declaration2 = Declaration.followAliases(declaration);
        Expression expression = declaration2.getValue();
        if (expression != null && declaration2.getFlag(32768)) {
            try {
                Object object2;
                if (declaration.getValue() instanceof ReferenceExp && (object2 = ((ReferenceExp)declaration.getValue()).contextDecl()) != null) {
                    this.macroContext = object2;
                }
                return (object2 = expression.eval(this.env)) instanceof Syntax ? (Syntax)object2 : null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.error('e', "unable to evaluate macro for " + declaration.getSymbol());
            }
        }
        return null;
    }

    public Expression rewrite_pair(Pair pair) {
        int n;
        Object object2;
        Expression[] expressionArray;
        if (pair.car instanceof Syntax) {
            return this.apply_rewrite((Syntax)pair.car, pair);
        }
        Object object3 = pair.cdr;
        Expression expression = this.rewrite_car(pair, true);
        Object object4 = null;
        ReferenceExp referenceExp = null;
        if (expression instanceof ReferenceExp) {
            referenceExp = (ReferenceExp)expression;
            Declaration declaration = referenceExp.getBinding();
            if (declaration == null) {
                String string;
                expressionArray = referenceExp.getSymbol();
                if (expressionArray instanceof Symbol && !this.selfEvaluatingSymbol(expressionArray)) {
                    object2 = (Symbol)expressionArray;
                    string = ((Symbol)object2).getName();
                } else {
                    string = expressionArray.toString();
                    object2 = this.env.getSymbol(string);
                }
                object4 = this.env.get((Symbol)object2, this.getLanguage().hasSeparateFunctionNamespace() ? EnvironmentKey.FUNCTION : null, null);
                if (object4 instanceof Syntax) {
                    return this.apply_rewrite((Syntax)object4, pair);
                }
                if (object4 instanceof AutoloadProcedure) {
                    try {
                        object4 = ((AutoloadProcedure)object4).getLoaded();
                    }
                    catch (RuntimeException runtimeException) {
                        object4 = null;
                    }
                }
            } else {
                expressionArray = this.macroContext;
                object2 = this.check_if_Syntax(declaration);
                if (object2 != null) {
                    Expression expression2 = this.apply_rewrite((Syntax)object2, pair);
                    this.macroContext = expressionArray;
                    return expression2;
                }
            }
            referenceExp.setProcedureName(true);
            if (this.getLanguage().hasSeparateFunctionNamespace()) {
                expression.setFlag(4);
            }
        }
        if ((n = Translator.listLength(object3)) == -1) {
            return this.syntaxError("circular list is not allowed after " + pair.car);
        }
        if (n < 0) {
            return this.syntaxError("dotted list [" + object3 + "] is not allowed after " + pair.car);
        }
        expressionArray = new Expression[n];
        object2 = this.current_scope;
        for (int i = 0; i < n; ++i) {
            Externalizable externalizable;
            if (object3 instanceof SyntaxForm) {
                externalizable = (SyntaxForm)object3;
                object3 = externalizable.form;
                this.setCurrentScope(externalizable.scope);
            }
            externalizable = (Pair)object3;
            expressionArray[i] = this.rewrite_car((Pair)externalizable, false);
            object3 = ((Pair)externalizable).cdr;
        }
        if (object2 != this.current_scope) {
            this.setCurrentScope((ScopeExp)object2);
        }
        return ((LispLanguage)this.getLanguage()).makeApply(expression, expressionArray);
    }

    public static Object stripSyntax(Object object2) {
        while (object2 instanceof SyntaxForm) {
            object2 = ((SyntaxForm)object2).form;
        }
        return object2;
    }

    public static Object safeCar(Object object2) {
        while (object2 instanceof SyntaxForm) {
            object2 = ((SyntaxForm)object2).form;
        }
        if (!(object2 instanceof Pair)) {
            return null;
        }
        return Translator.stripSyntax(((Pair)object2).car);
    }

    public static Object safeCdr(Object object2) {
        while (object2 instanceof SyntaxForm) {
            object2 = ((SyntaxForm)object2).form;
        }
        if (!(object2 instanceof Pair)) {
            return null;
        }
        return Translator.stripSyntax(((Pair)object2).cdr);
    }

    public static int listLength(Object object2) {
        int n = 0;
        Object object3 = object2;
        Object object4 = object2;
        while (true) {
            if (object4 instanceof SyntaxForm) {
                object4 = ((SyntaxForm)object4).form;
                continue;
            }
            while (object3 instanceof SyntaxForm) {
                object3 = ((SyntaxForm)object3).form;
            }
            if (object4 == LList.Empty) {
                return n;
            }
            if (!(object4 instanceof Pair)) {
                return -1 - n;
            }
            ++n;
            Object object5 = ((Pair)object4).cdr;
            while (object5 instanceof SyntaxForm) {
                object5 = ((SyntaxForm)object5).form;
            }
            if (object5 == LList.Empty) {
                return n;
            }
            if (!(object5 instanceof Pair)) {
                return -1 - n;
            }
            object3 = ((Pair)object3).cdr;
            object4 = ((Pair)object5).cdr;
            ++n;
            if (object4 == object3) break;
        }
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteInBody(Object object2) {
        if (object2 instanceof SyntaxForm) {
            SyntaxForm syntaxForm = (SyntaxForm)object2;
            ScopeExp scopeExp = this.current_scope;
            try {
                this.setCurrentScope(syntaxForm.scope);
                this.rewriteInBody(syntaxForm.form);
            }
            finally {
                this.setCurrentScope(scopeExp);
            }
        } else if (object2 instanceof Values) {
            Object[] objectArray = ((Values)object2).getValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.rewriteInBody(objectArray[i]);
            }
        } else {
            this.formStack.add(this.rewrite(object2, false));
        }
    }

    public Expression rewrite(Object object2) {
        return this.rewrite(object2, false);
    }

    public Object namespaceResolve(String string) {
        Object object2;
        Declaration declaration;
        Expression expression;
        int n = string.indexOf(58);
        if (n <= 0 || n >= string.length() - 1) {
            return string;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String string4 = ("$Namespace$" + string2).intern();
        Declaration declaration2 = this.lexical.lookup((Object)string4, 1);
        if (declaration2 instanceof Declaration && (expression = (declaration = Declaration.followAliases(declaration2)).getValue()) instanceof QuoteExp && ((object2 = ((QuoteExp)expression).getValue()) instanceof String || object2 instanceof FString || object2 instanceof Symbol && ((Symbol)object2).hasEmptyNamespace())) {
            return Symbol.make(object2.toString(), string3);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression namespaceResolve(String string, boolean bl) {
        Symbol symbol;
        int n = string.indexOf(58);
        if (n <= 0 || n >= string.length() - 1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if ("*".equals(string2)) {
            return ClassMethodProc.makeExp(QuoteExp.nullExp, new QuoteExp((Object)string3));
        }
        String string4 = ("$Namespace$" + string2).intern();
        Declaration declaration = this.lexical.lookup((Object)string4, 1);
        if (declaration instanceof Declaration) {
            String string5;
            int n2;
            Object object2;
            Object object3;
            Declaration declaration2 = Declaration.followAliases(declaration);
            Expression expression = declaration2.getValue();
            if (expression instanceof ReferenceExp && ((object3 = Declaration.followAliases(((AccessExp)(object2 = (ReferenceExp)expression)).getBinding())) != null ? (expression = ((Declaration)object3).getValue()) instanceof ClassExp : (n2 = (string5 = ((AccessExp)object2).getName()).length()) > 2 && string5.charAt(0) == '<' && string5.charAt(n2 - 1) == '>')) {
                return ClassMethodProc.makeExp((Expression)object2, new QuoteExp((Object)string3));
            }
            if (!(expression instanceof QuoteExp)) return null;
            object2 = ((QuoteExp)expression).getValue();
            if (object2 instanceof ClassType) {
                return ClassMethodProc.makeExp(expression, new QuoteExp((Object)string3));
            }
            object3 = object2.toString();
            if (((String)object3).startsWith("class:")) {
                return ClassMethodProc.makeExp(this.rewrite("<" + ((String)object3).substring(6) + ">"), new QuoteExp((Object)string3));
            }
            symbol = Symbol.make(object3, string3);
            return this.rewrite(symbol, bl);
        } else {
            Object object4 = this.env.get(string4, null);
            if (object4 instanceof ClassType) {
                return ClassMethodProc.makeExp(new QuoteExp(object4), new QuoteExp((Object)string3));
            }
            if (object4 != null) {
                String string6 = object4.toString();
                if (string6.startsWith("class:")) {
                    return ClassMethodProc.makeExp(this.rewrite("<" + string6.substring(6) + ">"), new QuoteExp((Object)string3));
                }
                symbol = Symbol.make(string6, string3);
                return this.rewrite(symbol, bl);
            } else {
                if (string2.length() > 2 && string2.charAt(0) == '<' && string2.charAt(string2.length() - 1) == '>') {
                    return ClassMethodProc.makeExp(this.rewrite(string2), new QuoteExp((Object)string3));
                }
                try {
                    Class<?> clazz = Class.forName(string2, false, this.getClass().getClassLoader());
                    return ClassMethodProc.makeExp(new QuoteExp(Type.make(clazz)), new QuoteExp((Object)string3));
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        }
    }

    public void setCurrentScope(ScopeExp scopeExp) {
        super.setCurrentScope(scopeExp);
        while (scopeExp != null && !(scopeExp instanceof PatternScope)) {
            scopeExp = scopeExp.outer;
        }
        this.patternScope = (PatternScope)scopeExp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression rewrite(Object object2, boolean bl) {
        if (object2 instanceof SyntaxForm) {
            SyntaxForm syntaxForm = (SyntaxForm)object2;
            ScopeExp scopeExp = this.current_scope;
            try {
                Expression expression;
                this.setCurrentScope(syntaxForm.scope);
                Expression expression2 = expression = this.rewrite(syntaxForm.form, bl);
                return expression2;
            }
            finally {
                this.setCurrentScope(scopeExp);
            }
        }
        if (object2 instanceof PairWithPosition) {
            return this.rewrite_with_position(object2, bl, (PairWithPosition)object2);
        }
        if (object2 instanceof Pair) {
            return this.rewrite_pair((Pair)object2);
        }
        if (object2 instanceof String || object2 instanceof Symbol && !this.selfEvaluatingSymbol(object2)) {
            Named named;
            Object object3;
            Object object4;
            Declaration declaration = this.lexical.lookup(object2, bl);
            Symbol symbol = null;
            if (declaration != null) {
                object4 = declaration.getSymbol();
                object2 = null;
                object3 = Translator.getOriginalRef(declaration);
                if (object3 != null && (declaration = ((AccessExp)object3).getBinding()) == null) {
                    object4 = object2 = ((AccessExp)object3).getSymbol();
                }
            } else {
                object4 = object2;
            }
            if (object4 instanceof String && declaration == null && (object3 = this.namespaceResolve((String)object4, bl)) != null) {
                return object3;
            }
            symbol = object2 instanceof String ? this.env.getSymbol((String)object2) : (Symbol)object2;
            object3 = this.resolve(symbol, bl);
            boolean bl2 = this.getLanguage().hasSeparateFunctionNamespace();
            if (declaration != null) {
                if (!this.isLexical(declaration) || bl2 && declaration.isProcedureDecl()) {
                    declaration = null;
                }
            } else if (object3 instanceof Named) {
                if (object3 instanceof AutoloadProcedure) {
                    try {
                        object3 = ((AutoloadProcedure)object3).getLoaded();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                named = (Named)object3;
                Location location2 = this.env.lookup(symbol, bl && bl2 ? EnvironmentKey.FUNCTION : null);
                if (location2 != null) {
                    location2 = location2.getBase();
                }
                if (location2 instanceof FieldLocation && this.inlineOk(null)) {
                    declaration = ((FieldLocation)location2).getDeclaration();
                }
            }
            if (declaration != null && declaration.getFlag(0x100000) && declaration.isProcedureDecl() && !bl) {
                return this.syntaxError("not implemented: variable reference to a method");
            }
            if (declaration != null && declaration.getContext() instanceof PatternScope) {
                return this.syntaxError("reference to pattern variable " + declaration.getName() + " outside syntax template");
            }
            named = new ReferenceExp(object4, declaration);
            if (this.current_scope instanceof TemplateScope && declaration != null && declaration.needsContext()) {
                ((AccessExp)named).setContextDecl(((TemplateScope)this.current_scope).macroContext);
            } else {
                this.checkMemberContext((AccessExp)named, declaration);
            }
            if (bl && bl2) {
                ((Expression)named).setFlag(4);
            }
            return named;
        }
        if (object2 instanceof LangExp) {
            return this.rewrite(((LangExp)object2).getLangValue(), bl);
        }
        if (object2 instanceof Expression) {
            return (Expression)object2;
        }
        return QuoteExp.getInstance(Quote.quote(object2, this));
    }

    public void checkMemberContext(AccessExp accessExp, Declaration declaration) {
        if (declaration == null || !declaration.getFlag(0x100000) || declaration.isStatic()) {
            return;
        }
        ScopeExp scopeExp = this.currentScope();
        while (true) {
            if (scopeExp == null) {
                throw new Error("internal error: missing " + declaration);
            }
            if (scopeExp.outer == declaration.context) break;
            scopeExp = scopeExp.outer;
        }
        accessExp.setContextDecl(scopeExp.firstDecl());
    }

    public static void setLine(Expression expression, Object object2) {
        if (object2 instanceof PairWithPosition) {
            PairWithPosition pairWithPosition = (PairWithPosition)object2;
            expression.setFile(pairWithPosition.getFile());
            expression.setLine(pairWithPosition.getLine(), pairWithPosition.getColumn());
        }
    }

    public static void setLine(Declaration declaration, Object object2) {
        if (object2 instanceof PairWithPosition) {
            PairWithPosition pairWithPosition = (PairWithPosition)object2;
            declaration.setFile(pairWithPosition.getFile());
            declaration.setLine(pairWithPosition.getLine(), pairWithPosition.getColumn());
        }
    }

    public Object pushPositionOf(Object object2) {
        if (object2 instanceof SyntaxForm) {
            object2 = ((SyntaxForm)object2).form;
        }
        if (!(object2 instanceof PairWithPosition)) {
            return null;
        }
        PairWithPosition pairWithPosition = (PairWithPosition)object2;
        PairWithPosition pairWithPosition2 = this.positionPair == null || this.positionPair.getFile() != this.getFile() || this.positionPair.getLine() != this.getLine() || this.positionPair.getColumn() != this.getColumn() ? PairWithPosition.make(Special.eof, this.positionPair, this.getFile(), this.getLine(), this.getColumn()) : this.positionPair;
        this.setLine(object2);
        this.positionPair = pairWithPosition;
        return pairWithPosition2;
    }

    public void popPositionOf(Object object2) {
        if (object2 == null) {
            return;
        }
        this.setLine(object2);
        this.positionPair = (PairWithPosition)object2;
        if (this.positionPair.car == Special.eof) {
            this.positionPair = (PairWithPosition)this.positionPair.cdr;
        }
    }

    public void setLine(Object object2) {
        if (object2 instanceof PairWithPosition) {
            PairWithPosition pairWithPosition = (PairWithPosition)object2;
            this.setLine(pairWithPosition.getFile(), pairWithPosition.getLine(), pairWithPosition.getColumn());
        }
    }

    public void setLineOf(Expression expression) {
        if (expression instanceof QuoteExp) {
            return;
        }
        if (expression.getFile() == null) {
            expression.setFile(this.getFile());
        }
        if (expression.getLine() == 0) {
            expression.setLine(this.getLine(), this.getColumn());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type exp2Type(Pair pair) {
        Object object2 = this.pushPositionOf(pair);
        try {
            Expression expression = this.rewrite_car(pair, false);
            if (expression instanceof ErrorExp) {
                Type type = null;
                return type;
            }
            Type type = this.getLanguage().getTypeFor(expression);
            if (type == null) {
                if (expression instanceof ReferenceExp) {
                    this.error('e', "unknown type name '" + ((ReferenceExp)expression).getName() + '\'');
                } else {
                    this.error('e', "invalid type spec (must be \"type\" or 'type or <type>)");
                }
                ClassType classType = Type.pointer_type;
                return classType;
            }
            Type type2 = type;
            return type2;
        }
        finally {
            this.popPositionOf(object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression rewrite_with_position(Object object2, boolean bl, PairWithPosition pairWithPosition) {
        Expression expression;
        Object object3 = this.pushPositionOf(pairWithPosition);
        try {
            expression = object2 == pairWithPosition ? this.rewrite_pair(pairWithPosition) : this.rewrite(object2, bl);
            this.setLineOf(expression);
        }
        finally {
            this.popPositionOf(object3);
        }
        return expression;
    }

    public static Object wrapSyntax(Object object2, SyntaxForm syntaxForm) {
        if (syntaxForm == null || object2 instanceof Expression) {
            return object2;
        }
        return syntaxForm.fromDatumIfNeeded(object2);
    }

    public Object popForms(int n) {
        Object object2;
        int n2 = this.formStack.size();
        if (n2 == n) {
            return Values.empty;
        }
        if (n2 == n + 1) {
            object2 = this.formStack.elementAt(n);
        } else {
            Values values = new Values();
            for (int i = n; i < n2; ++i) {
                values.writeObject(this.formStack.elementAt(i));
            }
            object2 = values;
        }
        this.formStack.setSize(n);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanForm(Object object2, ScopeExp scopeExp) {
        if (object2 instanceof SyntaxForm) {
            SyntaxForm syntaxForm = (SyntaxForm)object2;
            ScopeExp scopeExp2 = this.currentScope();
            try {
                this.setCurrentScope(syntaxForm.scope);
                int n = this.formStack.size();
                this.scanForm(syntaxForm.form, scopeExp);
                this.formStack.add(Translator.wrapSyntax(this.popForms(n), syntaxForm));
                return;
            }
            finally {
                this.setCurrentScope(scopeExp2);
            }
        }
        if (object2 instanceof Values) {
            if (object2 == Values.empty) {
                object2 = QuoteExp.voidExp;
            } else {
                Object[] objectArray = ((Values)object2).getValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    this.scanForm(objectArray[i], scopeExp);
                }
                return;
            }
        }
        if (object2 instanceof Pair) {
            Object object3;
            Pair pair = (Pair)object2;
            Declaration declaration = this.macroContext;
            Syntax syntax2 = null;
            ScopeExp scopeExp3 = this.current_scope;
            try {
                Object object4;
                object3 = pair.car;
                if (object3 instanceof SyntaxForm) {
                    object4 = (SyntaxForm)pair.car;
                    this.setCurrentScope(((SyntaxForm)object4).scope);
                    object3 = ((SyntaxForm)object4).form;
                }
                if (object3 instanceof String || object3 instanceof Symbol && !this.selfEvaluatingSymbol(object3)) {
                    object4 = this.lexical.lookup(object3, true);
                    if (object4 != null) {
                        syntax2 = this.check_if_Syntax((Declaration)object4);
                    } else if ((object3 = this.resolve(object3, true)) instanceof Syntax) {
                        syntax2 = (Syntax)object3;
                    }
                }
            }
            finally {
                if (scopeExp3 != this.current_scope) {
                    this.setCurrentScope(scopeExp3);
                }
            }
            if (syntax2 != null) {
                object3 = this.getFile();
                int n = this.getLine();
                int n2 = this.getColumn();
                try {
                    this.setLine(pair);
                    syntax2.scanForm(pair, scopeExp, this);
                    return;
                }
                finally {
                    this.macroContext = declaration;
                    this.setLine((String)object3, n, n2);
                }
            }
        }
        this.formStack.add(object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object scanBody(Object object2, ScopeExp scopeExp, boolean bl) {
        Object object3 = bl ? LList.Empty : null;
        Object object4 = null;
        while (object2 != LList.Empty) {
            Object object5;
            int n;
            Externalizable externalizable;
            if (object2 instanceof SyntaxForm) {
                externalizable = (SyntaxForm)object2;
                ScopeExp scopeExp2 = this.current_scope;
                try {
                    this.setCurrentScope(externalizable.scope);
                    n = this.formStack.size();
                    this.scanBody(externalizable.form, scopeExp, false);
                    Object object6 = Translator.wrapSyntax(this.popForms(n), externalizable);
                    if (bl) {
                        if (object4 == null) {
                            object5 = object6;
                            return object5;
                        }
                        ((Pair)object4).cdr = object6;
                        object5 = object3;
                        return object5;
                    }
                    this.formStack.add(object6);
                    object5 = null;
                    return object5;
                }
                finally {
                    this.setCurrentScope(scopeExp2);
                }
            }
            if (object2 instanceof Pair) {
                externalizable = (Pair)object2;
                int n2 = this.formStack.size();
                this.scanForm(((Pair)externalizable).car, scopeExp);
                n = this.formStack.size();
                if (bl) {
                    for (int i = n2; i < n; ++i) {
                        object5 = Translator.makePair((Pair)externalizable, this.formStack.elementAt(i), LList.Empty);
                        if (object4 == null) {
                            object3 = object5;
                        } else {
                            ((Pair)object4).cdr = object5;
                        }
                        object4 = object5;
                    }
                    this.formStack.setSize(n2);
                }
                object2 = ((Pair)externalizable).cdr;
                continue;
            }
            this.formStack.add(this.syntaxError("body is not a proper list"));
            break;
        }
        return object3;
    }

    public static Pair makePair(Pair pair, Object object2, Object object3) {
        if (pair instanceof PairWithPosition) {
            return new PairWithPosition((PairWithPosition)pair, object2, object3);
        }
        return new Pair(object2, object3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression rewrite_body(Object object2) {
        Object object3 = this.pushPositionOf(object2);
        LetExp letExp = new LetExp(null);
        int n = this.formStack.size();
        letExp.outer = this.current_scope;
        this.current_scope = letExp;
        try {
            Object object4;
            int n2;
            this.scanBody(object2, letExp, false);
            if (this.formStack.size() == n) {
                this.formStack.add(this.syntaxError("body with no expressions"));
            }
            if ((n2 = letExp.countDecls()) != 0) {
                object4 = new Expression[n2];
                int n3 = n2;
                while (--n3 >= 0) {
                    object4[n3] = QuoteExp.undefined_exp;
                }
                letExp.inits = object4;
            }
            object4 = this.makeBody(n, null);
            this.setLineOf((Expression)object4);
            if (n2 == 0) {
                Object object5 = object4;
                return object5;
            }
            this.mustCompileHere();
            letExp.body = object4;
            this.setLineOf(letExp);
            LetExp letExp2 = letExp;
            return letExp2;
        }
        finally {
            this.pop(letExp);
            this.popPositionOf(object3);
        }
    }

    public void rewriteBody(int n) {
        int n2 = this.formStack.size() - n;
        if (n2 == 0) {
            return;
        }
        if (n2 == 1) {
            Object e = this.formStack.pop();
            this.rewriteInBody(e);
        } else {
            int n3;
            Object[] objectArray = new Object[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                objectArray[n3] = this.formStack.elementAt(n + n3);
            }
            this.formStack.setSize(n);
            for (n3 = 0; n3 < n2; ++n3) {
                this.rewriteInBody(objectArray[n3]);
            }
        }
    }

    public Expression makeBody(int n, ScopeExp scopeExp) {
        this.rewriteBody(n);
        int n2 = this.formStack.size() - n;
        if (n2 == 0) {
            return QuoteExp.voidExp;
        }
        if (n2 == 1) {
            return (Expression)this.formStack.pop();
        }
        Expression[] expressionArray = new Expression[n2];
        for (int i = 0; i < n2; ++i) {
            expressionArray[i] = (Expression)this.formStack.elementAt(n + i);
        }
        this.formStack.setSize(n);
        if (scopeExp instanceof ModuleExp) {
            return new ApplyExp(AppendValues.appendValues, expressionArray);
        }
        return ((LispLanguage)this.getLanguage()).makeBody(expressionArray);
    }

    public void noteAccess(Object object2, ScopeExp scopeExp) {
        if (this.notedAccess == null) {
            this.notedAccess = new Vector();
        }
        this.notedAccess.addElement(object2);
        this.notedAccess.addElement(scopeExp);
    }

    public void processAccesses() {
        if (this.notedAccess == null) {
            return;
        }
        int n = this.notedAccess.size();
        ScopeExp scopeExp = this.current_scope;
        for (int i = 0; i < n; i += 2) {
            Declaration declaration;
            Object e = this.notedAccess.elementAt(i);
            ScopeExp scopeExp2 = (ScopeExp)this.notedAccess.elementAt(i + 1);
            if (this.current_scope != scopeExp2) {
                this.setCurrentScope(scopeExp2);
            }
            if ((declaration = this.lexical.lookup(e, -1)) == null || declaration.getFlag(65536)) continue;
            declaration.getContext().currentLambda().capture(declaration);
            declaration.setCanRead(true);
            declaration.setSimple(false);
            declaration.setFlag(524288);
        }
        if (this.current_scope != scopeExp) {
            this.setCurrentScope(scopeExp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishModule(ModuleExp moduleExp, int n) {
        Object object2;
        boolean bl = moduleExp.isStatic();
        for (object2 = moduleExp.firstDecl(); object2 != null; object2 = ((Declaration)object2).nextDecl()) {
            if (((Declaration)object2).getFlag(512) && !((Declaration)object2).getFlag(65536)) {
                String string = "'";
                String string2 = ((Declaration)object2).getFlag(1024) ? "' exported but never defined" : (((Declaration)object2).getFlag(2048) ? "' declared static but never defined" : "' declared but never defined");
                this.error('e', (Declaration)object2, string, string2);
            }
            if (moduleExp.getFlag(2048)) {
                if (((Declaration)object2).getFlag(1024)) {
                    if (((Declaration)object2).isPrivate()) {
                        if (((Declaration)object2).getFlag(0x1000000)) {
                            this.error('e', (Declaration)object2, "'", "' is declared both private and exported");
                        }
                        ((Declaration)object2).setPrivate(false);
                    }
                } else {
                    ((Declaration)object2).setPrivate(true);
                }
            }
            if (bl) {
                ((Declaration)object2).setFlag(2048);
                continue;
            }
            if ((!moduleExp.getFlag(8192) || ((Declaration)object2).getFlag(2048)) && Compilation.moduleStatic >= 0 && !moduleExp.getFlag(16384)) continue;
            ((Declaration)object2).setFlag(4096);
        }
        if (!bl) {
            moduleExp.declareThis(null);
        }
        this.processAccesses();
        this.setModule(moduleExp);
        object2 = Compilation.getCurrent();
        try {
            Compilation.setCurrent(this);
            moduleExp.body = this.makeBody(n, moduleExp);
            this.lexical.pop(moduleExp);
        }
        finally {
            Compilation.setCurrent((Compilation)object2);
        }
    }

    public Declaration makeRenamedAlias(Declaration declaration, ScopeExp scopeExp) {
        if (scopeExp == null) {
            return declaration;
        }
        return this.makeRenamedAlias(declaration.getSymbol(), declaration, scopeExp);
    }

    public Declaration makeRenamedAlias(Object object2, Declaration declaration, ScopeExp scopeExp) {
        Declaration declaration2 = new Declaration(object2);
        declaration2.setAlias(true);
        declaration2.setPrivate(true);
        declaration2.context = scopeExp;
        ReferenceExp referenceExp = new ReferenceExp(declaration);
        referenceExp.setDontDereference(true);
        declaration2.noteValue(referenceExp);
        return declaration2;
    }

    public void pushRenamedAlias(Declaration declaration) {
        Declaration declaration2 = Translator.getOriginalRef(declaration).getBinding();
        ScopeExp scopeExp = declaration.context;
        declaration2.setSymbol(null);
        Declaration declaration3 = scopeExp.lookup(declaration2.getSymbol());
        if (declaration3 != null) {
            scopeExp.remove(declaration3);
        }
        scopeExp.addDeclaration(declaration);
        if (this.renamedAliasStack == null) {
            this.renamedAliasStack = new Stack();
        }
        this.renamedAliasStack.push(declaration3);
        this.renamedAliasStack.push(declaration);
        this.renamedAliasStack.push(scopeExp);
    }

    public void popRenamedAlias(int n) {
        while (--n >= 0) {
            ScopeExp scopeExp = (ScopeExp)this.renamedAliasStack.pop();
            Declaration declaration = (Declaration)this.renamedAliasStack.pop();
            Declaration declaration2 = Translator.getOriginalRef(declaration).getBinding();
            declaration2.setSymbol(declaration.getSymbol());
            scopeExp.remove(declaration);
            Object e = this.renamedAliasStack.pop();
            if (e == null) continue;
            scopeExp.addDeclaration((Declaration)e);
        }
    }

    public Declaration define(Object object2, SyntaxForm syntaxForm, ScopeExp scopeExp) {
        boolean bl = syntaxForm != null && syntaxForm.scope != this.currentScope();
        Object object3 = bl ? new String(object2.toString()) : object2;
        Declaration declaration = scopeExp.getDefine(object3, 'w', this);
        if (bl) {
            Declaration declaration2 = this.makeRenamedAlias(object2, declaration, syntaxForm.scope);
            syntaxForm.scope.addDeclaration(declaration2);
        }
        this.push(declaration);
        return declaration;
    }
}

